/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMetricAttributionRequest extends PersonalizeRequest implements
        ToCopyableBuilder<CreateMetricAttributionRequest.Builder, CreateMetricAttributionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateMetricAttributionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetGroupArn").getter(getter(CreateMetricAttributionRequest::datasetGroupArn))
            .setter(setter(Builder::datasetGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetGroupArn").build()).build();

    private static final SdkField<List<MetricAttribute>> METRICS_FIELD = SdkField
            .<List<MetricAttribute>> builder(MarshallingType.LIST)
            .memberName("metrics")
            .getter(getter(CreateMetricAttributionRequest::metrics))
            .setter(setter(Builder::metrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MetricAttributionOutput> METRICS_OUTPUT_CONFIG_FIELD = SdkField
            .<MetricAttributionOutput> builder(MarshallingType.SDK_POJO).memberName("metricsOutputConfig")
            .getter(getter(CreateMetricAttributionRequest::metricsOutputConfig)).setter(setter(Builder::metricsOutputConfig))
            .constructor(MetricAttributionOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsOutputConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            DATASET_GROUP_ARN_FIELD, METRICS_FIELD, METRICS_OUTPUT_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String datasetGroupArn;

    private final List<MetricAttribute> metrics;

    private final MetricAttributionOutput metricsOutputConfig;

    private CreateMetricAttributionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.datasetGroupArn = builder.datasetGroupArn;
        this.metrics = builder.metrics;
        this.metricsOutputConfig = builder.metricsOutputConfig;
    }

    /**
     * <p>
     * A name for the metric attribution.
     * </p>
     * 
     * @return A name for the metric attribution.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the destination dataset group for the metric attribution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the destination dataset group for the metric attribution.
     */
    public final String datasetGroupArn() {
        return datasetGroupArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metrics property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetrics() {
        return metrics != null && !(metrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of metric attributes for the metric attribution. Each metric attribute specifies an event type to track
     * and a function. Available functions are <code>SUM()</code> or <code>SAMPLECOUNT()</code>. For SUM() functions,
     * provide the dataset type (either Interactions or Items) and column to sum as a parameter. For example
     * SUM(Items.PRICE).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetrics} method.
     * </p>
     * 
     * @return A list of metric attributes for the metric attribution. Each metric attribute specifies an event type to
     *         track and a function. Available functions are <code>SUM()</code> or <code>SAMPLECOUNT()</code>. For SUM()
     *         functions, provide the dataset type (either Interactions or Items) and column to sum as a parameter. For
     *         example SUM(Items.PRICE).
     */
    public final List<MetricAttribute> metrics() {
        return metrics;
    }

    /**
     * <p>
     * The output configuration details for the metric attribution.
     * </p>
     * 
     * @return The output configuration details for the metric attribution.
     */
    public final MetricAttributionOutput metricsOutputConfig() {
        return metricsOutputConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetrics() ? metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(metricsOutputConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMetricAttributionRequest)) {
            return false;
        }
        CreateMetricAttributionRequest other = (CreateMetricAttributionRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(datasetGroupArn(), other.datasetGroupArn())
                && hasMetrics() == other.hasMetrics() && Objects.equals(metrics(), other.metrics())
                && Objects.equals(metricsOutputConfig(), other.metricsOutputConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMetricAttributionRequest").add("Name", name()).add("DatasetGroupArn", datasetGroupArn())
                .add("Metrics", hasMetrics() ? metrics() : null).add("MetricsOutputConfig", metricsOutputConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "datasetGroupArn":
            return Optional.ofNullable(clazz.cast(datasetGroupArn()));
        case "metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        case "metricsOutputConfig":
            return Optional.ofNullable(clazz.cast(metricsOutputConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("datasetGroupArn", DATASET_GROUP_ARN_FIELD);
        map.put("metrics", METRICS_FIELD);
        map.put("metricsOutputConfig", METRICS_OUTPUT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMetricAttributionRequest, T> g) {
        return obj -> g.apply((CreateMetricAttributionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PersonalizeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMetricAttributionRequest> {
        /**
         * <p>
         * A name for the metric attribution.
         * </p>
         * 
         * @param name
         *        A name for the metric attribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the destination dataset group for the metric attribution.
         * </p>
         * 
         * @param datasetGroupArn
         *        The Amazon Resource Name (ARN) of the destination dataset group for the metric attribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetGroupArn(String datasetGroupArn);

        /**
         * <p>
         * A list of metric attributes for the metric attribution. Each metric attribute specifies an event type to
         * track and a function. Available functions are <code>SUM()</code> or <code>SAMPLECOUNT()</code>. For SUM()
         * functions, provide the dataset type (either Interactions or Items) and column to sum as a parameter. For
         * example SUM(Items.PRICE).
         * </p>
         * 
         * @param metrics
         *        A list of metric attributes for the metric attribution. Each metric attribute specifies an event type
         *        to track and a function. Available functions are <code>SUM()</code> or <code>SAMPLECOUNT()</code>. For
         *        SUM() functions, provide the dataset type (either Interactions or Items) and column to sum as a
         *        parameter. For example SUM(Items.PRICE).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Collection<MetricAttribute> metrics);

        /**
         * <p>
         * A list of metric attributes for the metric attribution. Each metric attribute specifies an event type to
         * track and a function. Available functions are <code>SUM()</code> or <code>SAMPLECOUNT()</code>. For SUM()
         * functions, provide the dataset type (either Interactions or Items) and column to sum as a parameter. For
         * example SUM(Items.PRICE).
         * </p>
         * 
         * @param metrics
         *        A list of metric attributes for the metric attribution. Each metric attribute specifies an event type
         *        to track and a function. Available functions are <code>SUM()</code> or <code>SAMPLECOUNT()</code>. For
         *        SUM() functions, provide the dataset type (either Interactions or Items) and column to sum as a
         *        parameter. For example SUM(Items.PRICE).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(MetricAttribute... metrics);

        /**
         * <p>
         * A list of metric attributes for the metric attribution. Each metric attribute specifies an event type to
         * track and a function. Available functions are <code>SUM()</code> or <code>SAMPLECOUNT()</code>. For SUM()
         * functions, provide the dataset type (either Interactions or Items) and column to sum as a parameter. For
         * example SUM(Items.PRICE).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.personalize.model.MetricAttribute.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.personalize.model.MetricAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.personalize.model.MetricAttribute.Builder#build()} is called
         * immediately and its result is passed to {@link #metrics(List<MetricAttribute>)}.
         * 
         * @param metrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.personalize.model.MetricAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metrics(java.util.Collection<MetricAttribute>)
         */
        Builder metrics(Consumer<MetricAttribute.Builder>... metrics);

        /**
         * <p>
         * The output configuration details for the metric attribution.
         * </p>
         * 
         * @param metricsOutputConfig
         *        The output configuration details for the metric attribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsOutputConfig(MetricAttributionOutput metricsOutputConfig);

        /**
         * <p>
         * The output configuration details for the metric attribution.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetricAttributionOutput.Builder} avoiding
         * the need to create one manually via {@link MetricAttributionOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetricAttributionOutput.Builder#build()} is called immediately
         * and its result is passed to {@link #metricsOutputConfig(MetricAttributionOutput)}.
         * 
         * @param metricsOutputConfig
         *        a consumer that will call methods on {@link MetricAttributionOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricsOutputConfig(MetricAttributionOutput)
         */
        default Builder metricsOutputConfig(Consumer<MetricAttributionOutput.Builder> metricsOutputConfig) {
            return metricsOutputConfig(MetricAttributionOutput.builder().applyMutation(metricsOutputConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PersonalizeRequest.BuilderImpl implements Builder {
        private String name;

        private String datasetGroupArn;

        private List<MetricAttribute> metrics = DefaultSdkAutoConstructList.getInstance();

        private MetricAttributionOutput metricsOutputConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMetricAttributionRequest model) {
            super(model);
            name(model.name);
            datasetGroupArn(model.datasetGroupArn);
            metrics(model.metrics);
            metricsOutputConfig(model.metricsOutputConfig);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDatasetGroupArn() {
            return datasetGroupArn;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        @Override
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final List<MetricAttribute.Builder> getMetrics() {
            List<MetricAttribute.Builder> result = MetricAttributesCopier.copyToBuilder(this.metrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetrics(Collection<MetricAttribute.BuilderImpl> metrics) {
            this.metrics = MetricAttributesCopier.copyFromBuilder(metrics);
        }

        @Override
        public final Builder metrics(Collection<MetricAttribute> metrics) {
            this.metrics = MetricAttributesCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(MetricAttribute... metrics) {
            metrics(Arrays.asList(metrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Consumer<MetricAttribute.Builder>... metrics) {
            metrics(Stream.of(metrics).map(c -> MetricAttribute.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final MetricAttributionOutput.Builder getMetricsOutputConfig() {
            return metricsOutputConfig != null ? metricsOutputConfig.toBuilder() : null;
        }

        public final void setMetricsOutputConfig(MetricAttributionOutput.BuilderImpl metricsOutputConfig) {
            this.metricsOutputConfig = metricsOutputConfig != null ? metricsOutputConfig.build() : null;
        }

        @Override
        public final Builder metricsOutputConfig(MetricAttributionOutput metricsOutputConfig) {
            this.metricsOutputConfig = metricsOutputConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMetricAttributionRequest build() {
            return new CreateMetricAttributionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
