/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration of events, which are used in solution creation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventsConfig implements SdkPojo, Serializable, ToCopyableBuilder<EventsConfig.Builder, EventsConfig> {
    private static final SdkField<List<EventParameters>> EVENT_PARAMETERS_LIST_FIELD = SdkField
            .<List<EventParameters>> builder(MarshallingType.LIST)
            .memberName("eventParametersList")
            .getter(getter(EventsConfig::eventParametersList))
            .setter(setter(Builder::eventParametersList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventParametersList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventParameters> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventParameters::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_PARAMETERS_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<EventParameters> eventParametersList;

    private EventsConfig(BuilderImpl builder) {
        this.eventParametersList = builder.eventParametersList;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventParametersList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventParametersList() {
        return eventParametersList != null && !(eventParametersList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of event parameters, which includes event types and their event value thresholds and weights.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventParametersList} method.
     * </p>
     * 
     * @return A list of event parameters, which includes event types and their event value thresholds and weights.
     */
    public final List<EventParameters> eventParametersList() {
        return eventParametersList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEventParametersList() ? eventParametersList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventsConfig)) {
            return false;
        }
        EventsConfig other = (EventsConfig) obj;
        return hasEventParametersList() == other.hasEventParametersList()
                && Objects.equals(eventParametersList(), other.eventParametersList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventsConfig")
                .add("EventParametersList", hasEventParametersList() ? eventParametersList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventParametersList":
            return Optional.ofNullable(clazz.cast(eventParametersList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("eventParametersList", EVENT_PARAMETERS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventsConfig, T> g) {
        return obj -> g.apply((EventsConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventsConfig> {
        /**
         * <p>
         * A list of event parameters, which includes event types and their event value thresholds and weights.
         * </p>
         * 
         * @param eventParametersList
         *        A list of event parameters, which includes event types and their event value thresholds and weights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventParametersList(Collection<EventParameters> eventParametersList);

        /**
         * <p>
         * A list of event parameters, which includes event types and their event value thresholds and weights.
         * </p>
         * 
         * @param eventParametersList
         *        A list of event parameters, which includes event types and their event value thresholds and weights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventParametersList(EventParameters... eventParametersList);

        /**
         * <p>
         * A list of event parameters, which includes event types and their event value thresholds and weights.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.personalize.model.EventParameters.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.personalize.model.EventParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.personalize.model.EventParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #eventParametersList(List<EventParameters>)}.
         * 
         * @param eventParametersList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.personalize.model.EventParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventParametersList(java.util.Collection<EventParameters>)
         */
        Builder eventParametersList(Consumer<EventParameters.Builder>... eventParametersList);
    }

    static final class BuilderImpl implements Builder {
        private List<EventParameters> eventParametersList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventsConfig model) {
            eventParametersList(model.eventParametersList);
        }

        public final List<EventParameters.Builder> getEventParametersList() {
            List<EventParameters.Builder> result = EventParametersListCopier.copyToBuilder(this.eventParametersList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventParametersList(Collection<EventParameters.BuilderImpl> eventParametersList) {
            this.eventParametersList = EventParametersListCopier.copyFromBuilder(eventParametersList);
        }

        @Override
        public final Builder eventParametersList(Collection<EventParameters> eventParametersList) {
            this.eventParametersList = EventParametersListCopier.copy(eventParametersList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventParametersList(EventParameters... eventParametersList) {
            eventParametersList(Arrays.asList(eventParametersList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventParametersList(Consumer<EventParameters.Builder>... eventParametersList) {
            eventParametersList(Stream.of(eventParametersList).map(c -> EventParameters.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public EventsConfig build() {
            return new EventsConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
