/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMetricAttributionMetricsRequest extends PersonalizeRequest implements
        ToCopyableBuilder<ListMetricAttributionMetricsRequest.Builder, ListMetricAttributionMetricsRequest> {
    private static final SdkField<String> METRIC_ATTRIBUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricAttributionArn").getter(getter(ListMetricAttributionMetricsRequest::metricAttributionArn))
            .setter(setter(Builder::metricAttributionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricAttributionArn").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListMetricAttributionMetricsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListMetricAttributionMetricsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_ATTRIBUTION_ARN_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String metricAttributionArn;

    private final String nextToken;

    private final Integer maxResults;

    private ListMetricAttributionMetricsRequest(BuilderImpl builder) {
        super(builder);
        this.metricAttributionArn = builder.metricAttributionArn;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the metric attribution to retrieve attributes for.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the metric attribution to retrieve attributes for.
     */
    public final String metricAttributionArn() {
        return metricAttributionArn;
    }

    /**
     * <p>
     * Specify the pagination token from a previous request to retrieve the next page of results.
     * </p>
     * 
     * @return Specify the pagination token from a previous request to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of metrics to return in one page of results.
     * </p>
     * 
     * @return The maximum number of metrics to return in one page of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metricAttributionArn());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMetricAttributionMetricsRequest)) {
            return false;
        }
        ListMetricAttributionMetricsRequest other = (ListMetricAttributionMetricsRequest) obj;
        return Objects.equals(metricAttributionArn(), other.metricAttributionArn())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMetricAttributionMetricsRequest").add("MetricAttributionArn", metricAttributionArn())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metricAttributionArn":
            return Optional.ofNullable(clazz.cast(metricAttributionArn()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("metricAttributionArn", METRIC_ATTRIBUTION_ARN_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMetricAttributionMetricsRequest, T> g) {
        return obj -> g.apply((ListMetricAttributionMetricsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PersonalizeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListMetricAttributionMetricsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the metric attribution to retrieve attributes for.
         * </p>
         * 
         * @param metricAttributionArn
         *        The Amazon Resource Name (ARN) of the metric attribution to retrieve attributes for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricAttributionArn(String metricAttributionArn);

        /**
         * <p>
         * Specify the pagination token from a previous request to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specify the pagination token from a previous request to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of metrics to return in one page of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of metrics to return in one page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PersonalizeRequest.BuilderImpl implements Builder {
        private String metricAttributionArn;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMetricAttributionMetricsRequest model) {
            super(model);
            metricAttributionArn(model.metricAttributionArn);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getMetricAttributionArn() {
            return metricAttributionArn;
        }

        public final void setMetricAttributionArn(String metricAttributionArn) {
            this.metricAttributionArn = metricAttributionArn;
        }

        @Override
        public final Builder metricAttributionArn(String metricAttributionArn) {
            this.metricAttributionArn = metricAttributionArn;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListMetricAttributionMetricsRequest build() {
            return new ListMetricAttributionMetricsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
