/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRecipesRequest extends PersonalizeRequest implements
        ToCopyableBuilder<ListRecipesRequest.Builder, ListRecipesRequest> {
    private static final SdkField<String> RECIPE_PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recipeProvider").getter(getter(ListRecipesRequest::recipeProviderAsString))
            .setter(setter(Builder::recipeProvider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipeProvider").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListRecipesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListRecipesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(ListRecipesRequest::domainAsString)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECIPE_PROVIDER_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, DOMAIN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String recipeProvider;

    private final String nextToken;

    private final Integer maxResults;

    private final String domain;

    private ListRecipesRequest(BuilderImpl builder) {
        super(builder);
        this.recipeProvider = builder.recipeProvider;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.domain = builder.domain;
    }

    /**
     * <p>
     * The default is <code>SERVICE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recipeProvider}
     * will return {@link RecipeProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #recipeProviderAsString}.
     * </p>
     * 
     * @return The default is <code>SERVICE</code>.
     * @see RecipeProvider
     */
    public final RecipeProvider recipeProvider() {
        return RecipeProvider.fromValue(recipeProvider);
    }

    /**
     * <p>
     * The default is <code>SERVICE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recipeProvider}
     * will return {@link RecipeProvider#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #recipeProviderAsString}.
     * </p>
     * 
     * @return The default is <code>SERVICE</code>.
     * @see RecipeProvider
     */
    public final String recipeProviderAsString() {
        return recipeProvider;
    }

    /**
     * <p>
     * A token returned from the previous call to <code>ListRecipes</code> for getting the next set of recipes (if they
     * exist).
     * </p>
     * 
     * @return A token returned from the previous call to <code>ListRecipes</code> for getting the next set of recipes
     *         (if they exist).
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of recipes to return.
     * </p>
     * 
     * @return The maximum number of recipes to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Filters returned recipes by domain for a Domain dataset group. Only recipes (Domain dataset group use cases) for
     * this domain are included in the response. If you don't specify a domain, all recipes are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domain} will
     * return {@link Domain#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainAsString}.
     * </p>
     * 
     * @return Filters returned recipes by domain for a Domain dataset group. Only recipes (Domain dataset group use
     *         cases) for this domain are included in the response. If you don't specify a domain, all recipes are
     *         returned.
     * @see Domain
     */
    public final Domain domain() {
        return Domain.fromValue(domain);
    }

    /**
     * <p>
     * Filters returned recipes by domain for a Domain dataset group. Only recipes (Domain dataset group use cases) for
     * this domain are included in the response. If you don't specify a domain, all recipes are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domain} will
     * return {@link Domain#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainAsString}.
     * </p>
     * 
     * @return Filters returned recipes by domain for a Domain dataset group. Only recipes (Domain dataset group use
     *         cases) for this domain are included in the response. If you don't specify a domain, all recipes are
     *         returned.
     * @see Domain
     */
    public final String domainAsString() {
        return domain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(recipeProviderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(domainAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecipesRequest)) {
            return false;
        }
        ListRecipesRequest other = (ListRecipesRequest) obj;
        return Objects.equals(recipeProviderAsString(), other.recipeProviderAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(domainAsString(), other.domainAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRecipesRequest").add("RecipeProvider", recipeProviderAsString())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).add("Domain", domainAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recipeProvider":
            return Optional.ofNullable(clazz.cast(recipeProviderAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "domain":
            return Optional.ofNullable(clazz.cast(domainAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("recipeProvider", RECIPE_PROVIDER_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("domain", DOMAIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRecipesRequest, T> g) {
        return obj -> g.apply((ListRecipesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PersonalizeRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListRecipesRequest> {
        /**
         * <p>
         * The default is <code>SERVICE</code>.
         * </p>
         * 
         * @param recipeProvider
         *        The default is <code>SERVICE</code>.
         * @see RecipeProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecipeProvider
         */
        Builder recipeProvider(String recipeProvider);

        /**
         * <p>
         * The default is <code>SERVICE</code>.
         * </p>
         * 
         * @param recipeProvider
         *        The default is <code>SERVICE</code>.
         * @see RecipeProvider
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecipeProvider
         */
        Builder recipeProvider(RecipeProvider recipeProvider);

        /**
         * <p>
         * A token returned from the previous call to <code>ListRecipes</code> for getting the next set of recipes (if
         * they exist).
         * </p>
         * 
         * @param nextToken
         *        A token returned from the previous call to <code>ListRecipes</code> for getting the next set of
         *        recipes (if they exist).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of recipes to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of recipes to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Filters returned recipes by domain for a Domain dataset group. Only recipes (Domain dataset group use cases)
         * for this domain are included in the response. If you don't specify a domain, all recipes are returned.
         * </p>
         * 
         * @param domain
         *        Filters returned recipes by domain for a Domain dataset group. Only recipes (Domain dataset group use
         *        cases) for this domain are included in the response. If you don't specify a domain, all recipes are
         *        returned.
         * @see Domain
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Domain
         */
        Builder domain(String domain);

        /**
         * <p>
         * Filters returned recipes by domain for a Domain dataset group. Only recipes (Domain dataset group use cases)
         * for this domain are included in the response. If you don't specify a domain, all recipes are returned.
         * </p>
         * 
         * @param domain
         *        Filters returned recipes by domain for a Domain dataset group. Only recipes (Domain dataset group use
         *        cases) for this domain are included in the response. If you don't specify a domain, all recipes are
         *        returned.
         * @see Domain
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Domain
         */
        Builder domain(Domain domain);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PersonalizeRequest.BuilderImpl implements Builder {
        private String recipeProvider;

        private String nextToken;

        private Integer maxResults;

        private String domain;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecipesRequest model) {
            super(model);
            recipeProvider(model.recipeProvider);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            domain(model.domain);
        }

        public final String getRecipeProvider() {
            return recipeProvider;
        }

        public final void setRecipeProvider(String recipeProvider) {
            this.recipeProvider = recipeProvider;
        }

        @Override
        public final Builder recipeProvider(String recipeProvider) {
            this.recipeProvider = recipeProvider;
            return this;
        }

        @Override
        public final Builder recipeProvider(RecipeProvider recipeProvider) {
            this.recipeProvider(recipeProvider == null ? null : recipeProvider.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public final Builder domain(Domain domain) {
            this.domain(domain == null ? null : domain.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRecipesRequest build() {
            return new ListRecipesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
