/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When the solution performs AutoML (<code>performAutoML</code> is true in <a>CreateSolution</a>), specifies the recipe
 * that best optimized the specified metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoMLResult implements SdkPojo, Serializable, ToCopyableBuilder<AutoMLResult.Builder, AutoMLResult> {
    private static final SdkField<String> BEST_RECIPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutoMLResult::bestRecipeArn)).setter(setter(Builder::bestRecipeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bestRecipeArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEST_RECIPE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bestRecipeArn;

    private AutoMLResult(BuilderImpl builder) {
        this.bestRecipeArn = builder.bestRecipeArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the best recipe.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the best recipe.
     */
    public String bestRecipeArn() {
        return bestRecipeArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bestRecipeArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLResult)) {
            return false;
        }
        AutoMLResult other = (AutoMLResult) obj;
        return Objects.equals(bestRecipeArn(), other.bestRecipeArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AutoMLResult").add("BestRecipeArn", bestRecipeArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bestRecipeArn":
            return Optional.ofNullable(clazz.cast(bestRecipeArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoMLResult, T> g) {
        return obj -> g.apply((AutoMLResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoMLResult> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the best recipe.
         * </p>
         * 
         * @param bestRecipeArn
         *        The Amazon Resource Name (ARN) of the best recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bestRecipeArn(String bestRecipeArn);
    }

    static final class BuilderImpl implements Builder {
        private String bestRecipeArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLResult model) {
            bestRecipeArn(model.bestRecipeArn);
        }

        public final String getBestRecipeArn() {
            return bestRecipeArn;
        }

        @Override
        public final Builder bestRecipeArn(String bestRecipeArn) {
            this.bestRecipeArn = bestRecipeArn;
            return this;
        }

        public final void setBestRecipeArn(String bestRecipeArn) {
            this.bestRecipeArn = bestRecipeArn;
        }

        @Override
        public AutoMLResult build() {
            return new AutoMLResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
