/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the name and default range of a continuous hyperparameter and whether the hyperparameter is tunable. A
 * tunable hyperparameter can have its value determined during hyperparameter optimization (HPO).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultContinuousHyperParameterRange implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultContinuousHyperParameterRange.Builder, DefaultContinuousHyperParameterRange> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DefaultContinuousHyperParameterRange::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Double> MIN_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(DefaultContinuousHyperParameterRange::minValue)).setter(setter(Builder::minValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minValue").build()).build();

    private static final SdkField<Double> MAX_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(DefaultContinuousHyperParameterRange::maxValue)).setter(setter(Builder::maxValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxValue").build()).build();

    private static final SdkField<Boolean> IS_TUNABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DefaultContinuousHyperParameterRange::isTunable)).setter(setter(Builder::isTunable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isTunable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MIN_VALUE_FIELD,
            MAX_VALUE_FIELD, IS_TUNABLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Double minValue;

    private final Double maxValue;

    private final Boolean isTunable;

    private DefaultContinuousHyperParameterRange(BuilderImpl builder) {
        this.name = builder.name;
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
        this.isTunable = builder.isTunable;
    }

    /**
     * <p>
     * The name of the hyperparameter.
     * </p>
     * 
     * @return The name of the hyperparameter.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The minimum allowable value for the hyperparameter.
     * </p>
     * 
     * @return The minimum allowable value for the hyperparameter.
     */
    public Double minValue() {
        return minValue;
    }

    /**
     * <p>
     * The maximum allowable value for the hyperparameter.
     * </p>
     * 
     * @return The maximum allowable value for the hyperparameter.
     */
    public Double maxValue() {
        return maxValue;
    }

    /**
     * <p>
     * Whether the hyperparameter is tunable.
     * </p>
     * 
     * @return Whether the hyperparameter is tunable.
     */
    public Boolean isTunable() {
        return isTunable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(minValue());
        hashCode = 31 * hashCode + Objects.hashCode(maxValue());
        hashCode = 31 * hashCode + Objects.hashCode(isTunable());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultContinuousHyperParameterRange)) {
            return false;
        }
        DefaultContinuousHyperParameterRange other = (DefaultContinuousHyperParameterRange) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(minValue(), other.minValue())
                && Objects.equals(maxValue(), other.maxValue()) && Objects.equals(isTunable(), other.isTunable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DefaultContinuousHyperParameterRange").add("Name", name()).add("MinValue", minValue())
                .add("MaxValue", maxValue()).add("IsTunable", isTunable()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "minValue":
            return Optional.ofNullable(clazz.cast(minValue()));
        case "maxValue":
            return Optional.ofNullable(clazz.cast(maxValue()));
        case "isTunable":
            return Optional.ofNullable(clazz.cast(isTunable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DefaultContinuousHyperParameterRange, T> g) {
        return obj -> g.apply((DefaultContinuousHyperParameterRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultContinuousHyperParameterRange> {
        /**
         * <p>
         * The name of the hyperparameter.
         * </p>
         * 
         * @param name
         *        The name of the hyperparameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The minimum allowable value for the hyperparameter.
         * </p>
         * 
         * @param minValue
         *        The minimum allowable value for the hyperparameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minValue(Double minValue);

        /**
         * <p>
         * The maximum allowable value for the hyperparameter.
         * </p>
         * 
         * @param maxValue
         *        The maximum allowable value for the hyperparameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxValue(Double maxValue);

        /**
         * <p>
         * Whether the hyperparameter is tunable.
         * </p>
         * 
         * @param isTunable
         *        Whether the hyperparameter is tunable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTunable(Boolean isTunable);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Double minValue;

        private Double maxValue;

        private Boolean isTunable;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultContinuousHyperParameterRange model) {
            name(model.name);
            minValue(model.minValue);
            maxValue(model.maxValue);
            isTunable(model.isTunable);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Double getMinValue() {
            return minValue;
        }

        @Override
        public final Builder minValue(Double minValue) {
            this.minValue = minValue;
            return this;
        }

        public final void setMinValue(Double minValue) {
            this.minValue = minValue;
        }

        public final Double getMaxValue() {
            return maxValue;
        }

        @Override
        public final Builder maxValue(Double maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public final void setMaxValue(Double maxValue) {
            this.maxValue = maxValue;
        }

        public final Boolean getIsTunable() {
            return isTunable;
        }

        @Override
        public final Builder isTunable(Boolean isTunable) {
            this.isTunable = isTunable;
            return this;
        }

        public final void setIsTunable(Boolean isTunable) {
            this.isTunable = isTunable;
        }

        @Override
        public DefaultContinuousHyperParameterRange build() {
            return new DefaultContinuousHyperParameterRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
