/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalizeevents.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents user interaction event information sent using the <code>PutEvents</code> API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Event implements SdkPojo, Serializable, ToCopyableBuilder<Event.Builder, Event> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventId").getter(getter(Event::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()).build();

    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventType").getter(getter(Event::eventType)).setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()).build();

    private static final SdkField<Float> EVENT_VALUE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("eventValue").getter(getter(Event::eventValue)).setter(setter(Builder::eventValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventValue").build()).build();

    private static final SdkField<String> ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("itemId")
            .getter(getter(Event::itemId)).setter(setter(Builder::itemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemId").build()).build();

    private static final SdkField<String> PROPERTIES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("properties")
            .getter(getter(Event::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(),
                    JsonValueTrait.create()).build();

    private static final SdkField<Instant> SENT_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("sentAt").getter(getter(Event::sentAt)).setter(setter(Builder::sentAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sentAt").build()).build();

    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recommendationId").getter(getter(Event::recommendationId)).setter(setter(Builder::recommendationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationId").build()).build();

    private static final SdkField<List<String>> IMPRESSION_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("impression")
            .getter(getter(Event::impression))
            .setter(setter(Builder::impression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impression").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD,
            EVENT_TYPE_FIELD, EVENT_VALUE_FIELD, ITEM_ID_FIELD, PROPERTIES_FIELD, SENT_AT_FIELD, RECOMMENDATION_ID_FIELD,
            IMPRESSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String eventId;

    private final String eventType;

    private final Float eventValue;

    private final String itemId;

    private final String properties;

    private final Instant sentAt;

    private final String recommendationId;

    private final List<String> impression;

    private Event(BuilderImpl builder) {
        this.eventId = builder.eventId;
        this.eventType = builder.eventType;
        this.eventValue = builder.eventValue;
        this.itemId = builder.itemId;
        this.properties = builder.properties;
        this.sentAt = builder.sentAt;
        this.recommendationId = builder.recommendationId;
        this.impression = builder.impression;
    }

    /**
     * <p>
     * An ID associated with the event. If an event ID is not provided, Amazon Personalize generates a unique ID for the
     * event. An event ID is not used as an input to the model. Amazon Personalize uses the event ID to distinquish
     * unique events. Any subsequent events after the first with the same event ID are not used in model training.
     * </p>
     * 
     * @return An ID associated with the event. If an event ID is not provided, Amazon Personalize generates a unique ID
     *         for the event. An event ID is not used as an input to the model. Amazon Personalize uses the event ID to
     *         distinquish unique events. Any subsequent events after the first with the same event ID are not used in
     *         model training.
     */
    public final String eventId() {
        return eventId;
    }

    /**
     * <p>
     * The type of event, such as click or download. This property corresponds to the <code>EVENT_TYPE</code> field of
     * your Interactions schema and depends on the types of events you are tracking.
     * </p>
     * 
     * @return The type of event, such as click or download. This property corresponds to the <code>EVENT_TYPE</code>
     *         field of your Interactions schema and depends on the types of events you are tracking.
     */
    public final String eventType() {
        return eventType;
    }

    /**
     * <p>
     * The event value that corresponds to the <code>EVENT_VALUE</code> field of the Interactions schema.
     * </p>
     * 
     * @return The event value that corresponds to the <code>EVENT_VALUE</code> field of the Interactions schema.
     */
    public final Float eventValue() {
        return eventValue;
    }

    /**
     * <p>
     * The item ID key that corresponds to the <code>ITEM_ID</code> field of the Interactions schema.
     * </p>
     * 
     * @return The item ID key that corresponds to the <code>ITEM_ID</code> field of the Interactions schema.
     */
    public final String itemId() {
        return itemId;
    }

    /**
     * <p>
     * A string map of event-specific data that you might choose to record. For example, if a user rates a movie on your
     * site, other than movie ID (<code>itemId</code>) and rating (<code>eventValue</code>) , you might also send the
     * number of movie ratings made by the user.
     * </p>
     * <p>
     * Each item in the map consists of a key-value pair. For example,
     * </p>
     * <p>
     * <code>{"numberOfRatings": "12"}</code>
     * </p>
     * <p>
     * The keys use camel case names that match the fields in the Interactions schema. In the above example, the
     * <code>numberOfRatings</code> would match the 'NUMBER_OF_RATINGS' field defined in the Interactions schema.
     * </p>
     * 
     * @return A string map of event-specific data that you might choose to record. For example, if a user rates a movie
     *         on your site, other than movie ID (<code>itemId</code>) and rating (<code>eventValue</code>) , you might
     *         also send the number of movie ratings made by the user.</p>
     *         <p>
     *         Each item in the map consists of a key-value pair. For example,
     *         </p>
     *         <p>
     *         <code>{"numberOfRatings": "12"}</code>
     *         </p>
     *         <p>
     *         The keys use camel case names that match the fields in the Interactions schema. In the above example, the
     *         <code>numberOfRatings</code> would match the 'NUMBER_OF_RATINGS' field defined in the Interactions
     *         schema.
     */
    public final String properties() {
        return properties;
    }

    /**
     * <p>
     * The timestamp (in Unix time) on the client side when the event occurred.
     * </p>
     * 
     * @return The timestamp (in Unix time) on the client side when the event occurred.
     */
    public final Instant sentAt() {
        return sentAt;
    }

    /**
     * <p>
     * The ID of the recommendation.
     * </p>
     * 
     * @return The ID of the recommendation.
     */
    public final String recommendationId() {
        return recommendationId;
    }

    /**
     * Returns true if the Impression property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasImpression() {
        return impression != null && !(impression instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of item IDs that represents the sequence of items you have shown the user. For example,
     * <code>["itemId1", "itemId2", "itemId3"]</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasImpression()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of item IDs that represents the sequence of items you have shown the user. For example,
     *         <code>["itemId1", "itemId2", "itemId3"]</code>.
     */
    public final List<String> impression() {
        return impression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(eventType());
        hashCode = 31 * hashCode + Objects.hashCode(eventValue());
        hashCode = 31 * hashCode + Objects.hashCode(itemId());
        hashCode = 31 * hashCode + Objects.hashCode(properties());
        hashCode = 31 * hashCode + Objects.hashCode(sentAt());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(hasImpression() ? impression() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event) obj;
        return Objects.equals(eventId(), other.eventId()) && Objects.equals(eventType(), other.eventType())
                && Objects.equals(eventValue(), other.eventValue()) && Objects.equals(itemId(), other.itemId())
                && Objects.equals(properties(), other.properties()) && Objects.equals(sentAt(), other.sentAt())
                && Objects.equals(recommendationId(), other.recommendationId()) && hasImpression() == other.hasImpression()
                && Objects.equals(impression(), other.impression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Event").add("EventId", eventId()).add("EventType", eventType()).add("EventValue", eventValue())
                .add("ItemId", itemId()).add("Properties", properties()).add("SentAt", sentAt())
                .add("RecommendationId", recommendationId()).add("Impression", hasImpression() ? impression() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "eventType":
            return Optional.ofNullable(clazz.cast(eventType()));
        case "eventValue":
            return Optional.ofNullable(clazz.cast(eventValue()));
        case "itemId":
            return Optional.ofNullable(clazz.cast(itemId()));
        case "properties":
            return Optional.ofNullable(clazz.cast(properties()));
        case "sentAt":
            return Optional.ofNullable(clazz.cast(sentAt()));
        case "recommendationId":
            return Optional.ofNullable(clazz.cast(recommendationId()));
        case "impression":
            return Optional.ofNullable(clazz.cast(impression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Event, T> g) {
        return obj -> g.apply((Event) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Event> {
        /**
         * <p>
         * An ID associated with the event. If an event ID is not provided, Amazon Personalize generates a unique ID for
         * the event. An event ID is not used as an input to the model. Amazon Personalize uses the event ID to
         * distinquish unique events. Any subsequent events after the first with the same event ID are not used in model
         * training.
         * </p>
         * 
         * @param eventId
         *        An ID associated with the event. If an event ID is not provided, Amazon Personalize generates a unique
         *        ID for the event. An event ID is not used as an input to the model. Amazon Personalize uses the event
         *        ID to distinquish unique events. Any subsequent events after the first with the same event ID are not
         *        used in model training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * The type of event, such as click or download. This property corresponds to the <code>EVENT_TYPE</code> field
         * of your Interactions schema and depends on the types of events you are tracking.
         * </p>
         * 
         * @param eventType
         *        The type of event, such as click or download. This property corresponds to the <code>EVENT_TYPE</code>
         *        field of your Interactions schema and depends on the types of events you are tracking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * The event value that corresponds to the <code>EVENT_VALUE</code> field of the Interactions schema.
         * </p>
         * 
         * @param eventValue
         *        The event value that corresponds to the <code>EVENT_VALUE</code> field of the Interactions schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventValue(Float eventValue);

        /**
         * <p>
         * The item ID key that corresponds to the <code>ITEM_ID</code> field of the Interactions schema.
         * </p>
         * 
         * @param itemId
         *        The item ID key that corresponds to the <code>ITEM_ID</code> field of the Interactions schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemId(String itemId);

        /**
         * <p>
         * A string map of event-specific data that you might choose to record. For example, if a user rates a movie on
         * your site, other than movie ID (<code>itemId</code>) and rating (<code>eventValue</code>) , you might also
         * send the number of movie ratings made by the user.
         * </p>
         * <p>
         * Each item in the map consists of a key-value pair. For example,
         * </p>
         * <p>
         * <code>{"numberOfRatings": "12"}</code>
         * </p>
         * <p>
         * The keys use camel case names that match the fields in the Interactions schema. In the above example, the
         * <code>numberOfRatings</code> would match the 'NUMBER_OF_RATINGS' field defined in the Interactions schema.
         * </p>
         * 
         * @param properties
         *        A string map of event-specific data that you might choose to record. For example, if a user rates a
         *        movie on your site, other than movie ID (<code>itemId</code>) and rating (<code>eventValue</code>) ,
         *        you might also send the number of movie ratings made by the user.</p>
         *        <p>
         *        Each item in the map consists of a key-value pair. For example,
         *        </p>
         *        <p>
         *        <code>{"numberOfRatings": "12"}</code>
         *        </p>
         *        <p>
         *        The keys use camel case names that match the fields in the Interactions schema. In the above example,
         *        the <code>numberOfRatings</code> would match the 'NUMBER_OF_RATINGS' field defined in the Interactions
         *        schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(String properties);

        /**
         * <p>
         * The timestamp (in Unix time) on the client side when the event occurred.
         * </p>
         * 
         * @param sentAt
         *        The timestamp (in Unix time) on the client side when the event occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sentAt(Instant sentAt);

        /**
         * <p>
         * The ID of the recommendation.
         * </p>
         * 
         * @param recommendationId
         *        The ID of the recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationId(String recommendationId);

        /**
         * <p>
         * A list of item IDs that represents the sequence of items you have shown the user. For example,
         * <code>["itemId1", "itemId2", "itemId3"]</code>.
         * </p>
         * 
         * @param impression
         *        A list of item IDs that represents the sequence of items you have shown the user. For example,
         *        <code>["itemId1", "itemId2", "itemId3"]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impression(Collection<String> impression);

        /**
         * <p>
         * A list of item IDs that represents the sequence of items you have shown the user. For example,
         * <code>["itemId1", "itemId2", "itemId3"]</code>.
         * </p>
         * 
         * @param impression
         *        A list of item IDs that represents the sequence of items you have shown the user. For example,
         *        <code>["itemId1", "itemId2", "itemId3"]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impression(String... impression);
    }

    static final class BuilderImpl implements Builder {
        private String eventId;

        private String eventType;

        private Float eventValue;

        private String itemId;

        private String properties;

        private Instant sentAt;

        private String recommendationId;

        private List<String> impression = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Event model) {
            eventId(model.eventId);
            eventType(model.eventType);
            eventValue(model.eventValue);
            itemId(model.itemId);
            properties(model.properties);
            sentAt(model.sentAt);
            recommendationId(model.recommendationId);
            impression(model.impression);
        }

        public final String getEventId() {
            return eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public final String getEventType() {
            return eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public final Float getEventValue() {
            return eventValue;
        }

        @Override
        public final Builder eventValue(Float eventValue) {
            this.eventValue = eventValue;
            return this;
        }

        public final void setEventValue(Float eventValue) {
            this.eventValue = eventValue;
        }

        public final String getItemId() {
            return itemId;
        }

        @Override
        public final Builder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        public final void setItemId(String itemId) {
            this.itemId = itemId;
        }

        public final String getProperties() {
            return properties;
        }

        @Override
        public final Builder properties(String properties) {
            this.properties = properties;
            return this;
        }

        public final void setProperties(String properties) {
            this.properties = properties;
        }

        public final Instant getSentAt() {
            return sentAt;
        }

        @Override
        public final Builder sentAt(Instant sentAt) {
            this.sentAt = sentAt;
            return this;
        }

        public final void setSentAt(Instant sentAt) {
            this.sentAt = sentAt;
        }

        public final String getRecommendationId() {
            return recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        public final Collection<String> getImpression() {
            if (impression instanceof SdkAutoConstructList) {
                return null;
            }
            return impression;
        }

        @Override
        public final Builder impression(Collection<String> impression) {
            this.impression = ImpressionCopier.copy(impression);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impression(String... impression) {
            impression(Arrays.asList(impression));
            return this;
        }

        public final void setImpression(Collection<String> impression) {
            this.impression = ImpressionCopier.copy(impression);
        }

        @Override
        public Event build() {
            return new Event(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
