/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalizeevents.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutEventsRequest extends PersonalizeEventsRequest implements
        ToCopyableBuilder<PutEventsRequest.Builder, PutEventsRequest> {
    private static final SdkField<String> TRACKING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trackingId").getter(getter(PutEventsRequest::trackingId)).setter(setter(Builder::trackingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackingId").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(PutEventsRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(PutEventsRequest::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<List<Event>> EVENT_LIST_FIELD = SdkField
            .<List<Event>> builder(MarshallingType.LIST)
            .memberName("eventList")
            .getter(getter(PutEventsRequest::eventList))
            .setter(setter(Builder::eventList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Event> builder(MarshallingType.SDK_POJO)
                                            .constructor(Event::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKING_ID_FIELD,
            USER_ID_FIELD, SESSION_ID_FIELD, EVENT_LIST_FIELD));

    private final String trackingId;

    private final String userId;

    private final String sessionId;

    private final List<Event> eventList;

    private PutEventsRequest(BuilderImpl builder) {
        super(builder);
        this.trackingId = builder.trackingId;
        this.userId = builder.userId;
        this.sessionId = builder.sessionId;
        this.eventList = builder.eventList;
    }

    /**
     * <p>
     * The tracking ID for the event. The ID is generated by a call to the <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html">CreateEventTracker</a> API.
     * </p>
     * 
     * @return The tracking ID for the event. The ID is generated by a call to the <a
     *         href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html"
     *         >CreateEventTracker</a> API.
     */
    public final String trackingId() {
        return trackingId;
    }

    /**
     * <p>
     * The user associated with the event.
     * </p>
     * 
     * @return The user associated with the event.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * The session ID associated with the user's visit. Your application generates the sessionId when a user first
     * visits your website or uses your application. Amazon Personalize uses the sessionId to associate events with the
     * user before they log in. For more information, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/recording-events.html">Recording Events</a>.
     * </p>
     * 
     * @return The session ID associated with the user's visit. Your application generates the sessionId when a user
     *         first visits your website or uses your application. Amazon Personalize uses the sessionId to associate
     *         events with the user before they log in. For more information, see <a
     *         href="https://docs.aws.amazon.com/personalize/latest/dg/recording-events.html">Recording Events</a>.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEventList() {
        return eventList != null && !(eventList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of event data from the session.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventList} method.
     * </p>
     * 
     * @return A list of event data from the session.
     */
    public final List<Event> eventList() {
        return eventList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trackingId());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventList() ? eventList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEventsRequest)) {
            return false;
        }
        PutEventsRequest other = (PutEventsRequest) obj;
        return Objects.equals(trackingId(), other.trackingId()) && Objects.equals(userId(), other.userId())
                && Objects.equals(sessionId(), other.sessionId()) && hasEventList() == other.hasEventList()
                && Objects.equals(eventList(), other.eventList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutEventsRequest").add("TrackingId", trackingId()).add("UserId", userId())
                .add("SessionId", sessionId()).add("EventList", hasEventList() ? eventList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "trackingId":
            return Optional.ofNullable(clazz.cast(trackingId()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "eventList":
            return Optional.ofNullable(clazz.cast(eventList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutEventsRequest, T> g) {
        return obj -> g.apply((PutEventsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeEventsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutEventsRequest> {
        /**
         * <p>
         * The tracking ID for the event. The ID is generated by a call to the <a
         * href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html">CreateEventTracker</a>
         * API.
         * </p>
         * 
         * @param trackingId
         *        The tracking ID for the event. The ID is generated by a call to the <a
         *        href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html"
         *        >CreateEventTracker</a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackingId(String trackingId);

        /**
         * <p>
         * The user associated with the event.
         * </p>
         * 
         * @param userId
         *        The user associated with the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The session ID associated with the user's visit. Your application generates the sessionId when a user first
         * visits your website or uses your application. Amazon Personalize uses the sessionId to associate events with
         * the user before they log in. For more information, see <a
         * href="https://docs.aws.amazon.com/personalize/latest/dg/recording-events.html">Recording Events</a>.
         * </p>
         * 
         * @param sessionId
         *        The session ID associated with the user's visit. Your application generates the sessionId when a user
         *        first visits your website or uses your application. Amazon Personalize uses the sessionId to associate
         *        events with the user before they log in. For more information, see <a
         *        href="https://docs.aws.amazon.com/personalize/latest/dg/recording-events.html">Recording Events</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * A list of event data from the session.
         * </p>
         * 
         * @param eventList
         *        A list of event data from the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventList(Collection<Event> eventList);

        /**
         * <p>
         * A list of event data from the session.
         * </p>
         * 
         * @param eventList
         *        A list of event data from the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventList(Event... eventList);

        /**
         * <p>
         * A list of event data from the session.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Event>.Builder} avoiding the need to create
         * one manually via {@link List<Event>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Event>.Builder#build()} is called immediately and its result
         * is passed to {@link #eventList(List<Event>)}.
         * 
         * @param eventList
         *        a consumer that will call methods on {@link List<Event>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventList(List<Event>)
         */
        Builder eventList(Consumer<Event.Builder>... eventList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PersonalizeEventsRequest.BuilderImpl implements Builder {
        private String trackingId;

        private String userId;

        private String sessionId;

        private List<Event> eventList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutEventsRequest model) {
            super(model);
            trackingId(model.trackingId);
            userId(model.userId);
            sessionId(model.sessionId);
            eventList(model.eventList);
        }

        public final String getTrackingId() {
            return trackingId;
        }

        public final void setTrackingId(String trackingId) {
            this.trackingId = trackingId;
        }

        @Override
        @Transient
        public final Builder trackingId(String trackingId) {
            this.trackingId = trackingId;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        @Transient
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        @Transient
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final List<Event.Builder> getEventList() {
            List<Event.Builder> result = EventListCopier.copyToBuilder(this.eventList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventList(Collection<Event.BuilderImpl> eventList) {
            this.eventList = EventListCopier.copyFromBuilder(eventList);
        }

        @Override
        @Transient
        public final Builder eventList(Collection<Event> eventList) {
            this.eventList = EventListCopier.copy(eventList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventList(Event... eventList) {
            eventList(Arrays.asList(eventList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventList(Consumer<Event.Builder>... eventList) {
            eventList(Stream.of(eventList).map(c -> Event.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutEventsRequest build() {
            return new PutEventsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
