/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalizeevents;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.personalizeevents.model.PutActionInteractionsRequest;
import software.amazon.awssdk.services.personalizeevents.model.PutActionInteractionsResponse;
import software.amazon.awssdk.services.personalizeevents.model.PutActionsRequest;
import software.amazon.awssdk.services.personalizeevents.model.PutActionsResponse;
import software.amazon.awssdk.services.personalizeevents.model.PutEventsRequest;
import software.amazon.awssdk.services.personalizeevents.model.PutEventsResponse;
import software.amazon.awssdk.services.personalizeevents.model.PutItemsRequest;
import software.amazon.awssdk.services.personalizeevents.model.PutItemsResponse;
import software.amazon.awssdk.services.personalizeevents.model.PutUsersRequest;
import software.amazon.awssdk.services.personalizeevents.model.PutUsersResponse;

/**
 * Service client for accessing Amazon Personalize Events asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@link SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Amazon Personalize can consume real-time user event data, such as <i>stream</i> or <i>click</i> data, and use it for
 * model training either alone or combined with historical data. For more information see <a
 * href="https://docs.aws.amazon.com/personalize/latest/dg/recording-item-interaction-events.html">Recording item
 * interaction events</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface PersonalizeEventsAsyncClient extends AwsClient {
    String SERVICE_NAME = "personalize";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "personalize-events";

    /**
     * <p>
     * Records action interaction event data. An <i>action interaction</i> event is an interaction between a user and an
     * <i>action</i>. For example, a user taking an action, such a enrolling in a membership program or downloading your
     * app.
     * </p>
     * <p>
     * For more information about recording action interactions, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/recording-action-interaction-events.html">Recording
     * action interaction events</a>. For more information about actions in an Actions dataset, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/actions-datasets.html">Actions dataset</a>.
     * </p>
     *
     * @param putActionInteractionsRequest
     * @return A Java Future containing the result of the PutActionInteractions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeEventsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PersonalizeEventsAsyncClient.PutActionInteractions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-events-2018-03-22/PutActionInteractions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutActionInteractionsResponse> putActionInteractions(
            PutActionInteractionsRequest putActionInteractionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Records action interaction event data. An <i>action interaction</i> event is an interaction between a user and an
     * <i>action</i>. For example, a user taking an action, such a enrolling in a membership program or downloading your
     * app.
     * </p>
     * <p>
     * For more information about recording action interactions, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/recording-action-interaction-events.html">Recording
     * action interaction events</a>. For more information about actions in an Actions dataset, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/actions-datasets.html">Actions dataset</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutActionInteractionsRequest.Builder} avoiding the
     * need to create one manually via {@link PutActionInteractionsRequest#builder()}
     * </p>
     *
     * @param putActionInteractionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.personalizeevents.model.PutActionInteractionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutActionInteractions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeEventsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PersonalizeEventsAsyncClient.PutActionInteractions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-events-2018-03-22/PutActionInteractions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutActionInteractionsResponse> putActionInteractions(
            Consumer<PutActionInteractionsRequest.Builder> putActionInteractionsRequest) {
        return putActionInteractions(PutActionInteractionsRequest.builder().applyMutation(putActionInteractionsRequest).build());
    }

    /**
     * <p>
     * Adds one or more actions to an Actions dataset. For more information see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/importing-actions.html">Importing actions
     * individually</a>.
     * </p>
     *
     * @param putActionsRequest
     * @return A Java Future containing the result of the PutActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeEventsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PersonalizeEventsAsyncClient.PutActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-events-2018-03-22/PutActions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutActionsResponse> putActions(PutActionsRequest putActionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more actions to an Actions dataset. For more information see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/importing-actions.html">Importing actions
     * individually</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutActionsRequest.Builder} avoiding the need to
     * create one manually via {@link PutActionsRequest#builder()}
     * </p>
     *
     * @param putActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.personalizeevents.model.PutActionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeEventsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PersonalizeEventsAsyncClient.PutActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-events-2018-03-22/PutActions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutActionsResponse> putActions(Consumer<PutActionsRequest.Builder> putActionsRequest) {
        return putActions(PutActionsRequest.builder().applyMutation(putActionsRequest).build());
    }

    /**
     * <p>
     * Records item interaction event data. For more information see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/recording-item-interaction-events.html">Recording item
     * interaction events</a>.
     * </p>
     *
     * @param putEventsRequest
     * @return A Java Future containing the result of the PutEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeEventsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PersonalizeEventsAsyncClient.PutEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-events-2018-03-22/PutEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutEventsResponse> putEvents(PutEventsRequest putEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Records item interaction event data. For more information see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/recording-item-interaction-events.html">Recording item
     * interaction events</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutEventsRequest.Builder} avoiding the need to
     * create one manually via {@link PutEventsRequest#builder()}
     * </p>
     *
     * @param putEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.personalizeevents.model.PutEventsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeEventsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PersonalizeEventsAsyncClient.PutEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-events-2018-03-22/PutEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutEventsResponse> putEvents(Consumer<PutEventsRequest.Builder> putEventsRequest) {
        return putEvents(PutEventsRequest.builder().applyMutation(putEventsRequest).build());
    }

    /**
     * <p>
     * Adds one or more items to an Items dataset. For more information see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/importing-items.html">Importing items individually</a>.
     * </p>
     *
     * @param putItemsRequest
     * @return A Java Future containing the result of the PutItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeEventsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PersonalizeEventsAsyncClient.PutItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-events-2018-03-22/PutItems" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutItemsResponse> putItems(PutItemsRequest putItemsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more items to an Items dataset. For more information see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/importing-items.html">Importing items individually</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutItemsRequest.Builder} avoiding the need to
     * create one manually via {@link PutItemsRequest#builder()}
     * </p>
     *
     * @param putItemsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.personalizeevents.model.PutItemsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeEventsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PersonalizeEventsAsyncClient.PutItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-events-2018-03-22/PutItems" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutItemsResponse> putItems(Consumer<PutItemsRequest.Builder> putItemsRequest) {
        return putItems(PutItemsRequest.builder().applyMutation(putItemsRequest).build());
    }

    /**
     * <p>
     * Adds one or more users to a Users dataset. For more information see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/importing-users.html">Importing users individually</a>.
     * </p>
     *
     * @param putUsersRequest
     * @return A Java Future containing the result of the PutUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeEventsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PersonalizeEventsAsyncClient.PutUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-events-2018-03-22/PutUsers" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutUsersResponse> putUsers(PutUsersRequest putUsersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more users to a Users dataset. For more information see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/importing-users.html">Importing users individually</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutUsersRequest.Builder} avoiding the need to
     * create one manually via {@link PutUsersRequest#builder()}
     * </p>
     *
     * @param putUsersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.personalizeevents.model.PutUsersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException Could not find the specified resource.</li>
     *         <li>ResourceInUseException The specified resource is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeEventsException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PersonalizeEventsAsyncClient.PutUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-events-2018-03-22/PutUsers" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutUsersResponse> putUsers(Consumer<PutUsersRequest.Builder> putUsersRequest) {
        return putUsers(PutUsersRequest.builder().applyMutation(putUsersRequest).build());
    }

    @Override
    default PersonalizeEventsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link PersonalizeEventsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static PersonalizeEventsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link PersonalizeEventsAsyncClient}.
     */
    static PersonalizeEventsAsyncClientBuilder builder() {
        return new DefaultPersonalizeEventsAsyncClientBuilder();
    }
}
