/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalizeevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutUsersRequest extends PersonalizeEventsRequest implements
        ToCopyableBuilder<PutUsersRequest.Builder, PutUsersRequest> {
    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetArn").getter(getter(PutUsersRequest::datasetArn)).setter(setter(Builder::datasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetArn").build()).build();

    private static final SdkField<List<User>> USERS_FIELD = SdkField
            .<List<User>> builder(MarshallingType.LIST)
            .memberName("users")
            .getter(getter(PutUsersRequest::users))
            .setter(setter(Builder::users))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("users").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<User> builder(MarshallingType.SDK_POJO)
                                            .constructor(User::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DATASET_ARN_FIELD, USERS_FIELD));

    private final String datasetArn;

    private final List<User> users;

    private PutUsersRequest(BuilderImpl builder) {
        super(builder);
        this.datasetArn = builder.datasetArn;
        this.users = builder.users;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Users dataset you are adding the user or users to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Users dataset you are adding the user or users to.
     */
    public final String datasetArn() {
        return datasetArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Users property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasUsers() {
        return users != null && !(users instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of user data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsers} method.
     * </p>
     * 
     * @return A list of user data.
     */
    public final List<User> users() {
        return users;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasUsers() ? users() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutUsersRequest)) {
            return false;
        }
        PutUsersRequest other = (PutUsersRequest) obj;
        return Objects.equals(datasetArn(), other.datasetArn()) && hasUsers() == other.hasUsers()
                && Objects.equals(users(), other.users());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutUsersRequest").add("DatasetArn", datasetArn()).add("Users", hasUsers() ? users() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datasetArn":
            return Optional.ofNullable(clazz.cast(datasetArn()));
        case "users":
            return Optional.ofNullable(clazz.cast(users()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutUsersRequest, T> g) {
        return obj -> g.apply((PutUsersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeEventsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutUsersRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Users dataset you are adding the user or users to.
         * </p>
         * 
         * @param datasetArn
         *        The Amazon Resource Name (ARN) of the Users dataset you are adding the user or users to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArn(String datasetArn);

        /**
         * <p>
         * A list of user data.
         * </p>
         * 
         * @param users
         *        A list of user data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder users(Collection<User> users);

        /**
         * <p>
         * A list of user data.
         * </p>
         * 
         * @param users
         *        A list of user data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder users(User... users);

        /**
         * <p>
         * A list of user data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.personalizeevents.model.User.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.personalizeevents.model.User#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.personalizeevents.model.User.Builder#build()} is called immediately
         * and its result is passed to {@link #users(List<User>)}.
         * 
         * @param users
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.personalizeevents.model.User.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #users(java.util.Collection<User>)
         */
        Builder users(Consumer<User.Builder>... users);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PersonalizeEventsRequest.BuilderImpl implements Builder {
        private String datasetArn;

        private List<User> users = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutUsersRequest model) {
            super(model);
            datasetArn(model.datasetArn);
            users(model.users);
        }

        public final String getDatasetArn() {
            return datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final List<User.Builder> getUsers() {
            List<User.Builder> result = UserListCopier.copyToBuilder(this.users);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsers(Collection<User.BuilderImpl> users) {
            this.users = UserListCopier.copyFromBuilder(users);
        }

        @Override
        public final Builder users(Collection<User> users) {
            this.users = UserListCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(User... users) {
            users(Arrays.asList(users));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(Consumer<User.Builder>... users) {
            users(Stream.of(users).map(c -> User.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutUsersRequest build() {
            return new PutUsersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
