/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalizeevents.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an action interaction event sent using the <code>PutActionInteractions</code> API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionInteraction implements SdkPojo, Serializable,
        ToCopyableBuilder<ActionInteraction.Builder, ActionInteraction> {
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionId").getter(getter(ActionInteraction::actionId)).setter(setter(Builder::actionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionId").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(ActionInteraction::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(ActionInteraction::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("timestamp").getter(getter(ActionInteraction::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()).build();

    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventType").getter(getter(ActionInteraction::eventType)).setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()).build();

    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventId").getter(getter(ActionInteraction::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()).build();

    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recommendationId").getter(getter(ActionInteraction::recommendationId))
            .setter(setter(Builder::recommendationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationId").build()).build();

    private static final SdkField<List<String>> IMPRESSION_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("impression")
            .getter(getter(ActionInteraction::impression))
            .setter(setter(Builder::impression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impression").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROPERTIES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("properties")
            .getter(getter(ActionInteraction::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(),
                    JsonValueTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ID_FIELD,
            USER_ID_FIELD, SESSION_ID_FIELD, TIMESTAMP_FIELD, EVENT_TYPE_FIELD, EVENT_ID_FIELD, RECOMMENDATION_ID_FIELD,
            IMPRESSION_FIELD, PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String actionId;

    private final String userId;

    private final String sessionId;

    private final Instant timestamp;

    private final String eventType;

    private final String eventId;

    private final String recommendationId;

    private final List<String> impression;

    private final String properties;

    private ActionInteraction(BuilderImpl builder) {
        this.actionId = builder.actionId;
        this.userId = builder.userId;
        this.sessionId = builder.sessionId;
        this.timestamp = builder.timestamp;
        this.eventType = builder.eventType;
        this.eventId = builder.eventId;
        this.recommendationId = builder.recommendationId;
        this.impression = builder.impression;
        this.properties = builder.properties;
    }

    /**
     * <p>
     * The ID of the action the user interacted with. This corresponds to the <code>ACTION_ID</code> field of the Action
     * interaction schema.
     * </p>
     * 
     * @return The ID of the action the user interacted with. This corresponds to the <code>ACTION_ID</code> field of
     *         the Action interaction schema.
     */
    public final String actionId() {
        return actionId;
    }

    /**
     * <p>
     * The ID of the user who interacted with the action. This corresponds to the <code>USER_ID</code> field of the
     * Action interaction schema.
     * </p>
     * 
     * @return The ID of the user who interacted with the action. This corresponds to the <code>USER_ID</code> field of
     *         the Action interaction schema.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * The ID associated with the user's visit. Your application generates a unique <code>sessionId</code> when a user
     * first visits your website or uses your application.
     * </p>
     * 
     * @return The ID associated with the user's visit. Your application generates a unique <code>sessionId</code> when
     *         a user first visits your website or uses your application.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The timestamp for when the action interaction event occurred. Timestamps must be in Unix epoch time format, in
     * seconds.
     * </p>
     * 
     * @return The timestamp for when the action interaction event occurred. Timestamps must be in Unix epoch time
     *         format, in seconds.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The type of action interaction event. You can specify <code>Viewed</code>, <code>Taken</code>, and
     * <code>Not Taken</code> event types. For more information about action interaction event type data, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/action-interaction-event-type-data.html">Event type
     * data</a>.
     * </p>
     * 
     * @return The type of action interaction event. You can specify <code>Viewed</code>, <code>Taken</code>, and
     *         <code>Not Taken</code> event types. For more information about action interaction event type data, see <a
     *         href="https://docs.aws.amazon.com/personalize/latest/dg/action-interaction-event-type-data.html">Event
     *         type data</a>.
     */
    public final String eventType() {
        return eventType;
    }

    /**
     * <p>
     * An ID associated with the event. If an event ID is not provided, Amazon Personalize generates a unique ID for the
     * event. An event ID is not used as an input to the model. Amazon Personalize uses the event ID to distinguish
     * unique events. Any subsequent events after the first with the same event ID are not used in model training.
     * </p>
     * 
     * @return An ID associated with the event. If an event ID is not provided, Amazon Personalize generates a unique ID
     *         for the event. An event ID is not used as an input to the model. Amazon Personalize uses the event ID to
     *         distinguish unique events. Any subsequent events after the first with the same event ID are not used in
     *         model training.
     */
    public final String eventId() {
        return eventId;
    }

    /**
     * <p>
     * The ID of the list of recommendations that contains the action the user interacted with.
     * </p>
     * 
     * @return The ID of the list of recommendations that contains the action the user interacted with.
     */
    public final String recommendationId() {
        return recommendationId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Impression property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasImpression() {
        return impression != null && !(impression instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of action IDs that represents the sequence of actions you have shown the user. For example,
     * <code>["actionId1", "actionId2", "actionId3"]</code>. Amazon Personalize doesn't use impressions data from action
     * interaction events. Instead, record multiple events for each action and use the <code>Viewed</code> event type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImpression} method.
     * </p>
     * 
     * @return A list of action IDs that represents the sequence of actions you have shown the user. For example,
     *         <code>["actionId1", "actionId2", "actionId3"]</code>. Amazon Personalize doesn't use impressions data
     *         from action interaction events. Instead, record multiple events for each action and use the
     *         <code>Viewed</code> event type.
     */
    public final List<String> impression() {
        return impression;
    }

    /**
     * <p>
     * A string map of event-specific data that you might choose to record. For example, if a user takes an action,
     * other than the action ID, you might also send the number of actions taken by the user.
     * </p>
     * <p>
     * Each item in the map consists of a key-value pair. For example,
     * </p>
     * <p>
     * <code>{"numberOfActions": "12"}</code>
     * </p>
     * <p>
     * The keys use camel case names that match the fields in the Action interactions schema. In the above example, the
     * <code>numberOfActions</code> would match the 'NUMBER_OF_ACTIONS' field defined in the Action interactions schema.
     * </p>
     * <p>
     * The following can't be included as a keyword for properties (case insensitive).
     * </p>
     * <ul>
     * <li>
     * <p>
     * userId
     * </p>
     * </li>
     * <li>
     * <p>
     * sessionId
     * </p>
     * </li>
     * <li>
     * <p>
     * eventType
     * </p>
     * </li>
     * <li>
     * <p>
     * timestamp
     * </p>
     * </li>
     * <li>
     * <p>
     * recommendationId
     * </p>
     * </li>
     * <li>
     * <p>
     * impression
     * </p>
     * </li>
     * </ul>
     * 
     * @return A string map of event-specific data that you might choose to record. For example, if a user takes an
     *         action, other than the action ID, you might also send the number of actions taken by the user.</p>
     *         <p>
     *         Each item in the map consists of a key-value pair. For example,
     *         </p>
     *         <p>
     *         <code>{"numberOfActions": "12"}</code>
     *         </p>
     *         <p>
     *         The keys use camel case names that match the fields in the Action interactions schema. In the above
     *         example, the <code>numberOfActions</code> would match the 'NUMBER_OF_ACTIONS' field defined in the Action
     *         interactions schema.
     *         </p>
     *         <p>
     *         The following can't be included as a keyword for properties (case insensitive).
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         userId
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         sessionId
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         eventType
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         timestamp
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         recommendationId
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         impression
     *         </p>
     *         </li>
     */
    public final String properties() {
        return properties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionId());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(eventType());
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(hasImpression() ? impression() : null);
        hashCode = 31 * hashCode + Objects.hashCode(properties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionInteraction)) {
            return false;
        }
        ActionInteraction other = (ActionInteraction) obj;
        return Objects.equals(actionId(), other.actionId()) && Objects.equals(userId(), other.userId())
                && Objects.equals(sessionId(), other.sessionId()) && Objects.equals(timestamp(), other.timestamp())
                && Objects.equals(eventType(), other.eventType()) && Objects.equals(eventId(), other.eventId())
                && Objects.equals(recommendationId(), other.recommendationId()) && hasImpression() == other.hasImpression()
                && Objects.equals(impression(), other.impression()) && Objects.equals(properties(), other.properties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionInteraction")
                .add("ActionId", actionId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("UserId", userId() == null ? null : "*** Sensitive Data Redacted ***").add("SessionId", sessionId())
                .add("Timestamp", timestamp()).add("EventType", eventType()).add("EventId", eventId())
                .add("RecommendationId", recommendationId())
                .add("Impression", impression() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Properties", properties() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionId":
            return Optional.ofNullable(clazz.cast(actionId()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "eventType":
            return Optional.ofNullable(clazz.cast(eventType()));
        case "eventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "recommendationId":
            return Optional.ofNullable(clazz.cast(recommendationId()));
        case "impression":
            return Optional.ofNullable(clazz.cast(impression()));
        case "properties":
            return Optional.ofNullable(clazz.cast(properties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("actionId", ACTION_ID_FIELD);
        map.put("userId", USER_ID_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        map.put("eventType", EVENT_TYPE_FIELD);
        map.put("eventId", EVENT_ID_FIELD);
        map.put("recommendationId", RECOMMENDATION_ID_FIELD);
        map.put("impression", IMPRESSION_FIELD);
        map.put("properties", PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActionInteraction, T> g) {
        return obj -> g.apply((ActionInteraction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionInteraction> {
        /**
         * <p>
         * The ID of the action the user interacted with. This corresponds to the <code>ACTION_ID</code> field of the
         * Action interaction schema.
         * </p>
         * 
         * @param actionId
         *        The ID of the action the user interacted with. This corresponds to the <code>ACTION_ID</code> field of
         *        the Action interaction schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionId(String actionId);

        /**
         * <p>
         * The ID of the user who interacted with the action. This corresponds to the <code>USER_ID</code> field of the
         * Action interaction schema.
         * </p>
         * 
         * @param userId
         *        The ID of the user who interacted with the action. This corresponds to the <code>USER_ID</code> field
         *        of the Action interaction schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The ID associated with the user's visit. Your application generates a unique <code>sessionId</code> when a
         * user first visits your website or uses your application.
         * </p>
         * 
         * @param sessionId
         *        The ID associated with the user's visit. Your application generates a unique <code>sessionId</code>
         *        when a user first visits your website or uses your application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The timestamp for when the action interaction event occurred. Timestamps must be in Unix epoch time format,
         * in seconds.
         * </p>
         * 
         * @param timestamp
         *        The timestamp for when the action interaction event occurred. Timestamps must be in Unix epoch time
         *        format, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * The type of action interaction event. You can specify <code>Viewed</code>, <code>Taken</code>, and
         * <code>Not Taken</code> event types. For more information about action interaction event type data, see <a
         * href="https://docs.aws.amazon.com/personalize/latest/dg/action-interaction-event-type-data.html">Event type
         * data</a>.
         * </p>
         * 
         * @param eventType
         *        The type of action interaction event. You can specify <code>Viewed</code>, <code>Taken</code>, and
         *        <code>Not Taken</code> event types. For more information about action interaction event type data, see
         *        <a href="https://docs.aws.amazon.com/personalize/latest/dg/action-interaction-event-type-data.html">
         *        Event type data</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * An ID associated with the event. If an event ID is not provided, Amazon Personalize generates a unique ID for
         * the event. An event ID is not used as an input to the model. Amazon Personalize uses the event ID to
         * distinguish unique events. Any subsequent events after the first with the same event ID are not used in model
         * training.
         * </p>
         * 
         * @param eventId
         *        An ID associated with the event. If an event ID is not provided, Amazon Personalize generates a unique
         *        ID for the event. An event ID is not used as an input to the model. Amazon Personalize uses the event
         *        ID to distinguish unique events. Any subsequent events after the first with the same event ID are not
         *        used in model training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * The ID of the list of recommendations that contains the action the user interacted with.
         * </p>
         * 
         * @param recommendationId
         *        The ID of the list of recommendations that contains the action the user interacted with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationId(String recommendationId);

        /**
         * <p>
         * A list of action IDs that represents the sequence of actions you have shown the user. For example,
         * <code>["actionId1", "actionId2", "actionId3"]</code>. Amazon Personalize doesn't use impressions data from
         * action interaction events. Instead, record multiple events for each action and use the <code>Viewed</code>
         * event type.
         * </p>
         * 
         * @param impression
         *        A list of action IDs that represents the sequence of actions you have shown the user. For example,
         *        <code>["actionId1", "actionId2", "actionId3"]</code>. Amazon Personalize doesn't use impressions data
         *        from action interaction events. Instead, record multiple events for each action and use the
         *        <code>Viewed</code> event type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impression(Collection<String> impression);

        /**
         * <p>
         * A list of action IDs that represents the sequence of actions you have shown the user. For example,
         * <code>["actionId1", "actionId2", "actionId3"]</code>. Amazon Personalize doesn't use impressions data from
         * action interaction events. Instead, record multiple events for each action and use the <code>Viewed</code>
         * event type.
         * </p>
         * 
         * @param impression
         *        A list of action IDs that represents the sequence of actions you have shown the user. For example,
         *        <code>["actionId1", "actionId2", "actionId3"]</code>. Amazon Personalize doesn't use impressions data
         *        from action interaction events. Instead, record multiple events for each action and use the
         *        <code>Viewed</code> event type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impression(String... impression);

        /**
         * <p>
         * A string map of event-specific data that you might choose to record. For example, if a user takes an action,
         * other than the action ID, you might also send the number of actions taken by the user.
         * </p>
         * <p>
         * Each item in the map consists of a key-value pair. For example,
         * </p>
         * <p>
         * <code>{"numberOfActions": "12"}</code>
         * </p>
         * <p>
         * The keys use camel case names that match the fields in the Action interactions schema. In the above example,
         * the <code>numberOfActions</code> would match the 'NUMBER_OF_ACTIONS' field defined in the Action interactions
         * schema.
         * </p>
         * <p>
         * The following can't be included as a keyword for properties (case insensitive).
         * </p>
         * <ul>
         * <li>
         * <p>
         * userId
         * </p>
         * </li>
         * <li>
         * <p>
         * sessionId
         * </p>
         * </li>
         * <li>
         * <p>
         * eventType
         * </p>
         * </li>
         * <li>
         * <p>
         * timestamp
         * </p>
         * </li>
         * <li>
         * <p>
         * recommendationId
         * </p>
         * </li>
         * <li>
         * <p>
         * impression
         * </p>
         * </li>
         * </ul>
         * 
         * @param properties
         *        A string map of event-specific data that you might choose to record. For example, if a user takes an
         *        action, other than the action ID, you might also send the number of actions taken by the user.</p>
         *        <p>
         *        Each item in the map consists of a key-value pair. For example,
         *        </p>
         *        <p>
         *        <code>{"numberOfActions": "12"}</code>
         *        </p>
         *        <p>
         *        The keys use camel case names that match the fields in the Action interactions schema. In the above
         *        example, the <code>numberOfActions</code> would match the 'NUMBER_OF_ACTIONS' field defined in the
         *        Action interactions schema.
         *        </p>
         *        <p>
         *        The following can't be included as a keyword for properties (case insensitive).
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        userId
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        sessionId
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        eventType
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        timestamp
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        recommendationId
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        impression
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(String properties);
    }

    static final class BuilderImpl implements Builder {
        private String actionId;

        private String userId;

        private String sessionId;

        private Instant timestamp;

        private String eventType;

        private String eventId;

        private String recommendationId;

        private List<String> impression = DefaultSdkAutoConstructList.getInstance();

        private String properties;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionInteraction model) {
            actionId(model.actionId);
            userId(model.userId);
            sessionId(model.sessionId);
            timestamp(model.timestamp);
            eventType(model.eventType);
            eventId(model.eventId);
            recommendationId(model.recommendationId);
            impression(model.impression);
            properties(model.properties);
        }

        public final String getActionId() {
            return actionId;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getEventType() {
            return eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final String getEventId() {
            return eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getRecommendationId() {
            return recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final Collection<String> getImpression() {
            if (impression instanceof SdkAutoConstructList) {
                return null;
            }
            return impression;
        }

        public final void setImpression(Collection<String> impression) {
            this.impression = ActionImpressionCopier.copy(impression);
        }

        @Override
        public final Builder impression(Collection<String> impression) {
            this.impression = ActionImpressionCopier.copy(impression);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impression(String... impression) {
            impression(Arrays.asList(impression));
            return this;
        }

        public final String getProperties() {
            return properties;
        }

        public final void setProperties(String properties) {
            this.properties = properties;
        }

        @Override
        public final Builder properties(String properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public ActionInteraction build() {
            return new ActionInteraction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
