/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalizeevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents user metadata added to a Users dataset using the <code>PutUsers</code> API. For more information see <a
 * href="https://docs.aws.amazon.com/personalize/latest/dg/importing-users.html">Importing users individually</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class User implements SdkPojo, Serializable, ToCopyableBuilder<User.Builder, User> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(User::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()).build();

    private static final SdkField<String> PROPERTIES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("properties")
            .getter(getter(User::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(),
                    JsonValueTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD,
            PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String userId;

    private final String properties;

    private User(BuilderImpl builder) {
        this.userId = builder.userId;
        this.properties = builder.properties;
    }

    /**
     * <p>
     * The ID associated with the user.
     * </p>
     * 
     * @return The ID associated with the user.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * A string map of user-specific metadata. Each element in the map consists of a key-value pair. For example,
     * <code>{"numberOfVideosWatched": "45"}</code>.
     * </p>
     * <p>
     * The keys use camel case names that match the fields in the schema for the Users dataset. In the previous example,
     * the <code>numberOfVideosWatched</code> matches the 'NUMBER_OF_VIDEOS_WATCHED' field defined in the Users schema.
     * For categorical string data, to include multiple categories for a single user, separate each category with a pipe
     * separator (<code>|</code>). For example, <code>\"Member|Frequent shopper\"</code>.
     * </p>
     * 
     * @return A string map of user-specific metadata. Each element in the map consists of a key-value pair. For
     *         example, <code>{"numberOfVideosWatched": "45"}</code>.</p>
     *         <p>
     *         The keys use camel case names that match the fields in the schema for the Users dataset. In the previous
     *         example, the <code>numberOfVideosWatched</code> matches the 'NUMBER_OF_VIDEOS_WATCHED' field defined in
     *         the Users schema. For categorical string data, to include multiple categories for a single user, separate
     *         each category with a pipe separator (<code>|</code>). For example,
     *         <code>\"Member|Frequent shopper\"</code>.
     */
    public final String properties() {
        return properties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(properties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User) obj;
        return Objects.equals(userId(), other.userId()) && Objects.equals(properties(), other.properties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("User").add("UserId", userId())
                .add("Properties", properties() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "properties":
            return Optional.ofNullable(clazz.cast(properties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("userId", USER_ID_FIELD);
        map.put("properties", PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<User, T> g) {
        return obj -> g.apply((User) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, User> {
        /**
         * <p>
         * The ID associated with the user.
         * </p>
         * 
         * @param userId
         *        The ID associated with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * A string map of user-specific metadata. Each element in the map consists of a key-value pair. For example,
         * <code>{"numberOfVideosWatched": "45"}</code>.
         * </p>
         * <p>
         * The keys use camel case names that match the fields in the schema for the Users dataset. In the previous
         * example, the <code>numberOfVideosWatched</code> matches the 'NUMBER_OF_VIDEOS_WATCHED' field defined in the
         * Users schema. For categorical string data, to include multiple categories for a single user, separate each
         * category with a pipe separator (<code>|</code>). For example, <code>\"Member|Frequent shopper\"</code>.
         * </p>
         * 
         * @param properties
         *        A string map of user-specific metadata. Each element in the map consists of a key-value pair. For
         *        example, <code>{"numberOfVideosWatched": "45"}</code>.</p>
         *        <p>
         *        The keys use camel case names that match the fields in the schema for the Users dataset. In the
         *        previous example, the <code>numberOfVideosWatched</code> matches the 'NUMBER_OF_VIDEOS_WATCHED' field
         *        defined in the Users schema. For categorical string data, to include multiple categories for a single
         *        user, separate each category with a pipe separator (<code>|</code>). For example,
         *        <code>\"Member|Frequent shopper\"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(String properties);
    }

    static final class BuilderImpl implements Builder {
        private String userId;

        private String properties;

        private BuilderImpl() {
        }

        private BuilderImpl(User model) {
            userId(model.userId);
            properties(model.properties);
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getProperties() {
            return properties;
        }

        public final void setProperties(String properties) {
            this.properties = properties;
        }

        @Override
        public final Builder properties(String properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public User build() {
            return new User(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
