/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalizeruntime;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.personalizeruntime.model.GetPersonalizedRankingRequest;
import software.amazon.awssdk.services.personalizeruntime.model.GetPersonalizedRankingResponse;
import software.amazon.awssdk.services.personalizeruntime.model.GetRecommendationsRequest;
import software.amazon.awssdk.services.personalizeruntime.model.GetRecommendationsResponse;

/**
 * Service client for accessing Amazon Personalize Runtime asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public interface PersonalizeRuntimeAsyncClient extends SdkClient {
    String SERVICE_NAME = "personalize";

    /**
     * Create a {@link PersonalizeRuntimeAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static PersonalizeRuntimeAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link PersonalizeRuntimeAsyncClient}.
     */
    static PersonalizeRuntimeAsyncClientBuilder builder() {
        return new DefaultPersonalizeRuntimeAsyncClientBuilder();
    }

    /**
     * <p>
     * Re-ranks a list of recommended items for the given user. The first item in the list is deemed the most likely
     * item to be of interest to the user.
     * </p>
     * <note>
     * <p>
     * The solution backing the campaign must have been created using a recipe of type PERSONALIZED_RANKING.
     * </p>
     * </note>
     *
     * @param getPersonalizedRankingRequest
     * @return A Java Future containing the result of the GetPersonalizedRanking operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PersonalizeRuntimeAsyncClient.GetPersonalizedRanking
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/personalize-runtime-2018-05-22/GetPersonalizedRanking"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPersonalizedRankingResponse> getPersonalizedRanking(
            GetPersonalizedRankingRequest getPersonalizedRankingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Re-ranks a list of recommended items for the given user. The first item in the list is deemed the most likely
     * item to be of interest to the user.
     * </p>
     * <note>
     * <p>
     * The solution backing the campaign must have been created using a recipe of type PERSONALIZED_RANKING.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPersonalizedRankingRequest.Builder} avoiding the
     * need to create one manually via {@link GetPersonalizedRankingRequest#builder()}
     * </p>
     *
     * @param getPersonalizedRankingRequest
     *        A {@link Consumer} that will call methods on {@link GetPersonalizedRankingRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetPersonalizedRanking operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PersonalizeRuntimeAsyncClient.GetPersonalizedRanking
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/personalize-runtime-2018-05-22/GetPersonalizedRanking"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPersonalizedRankingResponse> getPersonalizedRanking(
            Consumer<GetPersonalizedRankingRequest.Builder> getPersonalizedRankingRequest) {
        return getPersonalizedRanking(GetPersonalizedRankingRequest.builder().applyMutation(getPersonalizedRankingRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of recommended items. The required input depends on the recipe type used to create the solution
     * backing the campaign, as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * RELATED_ITEMS - <code>itemId</code> required, <code>userId</code> not used
     * </p>
     * </li>
     * <li>
     * <p>
     * USER_PERSONALIZATION - <code>itemId</code> optional, <code>userId</code> required
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Campaigns that are backed by a solution created using a recipe of type PERSONALIZED_RANKING use the API.
     * </p>
     * </note>
     *
     * @param getRecommendationsRequest
     * @return A Java Future containing the result of the GetRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PersonalizeRuntimeAsyncClient.GetRecommendations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/personalize-runtime-2018-05-22/GetRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecommendationsResponse> getRecommendations(GetRecommendationsRequest getRecommendationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of recommended items. The required input depends on the recipe type used to create the solution
     * backing the campaign, as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * RELATED_ITEMS - <code>itemId</code> required, <code>userId</code> not used
     * </p>
     * </li>
     * <li>
     * <p>
     * USER_PERSONALIZATION - <code>itemId</code> optional, <code>userId</code> required
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Campaigns that are backed by a solution created using a recipe of type PERSONALIZED_RANKING use the API.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRecommendationsRequest.Builder} avoiding the
     * need to create one manually via {@link GetRecommendationsRequest#builder()}
     * </p>
     *
     * @param getRecommendationsRequest
     *        A {@link Consumer} that will call methods on {@link GetRecommendationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PersonalizeRuntimeAsyncClient.GetRecommendations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/personalize-runtime-2018-05-22/GetRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecommendationsResponse> getRecommendations(
            Consumer<GetRecommendationsRequest.Builder> getRecommendationsRequest) {
        return getRecommendations(GetRecommendationsRequest.builder().applyMutation(getRecommendationsRequest).build());
    }
}
