/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalizeruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that identifies an item.
 * </p>
 * <p>
 * The and APIs return a list of <code>PredictedItem</code>s.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PredictedItem implements SdkPojo, Serializable, ToCopyableBuilder<PredictedItem.Builder, PredictedItem> {
    private static final SdkField<String> ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PredictedItem::itemId)).setter(setter(Builder::itemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemId").build()).build();

    private static final SdkField<Double> SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(PredictedItem::score)).setter(setter(Builder::score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("score").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_ID_FIELD, SCORE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String itemId;

    private final Double score;

    private PredictedItem(BuilderImpl builder) {
        this.itemId = builder.itemId;
        this.score = builder.score;
    }

    /**
     * <p>
     * The recommended item ID.
     * </p>
     * 
     * @return The recommended item ID.
     */
    public String itemId() {
        return itemId;
    }

    /**
     * <p>
     * A numeric representation of the model's certainty that the item will be the next user selection. For more
     * information on scoring logic, see <a>how-scores-work</a>.
     * </p>
     * 
     * @return A numeric representation of the model's certainty that the item will be the next user selection. For more
     *         information on scoring logic, see <a>how-scores-work</a>.
     */
    public Double score() {
        return score;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(itemId());
        hashCode = 31 * hashCode + Objects.hashCode(score());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictedItem)) {
            return false;
        }
        PredictedItem other = (PredictedItem) obj;
        return Objects.equals(itemId(), other.itemId()) && Objects.equals(score(), other.score());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PredictedItem").add("ItemId", itemId()).add("Score", score()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "itemId":
            return Optional.ofNullable(clazz.cast(itemId()));
        case "score":
            return Optional.ofNullable(clazz.cast(score()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PredictedItem, T> g) {
        return obj -> g.apply((PredictedItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PredictedItem> {
        /**
         * <p>
         * The recommended item ID.
         * </p>
         * 
         * @param itemId
         *        The recommended item ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemId(String itemId);

        /**
         * <p>
         * A numeric representation of the model's certainty that the item will be the next user selection. For more
         * information on scoring logic, see <a>how-scores-work</a>.
         * </p>
         * 
         * @param score
         *        A numeric representation of the model's certainty that the item will be the next user selection. For
         *        more information on scoring logic, see <a>how-scores-work</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(Double score);
    }

    static final class BuilderImpl implements Builder {
        private String itemId;

        private Double score;

        private BuilderImpl() {
        }

        private BuilderImpl(PredictedItem model) {
            itemId(model.itemId);
            score(model.score);
        }

        public final String getItemId() {
            return itemId;
        }

        @Override
        public final Builder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        public final void setItemId(String itemId) {
            this.itemId = itemId;
        }

        public final Double getScore() {
            return score;
        }

        @Override
        public final Builder score(Double score) {
            this.score = score;
            return this;
        }

        public final void setScore(Double score) {
            this.score = score;
        }

        @Override
        public PredictedItem build() {
            return new PredictedItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
