/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalizeruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRecommendationsRequest extends PersonalizeRuntimeRequest implements
        ToCopyableBuilder<GetRecommendationsRequest.Builder, GetRecommendationsRequest> {
    private static final SdkField<String> CAMPAIGN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("campaignArn").getter(getter(GetRecommendationsRequest::campaignArn))
            .setter(setter(Builder::campaignArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("campaignArn").build()).build();

    private static final SdkField<String> ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("itemId")
            .getter(getter(GetRecommendationsRequest::itemId)).setter(setter(Builder::itemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemId").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(GetRecommendationsRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()).build();

    private static final SdkField<Integer> NUM_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numResults").getter(getter(GetRecommendationsRequest::numResults)).setter(setter(Builder::numResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numResults").build()).build();

    private static final SdkField<Map<String, String>> CONTEXT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("context")
            .getter(getter(GetRecommendationsRequest::context))
            .setter(setter(Builder::context))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> FILTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterArn").getter(getter(GetRecommendationsRequest::filterArn)).setter(setter(Builder::filterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterArn").build()).build();

    private static final SdkField<Map<String, String>> FILTER_VALUES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("filterValues")
            .getter(getter(GetRecommendationsRequest::filterValues))
            .setter(setter(Builder::filterValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterValues").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGN_ARN_FIELD,
            ITEM_ID_FIELD, USER_ID_FIELD, NUM_RESULTS_FIELD, CONTEXT_FIELD, FILTER_ARN_FIELD, FILTER_VALUES_FIELD));

    private final String campaignArn;

    private final String itemId;

    private final String userId;

    private final Integer numResults;

    private final Map<String, String> context;

    private final String filterArn;

    private final Map<String, String> filterValues;

    private GetRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.campaignArn = builder.campaignArn;
        this.itemId = builder.itemId;
        this.userId = builder.userId;
        this.numResults = builder.numResults;
        this.context = builder.context;
        this.filterArn = builder.filterArn;
        this.filterValues = builder.filterValues;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the campaign to use for getting recommendations.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the campaign to use for getting recommendations.
     */
    public String campaignArn() {
        return campaignArn;
    }

    /**
     * <p>
     * The item ID to provide recommendations for.
     * </p>
     * <p>
     * Required for <code>RELATED_ITEMS</code> recipe type.
     * </p>
     * 
     * @return The item ID to provide recommendations for.</p>
     *         <p>
     *         Required for <code>RELATED_ITEMS</code> recipe type.
     */
    public String itemId() {
        return itemId;
    }

    /**
     * <p>
     * The user ID to provide recommendations for.
     * </p>
     * <p>
     * Required for <code>USER_PERSONALIZATION</code> recipe type.
     * </p>
     * 
     * @return The user ID to provide recommendations for.</p>
     *         <p>
     *         Required for <code>USER_PERSONALIZATION</code> recipe type.
     */
    public String userId() {
        return userId;
    }

    /**
     * <p>
     * The number of results to return. The default is 25. The maximum is 500.
     * </p>
     * 
     * @return The number of results to return. The default is 25. The maximum is 500.
     */
    public Integer numResults() {
        return numResults;
    }

    /**
     * Returns true if the Context property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasContext() {
        return context != null && !(context instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The contextual metadata to use when getting recommendations. Contextual metadata includes any interaction
     * information that might be relevant when getting a user's recommendations, such as the user's current location or
     * device type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasContext()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The contextual metadata to use when getting recommendations. Contextual metadata includes any interaction
     *         information that might be relevant when getting a user's recommendations, such as the user's current
     *         location or device type.
     */
    public Map<String, String> context() {
        return context;
    }

    /**
     * <p>
     * The ARN of the filter to apply to the returned recommendations. For more information, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/filter.html">Filtering Recommendations</a>.
     * </p>
     * <p>
     * When using this parameter, be sure the filter resource is <code>ACTIVE</code>.
     * </p>
     * 
     * @return The ARN of the filter to apply to the returned recommendations. For more information, see <a
     *         href="https://docs.aws.amazon.com/personalize/latest/dg/filter.html">Filtering Recommendations</a>.</p>
     *         <p>
     *         When using this parameter, be sure the filter resource is <code>ACTIVE</code>.
     */
    public String filterArn() {
        return filterArn;
    }

    /**
     * Returns true if the FilterValues property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilterValues() {
        return filterValues != null && !(filterValues instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The values to use when filtering recommendations. For each placeholder parameter in your filter expression,
     * provide the parameter name (in matching case) as a key and the filter value(s) as the corresponding value.
     * Separate multiple values for one parameter with a comma.
     * </p>
     * <p>
     * For filter expressions that use an <code>INCLUDE</code> element to include items, you must provide values for all
     * parameters that are defined in the expression. For filters with expressions that use an <code>EXCLUDE</code>
     * element to exclude items, you can omit the <code>filter-values</code>.In this case, Amazon Personalize doesn't
     * use that portion of the expression to filter recommendations.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/filter.html">Filtering
     * Recommendations</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilterValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The values to use when filtering recommendations. For each placeholder parameter in your filter
     *         expression, provide the parameter name (in matching case) as a key and the filter value(s) as the
     *         corresponding value. Separate multiple values for one parameter with a comma. </p>
     *         <p>
     *         For filter expressions that use an <code>INCLUDE</code> element to include items, you must provide values
     *         for all parameters that are defined in the expression. For filters with expressions that use an
     *         <code>EXCLUDE</code> element to exclude items, you can omit the <code>filter-values</code>.In this case,
     *         Amazon Personalize doesn't use that portion of the expression to filter recommendations.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/personalize/latest/dg/filter.html">Filtering Recommendations</a>.
     */
    public Map<String, String> filterValues() {
        return filterValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(campaignArn());
        hashCode = 31 * hashCode + Objects.hashCode(itemId());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(numResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasContext() ? context() : null);
        hashCode = 31 * hashCode + Objects.hashCode(filterArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterValues() ? filterValues() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecommendationsRequest)) {
            return false;
        }
        GetRecommendationsRequest other = (GetRecommendationsRequest) obj;
        return Objects.equals(campaignArn(), other.campaignArn()) && Objects.equals(itemId(), other.itemId())
                && Objects.equals(userId(), other.userId()) && Objects.equals(numResults(), other.numResults())
                && hasContext() == other.hasContext() && Objects.equals(context(), other.context())
                && Objects.equals(filterArn(), other.filterArn()) && hasFilterValues() == other.hasFilterValues()
                && Objects.equals(filterValues(), other.filterValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetRecommendationsRequest").add("CampaignArn", campaignArn()).add("ItemId", itemId())
                .add("UserId", userId()).add("NumResults", numResults())
                .add("Context", context() == null ? null : "*** Sensitive Data Redacted ***").add("FilterArn", filterArn())
                .add("FilterValues", filterValues() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "campaignArn":
            return Optional.ofNullable(clazz.cast(campaignArn()));
        case "itemId":
            return Optional.ofNullable(clazz.cast(itemId()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "numResults":
            return Optional.ofNullable(clazz.cast(numResults()));
        case "context":
            return Optional.ofNullable(clazz.cast(context()));
        case "filterArn":
            return Optional.ofNullable(clazz.cast(filterArn()));
        case "filterValues":
            return Optional.ofNullable(clazz.cast(filterValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRecommendationsRequest, T> g) {
        return obj -> g.apply((GetRecommendationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeRuntimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRecommendationsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the campaign to use for getting recommendations.
         * </p>
         * 
         * @param campaignArn
         *        The Amazon Resource Name (ARN) of the campaign to use for getting recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaignArn(String campaignArn);

        /**
         * <p>
         * The item ID to provide recommendations for.
         * </p>
         * <p>
         * Required for <code>RELATED_ITEMS</code> recipe type.
         * </p>
         * 
         * @param itemId
         *        The item ID to provide recommendations for.</p>
         *        <p>
         *        Required for <code>RELATED_ITEMS</code> recipe type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemId(String itemId);

        /**
         * <p>
         * The user ID to provide recommendations for.
         * </p>
         * <p>
         * Required for <code>USER_PERSONALIZATION</code> recipe type.
         * </p>
         * 
         * @param userId
         *        The user ID to provide recommendations for.</p>
         *        <p>
         *        Required for <code>USER_PERSONALIZATION</code> recipe type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The number of results to return. The default is 25. The maximum is 500.
         * </p>
         * 
         * @param numResults
         *        The number of results to return. The default is 25. The maximum is 500.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numResults(Integer numResults);

        /**
         * <p>
         * The contextual metadata to use when getting recommendations. Contextual metadata includes any interaction
         * information that might be relevant when getting a user's recommendations, such as the user's current location
         * or device type.
         * </p>
         * 
         * @param context
         *        The contextual metadata to use when getting recommendations. Contextual metadata includes any
         *        interaction information that might be relevant when getting a user's recommendations, such as the
         *        user's current location or device type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder context(Map<String, String> context);

        /**
         * <p>
         * The ARN of the filter to apply to the returned recommendations. For more information, see <a
         * href="https://docs.aws.amazon.com/personalize/latest/dg/filter.html">Filtering Recommendations</a>.
         * </p>
         * <p>
         * When using this parameter, be sure the filter resource is <code>ACTIVE</code>.
         * </p>
         * 
         * @param filterArn
         *        The ARN of the filter to apply to the returned recommendations. For more information, see <a
         *        href="https://docs.aws.amazon.com/personalize/latest/dg/filter.html">Filtering
         *        Recommendations</a>.</p>
         *        <p>
         *        When using this parameter, be sure the filter resource is <code>ACTIVE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterArn(String filterArn);

        /**
         * <p>
         * The values to use when filtering recommendations. For each placeholder parameter in your filter expression,
         * provide the parameter name (in matching case) as a key and the filter value(s) as the corresponding value.
         * Separate multiple values for one parameter with a comma.
         * </p>
         * <p>
         * For filter expressions that use an <code>INCLUDE</code> element to include items, you must provide values for
         * all parameters that are defined in the expression. For filters with expressions that use an
         * <code>EXCLUDE</code> element to exclude items, you can omit the <code>filter-values</code>.In this case,
         * Amazon Personalize doesn't use that portion of the expression to filter recommendations.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/filter.html">Filtering
         * Recommendations</a>.
         * </p>
         * 
         * @param filterValues
         *        The values to use when filtering recommendations. For each placeholder parameter in your filter
         *        expression, provide the parameter name (in matching case) as a key and the filter value(s) as the
         *        corresponding value. Separate multiple values for one parameter with a comma. </p>
         *        <p>
         *        For filter expressions that use an <code>INCLUDE</code> element to include items, you must provide
         *        values for all parameters that are defined in the expression. For filters with expressions that use an
         *        <code>EXCLUDE</code> element to exclude items, you can omit the <code>filter-values</code>.In this
         *        case, Amazon Personalize doesn't use that portion of the expression to filter recommendations.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/personalize/latest/dg/filter.html">Filtering Recommendations</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterValues(Map<String, String> filterValues);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PersonalizeRuntimeRequest.BuilderImpl implements Builder {
        private String campaignArn;

        private String itemId;

        private String userId;

        private Integer numResults;

        private Map<String, String> context = DefaultSdkAutoConstructMap.getInstance();

        private String filterArn;

        private Map<String, String> filterValues = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecommendationsRequest model) {
            super(model);
            campaignArn(model.campaignArn);
            itemId(model.itemId);
            userId(model.userId);
            numResults(model.numResults);
            context(model.context);
            filterArn(model.filterArn);
            filterValues(model.filterValues);
        }

        public final String getCampaignArn() {
            return campaignArn;
        }

        @Override
        public final Builder campaignArn(String campaignArn) {
            this.campaignArn = campaignArn;
            return this;
        }

        public final void setCampaignArn(String campaignArn) {
            this.campaignArn = campaignArn;
        }

        public final String getItemId() {
            return itemId;
        }

        @Override
        public final Builder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        public final void setItemId(String itemId) {
            this.itemId = itemId;
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final Integer getNumResults() {
            return numResults;
        }

        @Override
        public final Builder numResults(Integer numResults) {
            this.numResults = numResults;
            return this;
        }

        public final void setNumResults(Integer numResults) {
            this.numResults = numResults;
        }

        public final Map<String, String> getContext() {
            if (context instanceof SdkAutoConstructMap) {
                return null;
            }
            return context;
        }

        @Override
        public final Builder context(Map<String, String> context) {
            this.context = ContextCopier.copy(context);
            return this;
        }

        public final void setContext(Map<String, String> context) {
            this.context = ContextCopier.copy(context);
        }

        public final String getFilterArn() {
            return filterArn;
        }

        @Override
        public final Builder filterArn(String filterArn) {
            this.filterArn = filterArn;
            return this;
        }

        public final void setFilterArn(String filterArn) {
            this.filterArn = filterArn;
        }

        public final Map<String, String> getFilterValues() {
            if (filterValues instanceof SdkAutoConstructMap) {
                return null;
            }
            return filterValues;
        }

        @Override
        public final Builder filterValues(Map<String, String> filterValues) {
            this.filterValues = FilterValuesCopier.copy(filterValues);
            return this;
        }

        public final void setFilterValues(Map<String, String> filterValues) {
            this.filterValues = FilterValuesCopier.copy(filterValues);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRecommendationsRequest build() {
            return new GetRecommendationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
