/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalizeruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRecommendationsResponse extends PersonalizeRuntimeResponse implements
        ToCopyableBuilder<GetRecommendationsResponse.Builder, GetRecommendationsResponse> {
    private static final SdkField<List<PredictedItem>> ITEM_LIST_FIELD = SdkField
            .<List<PredictedItem>> builder(MarshallingType.LIST)
            .memberName("itemList")
            .getter(getter(GetRecommendationsResponse::itemList))
            .setter(setter(Builder::itemList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PredictedItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(PredictedItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recommendationId").getter(getter(GetRecommendationsResponse::recommendationId))
            .setter(setter(Builder::recommendationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_LIST_FIELD,
            RECOMMENDATION_ID_FIELD));

    private final List<PredictedItem> itemList;

    private final String recommendationId;

    private GetRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.itemList = builder.itemList;
        this.recommendationId = builder.recommendationId;
    }

    /**
     * Returns true if the ItemList property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasItemList() {
        return itemList != null && !(itemList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of recommendations sorted in ascending order by prediction score. There can be a maximum of 500 items in
     * the list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasItemList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of recommendations sorted in ascending order by prediction score. There can be a maximum of 500
     *         items in the list.
     */
    public List<PredictedItem> itemList() {
        return itemList;
    }

    /**
     * <p>
     * The ID of the recommendation.
     * </p>
     * 
     * @return The ID of the recommendation.
     */
    public String recommendationId() {
        return recommendationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasItemList() ? itemList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(recommendationId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecommendationsResponse)) {
            return false;
        }
        GetRecommendationsResponse other = (GetRecommendationsResponse) obj;
        return hasItemList() == other.hasItemList() && Objects.equals(itemList(), other.itemList())
                && Objects.equals(recommendationId(), other.recommendationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetRecommendationsResponse").add("ItemList", hasItemList() ? itemList() : null)
                .add("RecommendationId", recommendationId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "itemList":
            return Optional.ofNullable(clazz.cast(itemList()));
        case "recommendationId":
            return Optional.ofNullable(clazz.cast(recommendationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRecommendationsResponse, T> g) {
        return obj -> g.apply((GetRecommendationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeRuntimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRecommendationsResponse> {
        /**
         * <p>
         * A list of recommendations sorted in ascending order by prediction score. There can be a maximum of 500 items
         * in the list.
         * </p>
         * 
         * @param itemList
         *        A list of recommendations sorted in ascending order by prediction score. There can be a maximum of 500
         *        items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemList(Collection<PredictedItem> itemList);

        /**
         * <p>
         * A list of recommendations sorted in ascending order by prediction score. There can be a maximum of 500 items
         * in the list.
         * </p>
         * 
         * @param itemList
         *        A list of recommendations sorted in ascending order by prediction score. There can be a maximum of 500
         *        items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemList(PredictedItem... itemList);

        /**
         * <p>
         * A list of recommendations sorted in ascending order by prediction score. There can be a maximum of 500 items
         * in the list.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PredictedItem>.Builder} avoiding the need
         * to create one manually via {@link List<PredictedItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PredictedItem>.Builder#build()} is called immediately and
         * its result is passed to {@link #itemList(List<PredictedItem>)}.
         * 
         * @param itemList
         *        a consumer that will call methods on {@link List<PredictedItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #itemList(List<PredictedItem>)
         */
        Builder itemList(Consumer<PredictedItem.Builder>... itemList);

        /**
         * <p>
         * The ID of the recommendation.
         * </p>
         * 
         * @param recommendationId
         *        The ID of the recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationId(String recommendationId);
    }

    static final class BuilderImpl extends PersonalizeRuntimeResponse.BuilderImpl implements Builder {
        private List<PredictedItem> itemList = DefaultSdkAutoConstructList.getInstance();

        private String recommendationId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecommendationsResponse model) {
            super(model);
            itemList(model.itemList);
            recommendationId(model.recommendationId);
        }

        public final Collection<PredictedItem.Builder> getItemList() {
            if (itemList instanceof SdkAutoConstructList) {
                return null;
            }
            return itemList != null ? itemList.stream().map(PredictedItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder itemList(Collection<PredictedItem> itemList) {
            this.itemList = ItemListCopier.copy(itemList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder itemList(PredictedItem... itemList) {
            itemList(Arrays.asList(itemList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder itemList(Consumer<PredictedItem.Builder>... itemList) {
            itemList(Stream.of(itemList).map(c -> PredictedItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItemList(Collection<PredictedItem.BuilderImpl> itemList) {
            this.itemList = ItemListCopier.copyFromBuilder(itemList);
        }

        public final String getRecommendationId() {
            return recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public GetRecommendationsResponse build() {
            return new GetRecommendationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
