/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalizeruntime.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PredictedItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PredictedItem> {
    private static final SdkField<String> ITEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("itemId").getter(PredictedItem.getter(PredictedItem::itemId)).setter(PredictedItem.setter(Builder::itemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemId").build()}).build();
    private static final SdkField<Double> SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("score").getter(PredictedItem.getter(PredictedItem::score)).setter(PredictedItem.setter(Builder::score)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("score").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_ID_FIELD, SCORE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String itemId;
    private final Double score;

    private PredictedItem(BuilderImpl builder) {
        this.itemId = builder.itemId;
        this.score = builder.score;
    }

    public final String itemId() {
        return this.itemId;
    }

    public final Double score() {
        return this.score;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.itemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.score());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictedItem)) {
            return false;
        }
        PredictedItem other = (PredictedItem)obj;
        return Objects.equals(this.itemId(), other.itemId()) && Objects.equals(this.score(), other.score());
    }

    public final String toString() {
        return ToString.builder((String)"PredictedItem").add("ItemId", (Object)this.itemId()).add("Score", (Object)this.score()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "itemId": {
                return Optional.ofNullable(clazz.cast(this.itemId()));
            }
            case "score": {
                return Optional.ofNullable(clazz.cast(this.score()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PredictedItem, T> g) {
        return obj -> g.apply((PredictedItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String itemId;
        private Double score;

        private BuilderImpl() {
        }

        private BuilderImpl(PredictedItem model) {
            this.itemId(model.itemId);
            this.score(model.score);
        }

        public final String getItemId() {
            return this.itemId;
        }

        public final void setItemId(String itemId) {
            this.itemId = itemId;
        }

        @Override
        @Transient
        public final Builder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        public final Double getScore() {
            return this.score;
        }

        public final void setScore(Double score) {
            this.score = score;
        }

        @Override
        @Transient
        public final Builder score(Double score) {
            this.score = score;
            return this;
        }

        public PredictedItem build() {
            return new PredictedItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PredictedItem> {
        public Builder itemId(String var1);

        public Builder score(Double var1);
    }
}

