/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalizeruntime;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.personalizeruntime.model.GetActionRecommendationsRequest;
import software.amazon.awssdk.services.personalizeruntime.model.GetActionRecommendationsResponse;
import software.amazon.awssdk.services.personalizeruntime.model.GetPersonalizedRankingRequest;
import software.amazon.awssdk.services.personalizeruntime.model.GetPersonalizedRankingResponse;
import software.amazon.awssdk.services.personalizeruntime.model.GetRecommendationsRequest;
import software.amazon.awssdk.services.personalizeruntime.model.GetRecommendationsResponse;

/**
 * Service client for accessing Amazon Personalize Runtime asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@link SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface PersonalizeRuntimeAsyncClient extends AwsClient {
    String SERVICE_NAME = "personalize";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "personalize-runtime";

    /**
     * <p>
     * Returns a list of recommended actions in sorted in descending order by prediction score. Use the
     * <code>GetActionRecommendations</code> API if you have a custom campaign that deploys a solution version trained
     * with a PERSONALIZED_ACTIONS recipe.
     * </p>
     * <p>
     * For more information about PERSONALIZED_ACTIONS recipes, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/nexts-best-action-recipes.html">PERSONALIZED_ACTIONS
     * recipes</a>. For more information about getting action recommendations, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/get-action-recommendations.html">Getting action
     * recommendations</a>.
     * </p>
     *
     * @param getActionRecommendationsRequest
     * @return A Java Future containing the result of the GetActionRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PersonalizeRuntimeAsyncClient.GetActionRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-runtime-2018-05-22/GetActionRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetActionRecommendationsResponse> getActionRecommendations(
            GetActionRecommendationsRequest getActionRecommendationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of recommended actions in sorted in descending order by prediction score. Use the
     * <code>GetActionRecommendations</code> API if you have a custom campaign that deploys a solution version trained
     * with a PERSONALIZED_ACTIONS recipe.
     * </p>
     * <p>
     * For more information about PERSONALIZED_ACTIONS recipes, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/nexts-best-action-recipes.html">PERSONALIZED_ACTIONS
     * recipes</a>. For more information about getting action recommendations, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/get-action-recommendations.html">Getting action
     * recommendations</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetActionRecommendationsRequest.Builder} avoiding
     * the need to create one manually via {@link GetActionRecommendationsRequest#builder()}
     * </p>
     *
     * @param getActionRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.personalizeruntime.model.GetActionRecommendationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetActionRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PersonalizeRuntimeAsyncClient.GetActionRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-runtime-2018-05-22/GetActionRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetActionRecommendationsResponse> getActionRecommendations(
            Consumer<GetActionRecommendationsRequest.Builder> getActionRecommendationsRequest) {
        return getActionRecommendations(GetActionRecommendationsRequest.builder().applyMutation(getActionRecommendationsRequest)
                .build());
    }

    /**
     * <p>
     * Re-ranks a list of recommended items for the given user. The first item in the list is deemed the most likely
     * item to be of interest to the user.
     * </p>
     * <note>
     * <p>
     * The solution backing the campaign must have been created using a recipe of type PERSONALIZED_RANKING.
     * </p>
     * </note>
     *
     * @param getPersonalizedRankingRequest
     * @return A Java Future containing the result of the GetPersonalizedRanking operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PersonalizeRuntimeAsyncClient.GetPersonalizedRanking
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-runtime-2018-05-22/GetPersonalizedRanking"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPersonalizedRankingResponse> getPersonalizedRanking(
            GetPersonalizedRankingRequest getPersonalizedRankingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Re-ranks a list of recommended items for the given user. The first item in the list is deemed the most likely
     * item to be of interest to the user.
     * </p>
     * <note>
     * <p>
     * The solution backing the campaign must have been created using a recipe of type PERSONALIZED_RANKING.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPersonalizedRankingRequest.Builder} avoiding the
     * need to create one manually via {@link GetPersonalizedRankingRequest#builder()}
     * </p>
     *
     * @param getPersonalizedRankingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.personalizeruntime.model.GetPersonalizedRankingRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetPersonalizedRanking operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PersonalizeRuntimeAsyncClient.GetPersonalizedRanking
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-runtime-2018-05-22/GetPersonalizedRanking"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPersonalizedRankingResponse> getPersonalizedRanking(
            Consumer<GetPersonalizedRankingRequest.Builder> getPersonalizedRankingRequest) {
        return getPersonalizedRanking(GetPersonalizedRankingRequest.builder().applyMutation(getPersonalizedRankingRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of recommended items. For campaigns, the campaign's Amazon Resource Name (ARN) is required and the
     * required user and item input depends on the recipe type used to create the solution backing the campaign as
     * follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * USER_PERSONALIZATION - <code>userId</code> required, <code>itemId</code> not used
     * </p>
     * </li>
     * <li>
     * <p>
     * RELATED_ITEMS - <code>itemId</code> required, <code>userId</code> not used
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Campaigns that are backed by a solution created using a recipe of type PERSONALIZED_RANKING use the API.
     * </p>
     * </note>
     * <p>
     * For recommenders, the recommender's ARN is required and the required item and user input depends on the use case
     * (domain-based recipe) backing the recommender. For information on use case requirements see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/domain-use-cases.html">Choosing recommender use
     * cases</a>.
     * </p>
     *
     * @param getRecommendationsRequest
     * @return A Java Future containing the result of the GetRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PersonalizeRuntimeAsyncClient.GetRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-runtime-2018-05-22/GetRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecommendationsResponse> getRecommendations(GetRecommendationsRequest getRecommendationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of recommended items. For campaigns, the campaign's Amazon Resource Name (ARN) is required and the
     * required user and item input depends on the recipe type used to create the solution backing the campaign as
     * follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * USER_PERSONALIZATION - <code>userId</code> required, <code>itemId</code> not used
     * </p>
     * </li>
     * <li>
     * <p>
     * RELATED_ITEMS - <code>itemId</code> required, <code>userId</code> not used
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Campaigns that are backed by a solution created using a recipe of type PERSONALIZED_RANKING use the API.
     * </p>
     * </note>
     * <p>
     * For recommenders, the recommender's ARN is required and the required item and user input depends on the use case
     * (domain-based recipe) backing the recommender. For information on use case requirements see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/domain-use-cases.html">Choosing recommender use
     * cases</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRecommendationsRequest.Builder} avoiding the
     * need to create one manually via {@link GetRecommendationsRequest#builder()}
     * </p>
     *
     * @param getRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.personalizeruntime.model.GetRecommendationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException Provide a valid value for the field or parameter.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PersonalizeRuntimeException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample PersonalizeRuntimeAsyncClient.GetRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/personalize-runtime-2018-05-22/GetRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecommendationsResponse> getRecommendations(
            Consumer<GetRecommendationsRequest.Builder> getRecommendationsRequest) {
        return getRecommendations(GetRecommendationsRequest.builder().applyMutation(getRecommendationsRequest).build());
    }

    @Override
    default PersonalizeRuntimeServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link PersonalizeRuntimeAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static PersonalizeRuntimeAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link PersonalizeRuntimeAsyncClient}.
     */
    static PersonalizeRuntimeAsyncClientBuilder builder() {
        return new DefaultPersonalizeRuntimeAsyncClientBuilder();
    }
}
