/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalizeruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRecommendationsResponse extends PersonalizeRuntimeResponse implements
        ToCopyableBuilder<GetRecommendationsResponse.Builder, GetRecommendationsResponse> {
    private static final SdkField<List<PredictedItem>> ITEM_LIST_FIELD = SdkField
            .<List<PredictedItem>> builder(MarshallingType.LIST)
            .memberName("itemList")
            .getter(getter(GetRecommendationsResponse::itemList))
            .setter(setter(Builder::itemList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PredictedItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(PredictedItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recommendationId").getter(getter(GetRecommendationsResponse::recommendationId))
            .setter(setter(Builder::recommendationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_LIST_FIELD,
            RECOMMENDATION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<PredictedItem> itemList;

    private final String recommendationId;

    private GetRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.itemList = builder.itemList;
        this.recommendationId = builder.recommendationId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ItemList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasItemList() {
        return itemList != null && !(itemList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of recommendations sorted in descending order by prediction score. There can be a maximum of 500 items in
     * the list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItemList} method.
     * </p>
     * 
     * @return A list of recommendations sorted in descending order by prediction score. There can be a maximum of 500
     *         items in the list.
     */
    public final List<PredictedItem> itemList() {
        return itemList;
    }

    /**
     * <p>
     * The ID of the recommendation.
     * </p>
     * 
     * @return The ID of the recommendation.
     */
    public final String recommendationId() {
        return recommendationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasItemList() ? itemList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(recommendationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecommendationsResponse)) {
            return false;
        }
        GetRecommendationsResponse other = (GetRecommendationsResponse) obj;
        return hasItemList() == other.hasItemList() && Objects.equals(itemList(), other.itemList())
                && Objects.equals(recommendationId(), other.recommendationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRecommendationsResponse").add("ItemList", hasItemList() ? itemList() : null)
                .add("RecommendationId", recommendationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "itemList":
            return Optional.ofNullable(clazz.cast(itemList()));
        case "recommendationId":
            return Optional.ofNullable(clazz.cast(recommendationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("itemList", ITEM_LIST_FIELD);
        map.put("recommendationId", RECOMMENDATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRecommendationsResponse, T> g) {
        return obj -> g.apply((GetRecommendationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeRuntimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRecommendationsResponse> {
        /**
         * <p>
         * A list of recommendations sorted in descending order by prediction score. There can be a maximum of 500 items
         * in the list.
         * </p>
         * 
         * @param itemList
         *        A list of recommendations sorted in descending order by prediction score. There can be a maximum of
         *        500 items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemList(Collection<PredictedItem> itemList);

        /**
         * <p>
         * A list of recommendations sorted in descending order by prediction score. There can be a maximum of 500 items
         * in the list.
         * </p>
         * 
         * @param itemList
         *        A list of recommendations sorted in descending order by prediction score. There can be a maximum of
         *        500 items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemList(PredictedItem... itemList);

        /**
         * <p>
         * A list of recommendations sorted in descending order by prediction score. There can be a maximum of 500 items
         * in the list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.personalizeruntime.model.PredictedItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.personalizeruntime.model.PredictedItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.personalizeruntime.model.PredictedItem.Builder#build()} is called
         * immediately and its result is passed to {@link #itemList(List<PredictedItem>)}.
         * 
         * @param itemList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.personalizeruntime.model.PredictedItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #itemList(java.util.Collection<PredictedItem>)
         */
        Builder itemList(Consumer<PredictedItem.Builder>... itemList);

        /**
         * <p>
         * The ID of the recommendation.
         * </p>
         * 
         * @param recommendationId
         *        The ID of the recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationId(String recommendationId);
    }

    static final class BuilderImpl extends PersonalizeRuntimeResponse.BuilderImpl implements Builder {
        private List<PredictedItem> itemList = DefaultSdkAutoConstructList.getInstance();

        private String recommendationId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecommendationsResponse model) {
            super(model);
            itemList(model.itemList);
            recommendationId(model.recommendationId);
        }

        public final List<PredictedItem.Builder> getItemList() {
            List<PredictedItem.Builder> result = ItemListCopier.copyToBuilder(this.itemList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItemList(Collection<PredictedItem.BuilderImpl> itemList) {
            this.itemList = ItemListCopier.copyFromBuilder(itemList);
        }

        @Override
        public final Builder itemList(Collection<PredictedItem> itemList) {
            this.itemList = ItemListCopier.copy(itemList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder itemList(PredictedItem... itemList) {
            itemList(Arrays.asList(itemList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder itemList(Consumer<PredictedItem.Builder>... itemList) {
            itemList(Stream.of(itemList).map(c -> PredictedItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRecommendationId() {
            return recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        @Override
        public GetRecommendationsResponse build() {
            return new GetRecommendationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
