/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalizeruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPersonalizedRankingRequest extends PersonalizeRuntimeRequest implements
        ToCopyableBuilder<GetPersonalizedRankingRequest.Builder, GetPersonalizedRankingRequest> {
    private static final SdkField<String> CAMPAIGN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("campaignArn").getter(getter(GetPersonalizedRankingRequest::campaignArn))
            .setter(setter(Builder::campaignArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("campaignArn").build()).build();

    private static final SdkField<List<String>> INPUT_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("inputList")
            .getter(getter(GetPersonalizedRankingRequest::inputList))
            .setter(setter(Builder::inputList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("userId")
            .getter(getter(GetPersonalizedRankingRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()).build();

    private static final SdkField<Map<String, String>> CONTEXT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("context")
            .getter(getter(GetPersonalizedRankingRequest::context))
            .setter(setter(Builder::context))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> FILTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterArn").getter(getter(GetPersonalizedRankingRequest::filterArn)).setter(setter(Builder::filterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterArn").build()).build();

    private static final SdkField<Map<String, String>> FILTER_VALUES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("filterValues")
            .getter(getter(GetPersonalizedRankingRequest::filterValues))
            .setter(setter(Builder::filterValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterValues").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, List<String>>> METADATA_COLUMNS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("metadataColumns")
            .getter(getter(GetPersonalizedRankingRequest::metadataColumns))
            .setter(setter(Builder::metadataColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataColumns").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGN_ARN_FIELD,
            INPUT_LIST_FIELD, USER_ID_FIELD, CONTEXT_FIELD, FILTER_ARN_FIELD, FILTER_VALUES_FIELD, METADATA_COLUMNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String campaignArn;

    private final List<String> inputList;

    private final String userId;

    private final Map<String, String> context;

    private final String filterArn;

    private final Map<String, String> filterValues;

    private final Map<String, List<String>> metadataColumns;

    private GetPersonalizedRankingRequest(BuilderImpl builder) {
        super(builder);
        this.campaignArn = builder.campaignArn;
        this.inputList = builder.inputList;
        this.userId = builder.userId;
        this.context = builder.context;
        this.filterArn = builder.filterArn;
        this.filterValues = builder.filterValues;
        this.metadataColumns = builder.metadataColumns;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the campaign to use for generating the personalized ranking.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the campaign to use for generating the personalized ranking.
     */
    public final String campaignArn() {
        return campaignArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputList() {
        return inputList != null && !(inputList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of items (by <code>itemId</code>) to rank. If an item was not included in the training dataset, the item
     * is appended to the end of the reranked list. If you are including metadata in recommendations, the maximum is 50.
     * Otherwise, the maximum is 500.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputList} method.
     * </p>
     * 
     * @return A list of items (by <code>itemId</code>) to rank. If an item was not included in the training dataset,
     *         the item is appended to the end of the reranked list. If you are including metadata in recommendations,
     *         the maximum is 50. Otherwise, the maximum is 500.
     */
    public final List<String> inputList() {
        return inputList;
    }

    /**
     * <p>
     * The user for which you want the campaign to provide a personalized ranking.
     * </p>
     * 
     * @return The user for which you want the campaign to provide a personalized ranking.
     */
    public final String userId() {
        return userId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Context property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContext() {
        return context != null && !(context instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The contextual metadata to use when getting recommendations. Contextual metadata includes any interaction
     * information that might be relevant when getting a user's recommendations, such as the user's current location or
     * device type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContext} method.
     * </p>
     * 
     * @return The contextual metadata to use when getting recommendations. Contextual metadata includes any interaction
     *         information that might be relevant when getting a user's recommendations, such as the user's current
     *         location or device type.
     */
    public final Map<String, String> context() {
        return context;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a filter you created to include items or exclude items from recommendations for
     * a given user. For more information, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/filter.html">Filtering Recommendations</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a filter you created to include items or exclude items from
     *         recommendations for a given user. For more information, see <a
     *         href="https://docs.aws.amazon.com/personalize/latest/dg/filter.html">Filtering Recommendations</a>.
     */
    public final String filterArn() {
        return filterArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the FilterValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFilterValues() {
        return filterValues != null && !(filterValues instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The values to use when filtering recommendations. For each placeholder parameter in your filter expression,
     * provide the parameter name (in matching case) as a key and the filter value(s) as the corresponding value.
     * Separate multiple values for one parameter with a comma.
     * </p>
     * <p>
     * For filter expressions that use an <code>INCLUDE</code> element to include items, you must provide values for all
     * parameters that are defined in the expression. For filters with expressions that use an <code>EXCLUDE</code>
     * element to exclude items, you can omit the <code>filter-values</code>.In this case, Amazon Personalize doesn't
     * use that portion of the expression to filter recommendations.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/filter.html">Filtering
     * Recommendations</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilterValues} method.
     * </p>
     * 
     * @return The values to use when filtering recommendations. For each placeholder parameter in your filter
     *         expression, provide the parameter name (in matching case) as a key and the filter value(s) as the
     *         corresponding value. Separate multiple values for one parameter with a comma. </p>
     *         <p>
     *         For filter expressions that use an <code>INCLUDE</code> element to include items, you must provide values
     *         for all parameters that are defined in the expression. For filters with expressions that use an
     *         <code>EXCLUDE</code> element to exclude items, you can omit the <code>filter-values</code>.In this case,
     *         Amazon Personalize doesn't use that portion of the expression to filter recommendations.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/personalize/latest/dg/filter.html">Filtering Recommendations</a>.
     */
    public final Map<String, String> filterValues() {
        return filterValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetadataColumns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetadataColumns() {
        return metadataColumns != null && !(metadataColumns instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * If you enabled metadata in recommendations when you created or updated the campaign, specify metadata columns
     * from your Items dataset to include in the personalized ranking. The map key is <code>ITEMS</code> and the value
     * is a list of column names from your Items dataset. The maximum number of columns you can provide is 10.
     * </p>
     * <p>
     * For information about enabling metadata for a campaign, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-return-metadata">Enabling
     * metadata in recommendations for a campaign</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetadataColumns} method.
     * </p>
     * 
     * @return If you enabled metadata in recommendations when you created or updated the campaign, specify metadata
     *         columns from your Items dataset to include in the personalized ranking. The map key is <code>ITEMS</code>
     *         and the value is a list of column names from your Items dataset. The maximum number of columns you can
     *         provide is 10.</p>
     *         <p>
     *         For information about enabling metadata for a campaign, see <a
     *         href="https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-return-metadata"
     *         >Enabling metadata in recommendations for a campaign</a>.
     */
    public final Map<String, List<String>> metadataColumns() {
        return metadataColumns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(campaignArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputList() ? inputList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(hasContext() ? context() : null);
        hashCode = 31 * hashCode + Objects.hashCode(filterArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterValues() ? filterValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadataColumns() ? metadataColumns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPersonalizedRankingRequest)) {
            return false;
        }
        GetPersonalizedRankingRequest other = (GetPersonalizedRankingRequest) obj;
        return Objects.equals(campaignArn(), other.campaignArn()) && hasInputList() == other.hasInputList()
                && Objects.equals(inputList(), other.inputList()) && Objects.equals(userId(), other.userId())
                && hasContext() == other.hasContext() && Objects.equals(context(), other.context())
                && Objects.equals(filterArn(), other.filterArn()) && hasFilterValues() == other.hasFilterValues()
                && Objects.equals(filterValues(), other.filterValues()) && hasMetadataColumns() == other.hasMetadataColumns()
                && Objects.equals(metadataColumns(), other.metadataColumns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPersonalizedRankingRequest").add("CampaignArn", campaignArn())
                .add("InputList", hasInputList() ? inputList() : null).add("UserId", userId())
                .add("Context", context() == null ? null : "*** Sensitive Data Redacted ***").add("FilterArn", filterArn())
                .add("FilterValues", filterValues() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MetadataColumns", hasMetadataColumns() ? metadataColumns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "campaignArn":
            return Optional.ofNullable(clazz.cast(campaignArn()));
        case "inputList":
            return Optional.ofNullable(clazz.cast(inputList()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "context":
            return Optional.ofNullable(clazz.cast(context()));
        case "filterArn":
            return Optional.ofNullable(clazz.cast(filterArn()));
        case "filterValues":
            return Optional.ofNullable(clazz.cast(filterValues()));
        case "metadataColumns":
            return Optional.ofNullable(clazz.cast(metadataColumns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("campaignArn", CAMPAIGN_ARN_FIELD);
        map.put("inputList", INPUT_LIST_FIELD);
        map.put("userId", USER_ID_FIELD);
        map.put("context", CONTEXT_FIELD);
        map.put("filterArn", FILTER_ARN_FIELD);
        map.put("filterValues", FILTER_VALUES_FIELD);
        map.put("metadataColumns", METADATA_COLUMNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPersonalizedRankingRequest, T> g) {
        return obj -> g.apply((GetPersonalizedRankingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PersonalizeRuntimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetPersonalizedRankingRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the campaign to use for generating the personalized ranking.
         * </p>
         * 
         * @param campaignArn
         *        The Amazon Resource Name (ARN) of the campaign to use for generating the personalized ranking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaignArn(String campaignArn);

        /**
         * <p>
         * A list of items (by <code>itemId</code>) to rank. If an item was not included in the training dataset, the
         * item is appended to the end of the reranked list. If you are including metadata in recommendations, the
         * maximum is 50. Otherwise, the maximum is 500.
         * </p>
         * 
         * @param inputList
         *        A list of items (by <code>itemId</code>) to rank. If an item was not included in the training dataset,
         *        the item is appended to the end of the reranked list. If you are including metadata in
         *        recommendations, the maximum is 50. Otherwise, the maximum is 500.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputList(Collection<String> inputList);

        /**
         * <p>
         * A list of items (by <code>itemId</code>) to rank. If an item was not included in the training dataset, the
         * item is appended to the end of the reranked list. If you are including metadata in recommendations, the
         * maximum is 50. Otherwise, the maximum is 500.
         * </p>
         * 
         * @param inputList
         *        A list of items (by <code>itemId</code>) to rank. If an item was not included in the training dataset,
         *        the item is appended to the end of the reranked list. If you are including metadata in
         *        recommendations, the maximum is 50. Otherwise, the maximum is 500.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputList(String... inputList);

        /**
         * <p>
         * The user for which you want the campaign to provide a personalized ranking.
         * </p>
         * 
         * @param userId
         *        The user for which you want the campaign to provide a personalized ranking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The contextual metadata to use when getting recommendations. Contextual metadata includes any interaction
         * information that might be relevant when getting a user's recommendations, such as the user's current location
         * or device type.
         * </p>
         * 
         * @param context
         *        The contextual metadata to use when getting recommendations. Contextual metadata includes any
         *        interaction information that might be relevant when getting a user's recommendations, such as the
         *        user's current location or device type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder context(Map<String, String> context);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a filter you created to include items or exclude items from recommendations
         * for a given user. For more information, see <a
         * href="https://docs.aws.amazon.com/personalize/latest/dg/filter.html">Filtering Recommendations</a>.
         * </p>
         * 
         * @param filterArn
         *        The Amazon Resource Name (ARN) of a filter you created to include items or exclude items from
         *        recommendations for a given user. For more information, see <a
         *        href="https://docs.aws.amazon.com/personalize/latest/dg/filter.html">Filtering Recommendations</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterArn(String filterArn);

        /**
         * <p>
         * The values to use when filtering recommendations. For each placeholder parameter in your filter expression,
         * provide the parameter name (in matching case) as a key and the filter value(s) as the corresponding value.
         * Separate multiple values for one parameter with a comma.
         * </p>
         * <p>
         * For filter expressions that use an <code>INCLUDE</code> element to include items, you must provide values for
         * all parameters that are defined in the expression. For filters with expressions that use an
         * <code>EXCLUDE</code> element to exclude items, you can omit the <code>filter-values</code>.In this case,
         * Amazon Personalize doesn't use that portion of the expression to filter recommendations.
         * </p>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/filter.html">Filtering
         * Recommendations</a>.
         * </p>
         * 
         * @param filterValues
         *        The values to use when filtering recommendations. For each placeholder parameter in your filter
         *        expression, provide the parameter name (in matching case) as a key and the filter value(s) as the
         *        corresponding value. Separate multiple values for one parameter with a comma. </p>
         *        <p>
         *        For filter expressions that use an <code>INCLUDE</code> element to include items, you must provide
         *        values for all parameters that are defined in the expression. For filters with expressions that use an
         *        <code>EXCLUDE</code> element to exclude items, you can omit the <code>filter-values</code>.In this
         *        case, Amazon Personalize doesn't use that portion of the expression to filter recommendations.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/personalize/latest/dg/filter.html">Filtering Recommendations</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterValues(Map<String, String> filterValues);

        /**
         * <p>
         * If you enabled metadata in recommendations when you created or updated the campaign, specify metadata columns
         * from your Items dataset to include in the personalized ranking. The map key is <code>ITEMS</code> and the
         * value is a list of column names from your Items dataset. The maximum number of columns you can provide is 10.
         * </p>
         * <p>
         * For information about enabling metadata for a campaign, see <a
         * href="https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-return-metadata"
         * >Enabling metadata in recommendations for a campaign</a>.
         * </p>
         * 
         * @param metadataColumns
         *        If you enabled metadata in recommendations when you created or updated the campaign, specify metadata
         *        columns from your Items dataset to include in the personalized ranking. The map key is
         *        <code>ITEMS</code> and the value is a list of column names from your Items dataset. The maximum number
         *        of columns you can provide is 10.</p>
         *        <p>
         *        For information about enabling metadata for a campaign, see <a href=
         *        "https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-return-metadata"
         *        >Enabling metadata in recommendations for a campaign</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataColumns(Map<String, ? extends Collection<String>> metadataColumns);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PersonalizeRuntimeRequest.BuilderImpl implements Builder {
        private String campaignArn;

        private List<String> inputList = DefaultSdkAutoConstructList.getInstance();

        private String userId;

        private Map<String, String> context = DefaultSdkAutoConstructMap.getInstance();

        private String filterArn;

        private Map<String, String> filterValues = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, List<String>> metadataColumns = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPersonalizedRankingRequest model) {
            super(model);
            campaignArn(model.campaignArn);
            inputList(model.inputList);
            userId(model.userId);
            context(model.context);
            filterArn(model.filterArn);
            filterValues(model.filterValues);
            metadataColumns(model.metadataColumns);
        }

        public final String getCampaignArn() {
            return campaignArn;
        }

        public final void setCampaignArn(String campaignArn) {
            this.campaignArn = campaignArn;
        }

        @Override
        public final Builder campaignArn(String campaignArn) {
            this.campaignArn = campaignArn;
            return this;
        }

        public final Collection<String> getInputList() {
            if (inputList instanceof SdkAutoConstructList) {
                return null;
            }
            return inputList;
        }

        public final void setInputList(Collection<String> inputList) {
            this.inputList = InputListCopier.copy(inputList);
        }

        @Override
        public final Builder inputList(Collection<String> inputList) {
            this.inputList = InputListCopier.copy(inputList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputList(String... inputList) {
            inputList(Arrays.asList(inputList));
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final Map<String, String> getContext() {
            if (context instanceof SdkAutoConstructMap) {
                return null;
            }
            return context;
        }

        public final void setContext(Map<String, String> context) {
            this.context = ContextCopier.copy(context);
        }

        @Override
        public final Builder context(Map<String, String> context) {
            this.context = ContextCopier.copy(context);
            return this;
        }

        public final String getFilterArn() {
            return filterArn;
        }

        public final void setFilterArn(String filterArn) {
            this.filterArn = filterArn;
        }

        @Override
        public final Builder filterArn(String filterArn) {
            this.filterArn = filterArn;
            return this;
        }

        public final Map<String, String> getFilterValues() {
            if (filterValues instanceof SdkAutoConstructMap) {
                return null;
            }
            return filterValues;
        }

        public final void setFilterValues(Map<String, String> filterValues) {
            this.filterValues = FilterValuesCopier.copy(filterValues);
        }

        @Override
        public final Builder filterValues(Map<String, String> filterValues) {
            this.filterValues = FilterValuesCopier.copy(filterValues);
            return this;
        }

        public final Map<String, ? extends Collection<String>> getMetadataColumns() {
            if (metadataColumns instanceof SdkAutoConstructMap) {
                return null;
            }
            return metadataColumns;
        }

        public final void setMetadataColumns(Map<String, ? extends Collection<String>> metadataColumns) {
            this.metadataColumns = MetadataColumnsCopier.copy(metadataColumns);
        }

        @Override
        public final Builder metadataColumns(Map<String, ? extends Collection<String>> metadataColumns) {
            this.metadataColumns = MetadataColumnsCopier.copy(metadataColumns);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPersonalizedRankingRequest build() {
            return new GetPersonalizedRankingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
