/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalizeruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPersonalizedRankingRequest extends PersonalizeRuntimeRequest implements
        ToCopyableBuilder<GetPersonalizedRankingRequest.Builder, GetPersonalizedRankingRequest> {
    private static final SdkField<String> CAMPAIGN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetPersonalizedRankingRequest::campaignArn)).setter(setter(Builder::campaignArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("campaignArn").build()).build();

    private static final SdkField<List<String>> INPUT_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetPersonalizedRankingRequest::inputList))
            .setter(setter(Builder::inputList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetPersonalizedRankingRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGN_ARN_FIELD,
            INPUT_LIST_FIELD, USER_ID_FIELD));

    private final String campaignArn;

    private final List<String> inputList;

    private final String userId;

    private GetPersonalizedRankingRequest(BuilderImpl builder) {
        super(builder);
        this.campaignArn = builder.campaignArn;
        this.inputList = builder.inputList;
        this.userId = builder.userId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the campaign to use for generating the personalized ranking.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the campaign to use for generating the personalized ranking.
     */
    public String campaignArn() {
        return campaignArn;
    }

    /**
     * <p>
     * A list of items (itemId's) to rank. If an item was not included in the training dataset, the item is appended to
     * the end of the reranked list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of items (itemId's) to rank. If an item was not included in the training dataset, the item is
     *         appended to the end of the reranked list.
     */
    public List<String> inputList() {
        return inputList;
    }

    /**
     * <p>
     * The user for which you want the campaign to provide a personalized ranking.
     * </p>
     * 
     * @return The user for which you want the campaign to provide a personalized ranking.
     */
    public String userId() {
        return userId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(campaignArn());
        hashCode = 31 * hashCode + Objects.hashCode(inputList());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPersonalizedRankingRequest)) {
            return false;
        }
        GetPersonalizedRankingRequest other = (GetPersonalizedRankingRequest) obj;
        return Objects.equals(campaignArn(), other.campaignArn()) && Objects.equals(inputList(), other.inputList())
                && Objects.equals(userId(), other.userId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetPersonalizedRankingRequest").add("CampaignArn", campaignArn()).add("InputList", inputList())
                .add("UserId", userId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "campaignArn":
            return Optional.ofNullable(clazz.cast(campaignArn()));
        case "inputList":
            return Optional.ofNullable(clazz.cast(inputList()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPersonalizedRankingRequest, T> g) {
        return obj -> g.apply((GetPersonalizedRankingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeRuntimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetPersonalizedRankingRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the campaign to use for generating the personalized ranking.
         * </p>
         * 
         * @param campaignArn
         *        The Amazon Resource Name (ARN) of the campaign to use for generating the personalized ranking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaignArn(String campaignArn);

        /**
         * <p>
         * A list of items (itemId's) to rank. If an item was not included in the training dataset, the item is appended
         * to the end of the reranked list.
         * </p>
         * 
         * @param inputList
         *        A list of items (itemId's) to rank. If an item was not included in the training dataset, the item is
         *        appended to the end of the reranked list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputList(Collection<String> inputList);

        /**
         * <p>
         * A list of items (itemId's) to rank. If an item was not included in the training dataset, the item is appended
         * to the end of the reranked list.
         * </p>
         * 
         * @param inputList
         *        A list of items (itemId's) to rank. If an item was not included in the training dataset, the item is
         *        appended to the end of the reranked list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputList(String... inputList);

        /**
         * <p>
         * The user for which you want the campaign to provide a personalized ranking.
         * </p>
         * 
         * @param userId
         *        The user for which you want the campaign to provide a personalized ranking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PersonalizeRuntimeRequest.BuilderImpl implements Builder {
        private String campaignArn;

        private List<String> inputList = DefaultSdkAutoConstructList.getInstance();

        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPersonalizedRankingRequest model) {
            super(model);
            campaignArn(model.campaignArn);
            inputList(model.inputList);
            userId(model.userId);
        }

        public final String getCampaignArn() {
            return campaignArn;
        }

        @Override
        public final Builder campaignArn(String campaignArn) {
            this.campaignArn = campaignArn;
            return this;
        }

        public final void setCampaignArn(String campaignArn) {
            this.campaignArn = campaignArn;
        }

        public final Collection<String> getInputList() {
            return inputList;
        }

        @Override
        public final Builder inputList(Collection<String> inputList) {
            this.inputList = InputListCopier.copy(inputList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputList(String... inputList) {
            inputList(Arrays.asList(inputList));
            return this;
        }

        public final void setInputList(Collection<String> inputList) {
            this.inputList = InputListCopier.copy(inputList);
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPersonalizedRankingRequest build() {
            return new GetPersonalizedRankingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
