/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.personalizeruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRecommendationsRequest extends PersonalizeRuntimeRequest implements
        ToCopyableBuilder<GetRecommendationsRequest.Builder, GetRecommendationsRequest> {
    private static final SdkField<String> CAMPAIGN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetRecommendationsRequest::campaignArn)).setter(setter(Builder::campaignArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("campaignArn").build()).build();

    private static final SdkField<String> ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetRecommendationsRequest::itemId)).setter(setter(Builder::itemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemId").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetRecommendationsRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()).build();

    private static final SdkField<Integer> NUM_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetRecommendationsRequest::numResults)).setter(setter(Builder::numResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGN_ARN_FIELD,
            ITEM_ID_FIELD, USER_ID_FIELD, NUM_RESULTS_FIELD));

    private final String campaignArn;

    private final String itemId;

    private final String userId;

    private final Integer numResults;

    private GetRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.campaignArn = builder.campaignArn;
        this.itemId = builder.itemId;
        this.userId = builder.userId;
        this.numResults = builder.numResults;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the campaign to use for getting recommendations.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the campaign to use for getting recommendations.
     */
    public String campaignArn() {
        return campaignArn;
    }

    /**
     * <p>
     * The item ID to provide recommendations for.
     * </p>
     * <p>
     * Required for <code>RELATED_ITEMS</code> recipe type.
     * </p>
     * 
     * @return The item ID to provide recommendations for.</p>
     *         <p>
     *         Required for <code>RELATED_ITEMS</code> recipe type.
     */
    public String itemId() {
        return itemId;
    }

    /**
     * <p>
     * The user ID to provide recommendations for.
     * </p>
     * <p>
     * Required for <code>USER_PERSONALIZATION</code> recipe type.
     * </p>
     * 
     * @return The user ID to provide recommendations for.</p>
     *         <p>
     *         Required for <code>USER_PERSONALIZATION</code> recipe type.
     */
    public String userId() {
        return userId;
    }

    /**
     * <p>
     * The number of results to return. The default is 25. The maximum is 100.
     * </p>
     * 
     * @return The number of results to return. The default is 25. The maximum is 100.
     */
    public Integer numResults() {
        return numResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(campaignArn());
        hashCode = 31 * hashCode + Objects.hashCode(itemId());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(numResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecommendationsRequest)) {
            return false;
        }
        GetRecommendationsRequest other = (GetRecommendationsRequest) obj;
        return Objects.equals(campaignArn(), other.campaignArn()) && Objects.equals(itemId(), other.itemId())
                && Objects.equals(userId(), other.userId()) && Objects.equals(numResults(), other.numResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetRecommendationsRequest").add("CampaignArn", campaignArn()).add("ItemId", itemId())
                .add("UserId", userId()).add("NumResults", numResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "campaignArn":
            return Optional.ofNullable(clazz.cast(campaignArn()));
        case "itemId":
            return Optional.ofNullable(clazz.cast(itemId()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "numResults":
            return Optional.ofNullable(clazz.cast(numResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRecommendationsRequest, T> g) {
        return obj -> g.apply((GetRecommendationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PersonalizeRuntimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRecommendationsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the campaign to use for getting recommendations.
         * </p>
         * 
         * @param campaignArn
         *        The Amazon Resource Name (ARN) of the campaign to use for getting recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaignArn(String campaignArn);

        /**
         * <p>
         * The item ID to provide recommendations for.
         * </p>
         * <p>
         * Required for <code>RELATED_ITEMS</code> recipe type.
         * </p>
         * 
         * @param itemId
         *        The item ID to provide recommendations for.</p>
         *        <p>
         *        Required for <code>RELATED_ITEMS</code> recipe type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemId(String itemId);

        /**
         * <p>
         * The user ID to provide recommendations for.
         * </p>
         * <p>
         * Required for <code>USER_PERSONALIZATION</code> recipe type.
         * </p>
         * 
         * @param userId
         *        The user ID to provide recommendations for.</p>
         *        <p>
         *        Required for <code>USER_PERSONALIZATION</code> recipe type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The number of results to return. The default is 25. The maximum is 100.
         * </p>
         * 
         * @param numResults
         *        The number of results to return. The default is 25. The maximum is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numResults(Integer numResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PersonalizeRuntimeRequest.BuilderImpl implements Builder {
        private String campaignArn;

        private String itemId;

        private String userId;

        private Integer numResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecommendationsRequest model) {
            super(model);
            campaignArn(model.campaignArn);
            itemId(model.itemId);
            userId(model.userId);
            numResults(model.numResults);
        }

        public final String getCampaignArn() {
            return campaignArn;
        }

        @Override
        public final Builder campaignArn(String campaignArn) {
            this.campaignArn = campaignArn;
            return this;
        }

        public final void setCampaignArn(String campaignArn) {
            this.campaignArn = campaignArn;
        }

        public final String getItemId() {
            return itemId;
        }

        @Override
        public final Builder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        public final void setItemId(String itemId) {
            this.itemId = itemId;
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final Integer getNumResults() {
            return numResults;
        }

        @Override
        public final Builder numResults(Integer numResults) {
            this.numResults = numResults;
            return this;
        }

        public final void setNumResults(Integer numResults) {
            this.numResults = numResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRecommendationsRequest build() {
            return new GetRecommendationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
