/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pi;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.pi.model.DescribeDimensionKeysRequest;
import software.amazon.awssdk.services.pi.model.DescribeDimensionKeysResponse;
import software.amazon.awssdk.services.pi.model.GetResourceMetricsRequest;
import software.amazon.awssdk.services.pi.model.GetResourceMetricsResponse;

/**
 * Service client for accessing AWS PI asynchronously. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * AWS Performance Insights enables you to monitor and explore different dimensions of database load based on data
 * captured from a running RDS instance. The guide provides detailed information about Performance Insights data types,
 * parameters and errors. For more information about Performance Insights capabilities see <a
 * href="http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon RDS Performance
 * Insights </a> in the <i>Amazon RDS User Guide</i>.
 * </p>
 * <p>
 * The AWS Performance Insights API provides visibility into the performance of your RDS instance, when Performance
 * Insights is enabled for supported engine types. While Amazon CloudWatch provides the authoritative source for AWS
 * service vended monitoring metrics, AWS Performance Insights offers a domain-specific view of database load measured
 * as Average Active Sessions and provided to API consumers as a 2-dimensional time-series dataset. The time dimension
 * of the data provides DB load data for each time point in the queried time range, and each time point decomposes
 * overall load in relation to the requested dimensions, such as SQL, Wait-event, User or Host, measured at that time
 * point.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface PiAsyncClient extends SdkClient {
    String SERVICE_NAME = "pi";

    /**
     * Create a {@link PiAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static PiAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link PiAsyncClient}.
     */
    static PiAsyncClientBuilder builder() {
        return new DefaultPiAsyncClientBuilder();
    }

    /**
     * <p>
     * For a specific time period, retrieve the top <code>N</code> dimension keys for a metric.
     * </p>
     *
     * @param describeDimensionKeysRequest
     * @return A Java Future containing the result of the DescribeDimensionKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.DescribeDimensionKeys
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/DescribeDimensionKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDimensionKeysResponse> describeDimensionKeys(
            DescribeDimensionKeysRequest describeDimensionKeysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For a specific time period, retrieve the top <code>N</code> dimension keys for a metric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDimensionKeysRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDimensionKeysRequest#builder()}
     * </p>
     *
     * @param describeDimensionKeysRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDimensionKeysRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDimensionKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.DescribeDimensionKeys
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/DescribeDimensionKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDimensionKeysResponse> describeDimensionKeys(
            Consumer<DescribeDimensionKeysRequest.Builder> describeDimensionKeysRequest) {
        return describeDimensionKeys(DescribeDimensionKeysRequest.builder().applyMutation(describeDimensionKeysRequest).build());
    }

    /**
     * <p>
     * Retrieve Performance Insights metrics for a set of data sources, over a time period. You can provide specific
     * dimension groups and dimensions, and provide aggregation and filtering criteria for each group.
     * </p>
     *
     * @param getResourceMetricsRequest
     * @return A Java Future containing the result of the GetResourceMetrics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.GetResourceMetrics
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/GetResourceMetrics" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetResourceMetricsResponse> getResourceMetrics(GetResourceMetricsRequest getResourceMetricsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve Performance Insights metrics for a set of data sources, over a time period. You can provide specific
     * dimension groups and dimensions, and provide aggregation and filtering criteria for each group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceMetricsRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourceMetricsRequest#builder()}
     * </p>
     *
     * @param getResourceMetricsRequest
     *        A {@link Consumer} that will call methods on {@link GetResourceMetricsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetResourceMetrics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.GetResourceMetrics
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/GetResourceMetrics" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetResourceMetricsResponse> getResourceMetrics(
            Consumer<GetResourceMetricsRequest.Builder> getResourceMetricsRequest) {
        return getResourceMetrics(GetResourceMetricsRequest.builder().applyMutation(getResourceMetricsRequest).build());
    }
}
