/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pi.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDimensionKeysRequest extends PiRequest implements
        ToCopyableBuilder<DescribeDimensionKeysRequest.Builder, DescribeDimensionKeysRequest> {
    private static final SdkField<String> SERVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceType").getter(getter(DescribeDimensionKeysRequest::serviceTypeAsString))
            .setter(setter(Builder::serviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceType").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(DescribeDimensionKeysRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(DescribeDimensionKeysRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(DescribeDimensionKeysRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> METRIC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Metric")
            .getter(getter(DescribeDimensionKeysRequest::metric)).setter(setter(Builder::metric))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric").build()).build();

    private static final SdkField<Integer> PERIOD_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PeriodInSeconds").getter(getter(DescribeDimensionKeysRequest::periodInSeconds))
            .setter(setter(Builder::periodInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodInSeconds").build()).build();

    private static final SdkField<DimensionGroup> GROUP_BY_FIELD = SdkField.<DimensionGroup> builder(MarshallingType.SDK_POJO)
            .memberName("GroupBy").getter(getter(DescribeDimensionKeysRequest::groupBy)).setter(setter(Builder::groupBy))
            .constructor(DimensionGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupBy").build()).build();

    private static final SdkField<DimensionGroup> PARTITION_BY_FIELD = SdkField
            .<DimensionGroup> builder(MarshallingType.SDK_POJO).memberName("PartitionBy")
            .getter(getter(DescribeDimensionKeysRequest::partitionBy)).setter(setter(Builder::partitionBy))
            .constructor(DimensionGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionBy").build()).build();

    private static final SdkField<Map<String, String>> FILTER_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Filter")
            .getter(getter(DescribeDimensionKeysRequest::filter))
            .setter(setter(Builder::filter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeDimensionKeysRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeDimensionKeysRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_TYPE_FIELD,
            IDENTIFIER_FIELD, START_TIME_FIELD, END_TIME_FIELD, METRIC_FIELD, PERIOD_IN_SECONDS_FIELD, GROUP_BY_FIELD,
            PARTITION_BY_FIELD, FILTER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String serviceType;

    private final String identifier;

    private final Instant startTime;

    private final Instant endTime;

    private final String metric;

    private final Integer periodInSeconds;

    private final DimensionGroup groupBy;

    private final DimensionGroup partitionBy;

    private final Map<String, String> filter;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeDimensionKeysRequest(BuilderImpl builder) {
        super(builder);
        this.serviceType = builder.serviceType;
        this.identifier = builder.identifier;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.metric = builder.metric;
        this.periodInSeconds = builder.periodInSeconds;
        this.groupBy = builder.groupBy;
        this.partitionBy = builder.partitionBy;
        this.filter = builder.filter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The AWS service for which Performance Insights will return metrics. The only valid value for <i>ServiceType</i>
     * is: <code>RDS</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceType} will
     * return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceTypeAsString}.
     * </p>
     * 
     * @return The AWS service for which Performance Insights will return metrics. The only valid value for
     *         <i>ServiceType</i> is: <code>RDS</code>
     * @see ServiceType
     */
    public ServiceType serviceType() {
        return ServiceType.fromValue(serviceType);
    }

    /**
     * <p>
     * The AWS service for which Performance Insights will return metrics. The only valid value for <i>ServiceType</i>
     * is: <code>RDS</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceType} will
     * return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceTypeAsString}.
     * </p>
     * 
     * @return The AWS service for which Performance Insights will return metrics. The only valid value for
     *         <i>ServiceType</i> is: <code>RDS</code>
     * @see ServiceType
     */
    public String serviceTypeAsString() {
        return serviceType;
    }

    /**
     * <p>
     * An immutable, AWS Region-unique identifier for a data source. Performance Insights gathers metrics from this data
     * source.
     * </p>
     * <p>
     * To use an Amazon RDS instance as a data source, you specify its <code>DbiResourceId</code> value - for example:
     * <code>db-FAIHNTYBKTGAUSUZQYPDS2GW4A</code>
     * </p>
     * 
     * @return An immutable, AWS Region-unique identifier for a data source. Performance Insights gathers metrics from
     *         this data source.</p>
     *         <p>
     *         To use an Amazon RDS instance as a data source, you specify its <code>DbiResourceId</code> value - for
     *         example: <code>db-FAIHNTYBKTGAUSUZQYPDS2GW4A</code>
     */
    public String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The date and time specifying the beginning of the requested time series data. You can't specify a
     * <code>StartTime</code> that's earlier than 7 days ago. The value specified is <i>inclusive</i> - data points
     * equal to or greater than <code>StartTime</code> will be returned.
     * </p>
     * <p>
     * The value for <code>StartTime</code> must be earlier than the value for <code>EndTime</code>.
     * </p>
     * 
     * @return The date and time specifying the beginning of the requested time series data. You can't specify a
     *         <code>StartTime</code> that's earlier than 7 days ago. The value specified is <i>inclusive</i> - data
     *         points equal to or greater than <code>StartTime</code> will be returned.</p>
     *         <p>
     *         The value for <code>StartTime</code> must be earlier than the value for <code>EndTime</code>.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The date and time specifying the end of the requested time series data. The value specified is <i>exclusive</i> -
     * data points less than (but not equal to) <code>EndTime</code> will be returned.
     * </p>
     * <p>
     * The value for <code>EndTime</code> must be later than the value for <code>StartTime</code>.
     * </p>
     * 
     * @return The date and time specifying the end of the requested time series data. The value specified is
     *         <i>exclusive</i> - data points less than (but not equal to) <code>EndTime</code> will be returned.</p>
     *         <p>
     *         The value for <code>EndTime</code> must be later than the value for <code>StartTime</code>.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The name of a Performance Insights metric to be measured.
     * </p>
     * <p>
     * Valid values for <code>Metric</code> are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>db.load.avg</code> - a scaled representation of the number of active sessions for the database engine.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sampledload.avg</code> - the raw number of active sessions for the database engine.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of a Performance Insights metric to be measured.</p>
     *         <p>
     *         Valid values for <code>Metric</code> are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>db.load.avg</code> - a scaled representation of the number of active sessions for the database
     *         engine.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.sampledload.avg</code> - the raw number of active sessions for the database engine.
     *         </p>
     *         </li>
     */
    public String metric() {
        return metric;
    }

    /**
     * <p>
     * The granularity, in seconds, of the data points returned from Performance Insights. A period can be as short as
     * one second, or as long as one day (86400 seconds). Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>1</code> (one second)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>60</code> (one minute)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>300</code> (five minutes)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>3600</code> (one hour)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>86400</code> (twenty-four hours)
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you don't specify <code>PeriodInSeconds</code>, then Performance Insights will choose a value for you, with a
     * goal of returning roughly 100-200 data points in the response.
     * </p>
     * 
     * @return The granularity, in seconds, of the data points returned from Performance Insights. A period can be as
     *         short as one second, or as long as one day (86400 seconds). Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>1</code> (one second)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>60</code> (one minute)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>300</code> (five minutes)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>3600</code> (one hour)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>86400</code> (twenty-four hours)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you don't specify <code>PeriodInSeconds</code>, then Performance Insights will choose a value for you,
     *         with a goal of returning roughly 100-200 data points in the response.
     */
    public Integer periodInSeconds() {
        return periodInSeconds;
    }

    /**
     * <p>
     * A specification for how to aggregate the data points from a query result. You must specify a valid dimension
     * group. Performance Insights will return all of the dimensions within that group, unless you provide the names of
     * specific dimensions within that group. You can also request that Performance Insights return a limited number of
     * values for a dimension.
     * </p>
     * 
     * @return A specification for how to aggregate the data points from a query result. You must specify a valid
     *         dimension group. Performance Insights will return all of the dimensions within that group, unless you
     *         provide the names of specific dimensions within that group. You can also request that Performance
     *         Insights return a limited number of values for a dimension.
     */
    public DimensionGroup groupBy() {
        return groupBy;
    }

    /**
     * <p>
     * For each dimension specified in <code>GroupBy</code>, specify a secondary dimension to further subdivide the
     * partition keys in the response.
     * </p>
     * 
     * @return For each dimension specified in <code>GroupBy</code>, specify a secondary dimension to further subdivide
     *         the partition keys in the response.
     */
    public DimensionGroup partitionBy() {
        return partitionBy;
    }

    /**
     * Returns true if the Filter property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilter() {
        return filter != null && !(filter instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * One or more filters to apply in the request. Restrictions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Any number of filters by the same dimension, as specified in the <code>GroupBy</code> or <code>Partition</code>
     * parameters.
     * </p>
     * </li>
     * <li>
     * <p>
     * A single filter for any other dimension in this dimension group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilter()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more filters to apply in the request. Restrictions:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Any number of filters by the same dimension, as specified in the <code>GroupBy</code> or
     *         <code>Partition</code> parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A single filter for any other dimension in this dimension group.
     *         </p>
     *         </li>
     */
    public Map<String, String> filter() {
        return filter;
    }

    /**
     * <p>
     * The maximum number of items to return in the response. If more items exist than the specified
     * <code>MaxRecords</code> value, a pagination token is included in the response so that the remaining results can
     * be retrieved.
     * </p>
     * 
     * @return The maximum number of items to return in the response. If more items exist than the specified
     *         <code>MaxRecords</code> value, a pagination token is included in the response so that the remaining
     *         results can be retrieved.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(metric());
        hashCode = 31 * hashCode + Objects.hashCode(periodInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(groupBy());
        hashCode = 31 * hashCode + Objects.hashCode(partitionBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilter() ? filter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDimensionKeysRequest)) {
            return false;
        }
        DescribeDimensionKeysRequest other = (DescribeDimensionKeysRequest) obj;
        return Objects.equals(serviceTypeAsString(), other.serviceTypeAsString())
                && Objects.equals(identifier(), other.identifier()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(metric(), other.metric())
                && Objects.equals(periodInSeconds(), other.periodInSeconds()) && Objects.equals(groupBy(), other.groupBy())
                && Objects.equals(partitionBy(), other.partitionBy()) && hasFilter() == other.hasFilter()
                && Objects.equals(filter(), other.filter()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeDimensionKeysRequest").add("ServiceType", serviceTypeAsString())
                .add("Identifier", identifier()).add("StartTime", startTime()).add("EndTime", endTime()).add("Metric", metric())
                .add("PeriodInSeconds", periodInSeconds()).add("GroupBy", groupBy()).add("PartitionBy", partitionBy())
                .add("Filter", hasFilter() ? filter() : null).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceType":
            return Optional.ofNullable(clazz.cast(serviceTypeAsString()));
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Metric":
            return Optional.ofNullable(clazz.cast(metric()));
        case "PeriodInSeconds":
            return Optional.ofNullable(clazz.cast(periodInSeconds()));
        case "GroupBy":
            return Optional.ofNullable(clazz.cast(groupBy()));
        case "PartitionBy":
            return Optional.ofNullable(clazz.cast(partitionBy()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDimensionKeysRequest, T> g) {
        return obj -> g.apply((DescribeDimensionKeysRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PiRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDimensionKeysRequest> {
        /**
         * <p>
         * The AWS service for which Performance Insights will return metrics. The only valid value for
         * <i>ServiceType</i> is: <code>RDS</code>
         * </p>
         * 
         * @param serviceType
         *        The AWS service for which Performance Insights will return metrics. The only valid value for
         *        <i>ServiceType</i> is: <code>RDS</code>
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder serviceType(String serviceType);

        /**
         * <p>
         * The AWS service for which Performance Insights will return metrics. The only valid value for
         * <i>ServiceType</i> is: <code>RDS</code>
         * </p>
         * 
         * @param serviceType
         *        The AWS service for which Performance Insights will return metrics. The only valid value for
         *        <i>ServiceType</i> is: <code>RDS</code>
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder serviceType(ServiceType serviceType);

        /**
         * <p>
         * An immutable, AWS Region-unique identifier for a data source. Performance Insights gathers metrics from this
         * data source.
         * </p>
         * <p>
         * To use an Amazon RDS instance as a data source, you specify its <code>DbiResourceId</code> value - for
         * example: <code>db-FAIHNTYBKTGAUSUZQYPDS2GW4A</code>
         * </p>
         * 
         * @param identifier
         *        An immutable, AWS Region-unique identifier for a data source. Performance Insights gathers metrics
         *        from this data source.</p>
         *        <p>
         *        To use an Amazon RDS instance as a data source, you specify its <code>DbiResourceId</code> value - for
         *        example: <code>db-FAIHNTYBKTGAUSUZQYPDS2GW4A</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The date and time specifying the beginning of the requested time series data. You can't specify a
         * <code>StartTime</code> that's earlier than 7 days ago. The value specified is <i>inclusive</i> - data points
         * equal to or greater than <code>StartTime</code> will be returned.
         * </p>
         * <p>
         * The value for <code>StartTime</code> must be earlier than the value for <code>EndTime</code>.
         * </p>
         * 
         * @param startTime
         *        The date and time specifying the beginning of the requested time series data. You can't specify a
         *        <code>StartTime</code> that's earlier than 7 days ago. The value specified is <i>inclusive</i> - data
         *        points equal to or greater than <code>StartTime</code> will be returned.</p>
         *        <p>
         *        The value for <code>StartTime</code> must be earlier than the value for <code>EndTime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The date and time specifying the end of the requested time series data. The value specified is
         * <i>exclusive</i> - data points less than (but not equal to) <code>EndTime</code> will be returned.
         * </p>
         * <p>
         * The value for <code>EndTime</code> must be later than the value for <code>StartTime</code>.
         * </p>
         * 
         * @param endTime
         *        The date and time specifying the end of the requested time series data. The value specified is
         *        <i>exclusive</i> - data points less than (but not equal to) <code>EndTime</code> will be returned.</p>
         *        <p>
         *        The value for <code>EndTime</code> must be later than the value for <code>StartTime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The name of a Performance Insights metric to be measured.
         * </p>
         * <p>
         * Valid values for <code>Metric</code> are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>db.load.avg</code> - a scaled representation of the number of active sessions for the database engine.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>db.sampledload.avg</code> - the raw number of active sessions for the database engine.
         * </p>
         * </li>
         * </ul>
         * 
         * @param metric
         *        The name of a Performance Insights metric to be measured.</p>
         *        <p>
         *        Valid values for <code>Metric</code> are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>db.load.avg</code> - a scaled representation of the number of active sessions for the database
         *        engine.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>db.sampledload.avg</code> - the raw number of active sessions for the database engine.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metric(String metric);

        /**
         * <p>
         * The granularity, in seconds, of the data points returned from Performance Insights. A period can be as short
         * as one second, or as long as one day (86400 seconds). Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>1</code> (one second)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>60</code> (one minute)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>300</code> (five minutes)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>3600</code> (one hour)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>86400</code> (twenty-four hours)
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you don't specify <code>PeriodInSeconds</code>, then Performance Insights will choose a value for you,
         * with a goal of returning roughly 100-200 data points in the response.
         * </p>
         * 
         * @param periodInSeconds
         *        The granularity, in seconds, of the data points returned from Performance Insights. A period can be as
         *        short as one second, or as long as one day (86400 seconds). Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>1</code> (one second)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>60</code> (one minute)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>300</code> (five minutes)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>3600</code> (one hour)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>86400</code> (twenty-four hours)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you don't specify <code>PeriodInSeconds</code>, then Performance Insights will choose a value for
         *        you, with a goal of returning roughly 100-200 data points in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodInSeconds(Integer periodInSeconds);

        /**
         * <p>
         * A specification for how to aggregate the data points from a query result. You must specify a valid dimension
         * group. Performance Insights will return all of the dimensions within that group, unless you provide the names
         * of specific dimensions within that group. You can also request that Performance Insights return a limited
         * number of values for a dimension.
         * </p>
         * 
         * @param groupBy
         *        A specification for how to aggregate the data points from a query result. You must specify a valid
         *        dimension group. Performance Insights will return all of the dimensions within that group, unless you
         *        provide the names of specific dimensions within that group. You can also request that Performance
         *        Insights return a limited number of values for a dimension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupBy(DimensionGroup groupBy);

        /**
         * <p>
         * A specification for how to aggregate the data points from a query result. You must specify a valid dimension
         * group. Performance Insights will return all of the dimensions within that group, unless you provide the names
         * of specific dimensions within that group. You can also request that Performance Insights return a limited
         * number of values for a dimension.
         * </p>
         * This is a convenience that creates an instance of the {@link DimensionGroup.Builder} avoiding the need to
         * create one manually via {@link DimensionGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link DimensionGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #groupBy(DimensionGroup)}.
         * 
         * @param groupBy
         *        a consumer that will call methods on {@link DimensionGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupBy(DimensionGroup)
         */
        default Builder groupBy(Consumer<DimensionGroup.Builder> groupBy) {
            return groupBy(DimensionGroup.builder().applyMutation(groupBy).build());
        }

        /**
         * <p>
         * For each dimension specified in <code>GroupBy</code>, specify a secondary dimension to further subdivide the
         * partition keys in the response.
         * </p>
         * 
         * @param partitionBy
         *        For each dimension specified in <code>GroupBy</code>, specify a secondary dimension to further
         *        subdivide the partition keys in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionBy(DimensionGroup partitionBy);

        /**
         * <p>
         * For each dimension specified in <code>GroupBy</code>, specify a secondary dimension to further subdivide the
         * partition keys in the response.
         * </p>
         * This is a convenience that creates an instance of the {@link DimensionGroup.Builder} avoiding the need to
         * create one manually via {@link DimensionGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link DimensionGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #partitionBy(DimensionGroup)}.
         * 
         * @param partitionBy
         *        a consumer that will call methods on {@link DimensionGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partitionBy(DimensionGroup)
         */
        default Builder partitionBy(Consumer<DimensionGroup.Builder> partitionBy) {
            return partitionBy(DimensionGroup.builder().applyMutation(partitionBy).build());
        }

        /**
         * <p>
         * One or more filters to apply in the request. Restrictions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Any number of filters by the same dimension, as specified in the <code>GroupBy</code> or
         * <code>Partition</code> parameters.
         * </p>
         * </li>
         * <li>
         * <p>
         * A single filter for any other dimension in this dimension group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filter
         *        One or more filters to apply in the request. Restrictions:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Any number of filters by the same dimension, as specified in the <code>GroupBy</code> or
         *        <code>Partition</code> parameters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A single filter for any other dimension in this dimension group.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Map<String, String> filter);

        /**
         * <p>
         * The maximum number of items to return in the response. If more items exist than the specified
         * <code>MaxRecords</code> value, a pagination token is included in the response so that the remaining results
         * can be retrieved.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return in the response. If more items exist than the specified
         *        <code>MaxRecords</code> value, a pagination token is included in the response so that the remaining
         *        results can be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param nextToken
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PiRequest.BuilderImpl implements Builder {
        private String serviceType;

        private String identifier;

        private Instant startTime;

        private Instant endTime;

        private String metric;

        private Integer periodInSeconds;

        private DimensionGroup groupBy;

        private DimensionGroup partitionBy;

        private Map<String, String> filter = DefaultSdkAutoConstructMap.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDimensionKeysRequest model) {
            super(model);
            serviceType(model.serviceType);
            identifier(model.identifier);
            startTime(model.startTime);
            endTime(model.endTime);
            metric(model.metric);
            periodInSeconds(model.periodInSeconds);
            groupBy(model.groupBy);
            partitionBy(model.partitionBy);
            filter(model.filter);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getServiceType() {
            return serviceType;
        }

        @Override
        public final Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @Override
        public final Builder serviceType(ServiceType serviceType) {
            this.serviceType(serviceType == null ? null : serviceType.toString());
            return this;
        }

        public final void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        public final String getIdentifier() {
            return identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getMetric() {
            return metric;
        }

        @Override
        public final Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        public final void setMetric(String metric) {
            this.metric = metric;
        }

        public final Integer getPeriodInSeconds() {
            return periodInSeconds;
        }

        @Override
        public final Builder periodInSeconds(Integer periodInSeconds) {
            this.periodInSeconds = periodInSeconds;
            return this;
        }

        public final void setPeriodInSeconds(Integer periodInSeconds) {
            this.periodInSeconds = periodInSeconds;
        }

        public final DimensionGroup.Builder getGroupBy() {
            return groupBy != null ? groupBy.toBuilder() : null;
        }

        @Override
        public final Builder groupBy(DimensionGroup groupBy) {
            this.groupBy = groupBy;
            return this;
        }

        public final void setGroupBy(DimensionGroup.BuilderImpl groupBy) {
            this.groupBy = groupBy != null ? groupBy.build() : null;
        }

        public final DimensionGroup.Builder getPartitionBy() {
            return partitionBy != null ? partitionBy.toBuilder() : null;
        }

        @Override
        public final Builder partitionBy(DimensionGroup partitionBy) {
            this.partitionBy = partitionBy;
            return this;
        }

        public final void setPartitionBy(DimensionGroup.BuilderImpl partitionBy) {
            this.partitionBy = partitionBy != null ? partitionBy.build() : null;
        }

        public final Map<String, String> getFilter() {
            if (filter instanceof SdkAutoConstructMap) {
                return null;
            }
            return filter;
        }

        @Override
        public final Builder filter(Map<String, String> filter) {
            this.filter = MetricQueryFilterMapCopier.copy(filter);
            return this;
        }

        public final void setFilter(Map<String, String> filter) {
            this.filter = MetricQueryFilterMapCopier.copy(filter);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDimensionKeysRequest build() {
            return new DescribeDimensionKeysRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
