/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A logical grouping of Performance Insights metrics for a related subject area. For example, the <code>db.sql</code>
 * dimension group consists of the following dimensions: <code>db.sql.id</code>, <code>db.sql.db_id</code>,
 * <code>db.sql.statement</code>, and <code>db.sql.tokenized_id</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DimensionGroup implements SdkPojo, Serializable, ToCopyableBuilder<DimensionGroup.Builder, DimensionGroup> {
    private static final SdkField<String> GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Group")
            .getter(getter(DimensionGroup::group)).setter(setter(Builder::group))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").build()).build();

    private static final SdkField<List<String>> DIMENSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Dimensions")
            .getter(getter(DimensionGroup::dimensions))
            .setter(setter(Builder::dimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(DimensionGroup::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_FIELD, DIMENSIONS_FIELD,
            LIMIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String group;

    private final List<String> dimensions;

    private final Integer limit;

    private DimensionGroup(BuilderImpl builder) {
        this.group = builder.group;
        this.dimensions = builder.dimensions;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * The name of the dimension group. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>db.user</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.host</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event_type</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the dimension group. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>db.user</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.host</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.sql</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.sql_tokenized</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.wait_event</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.wait_event_type</code>
     *         </p>
     *         </li>
     */
    public String group() {
        return group;
    }

    /**
     * Returns true if the Dimensions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDimensions() {
        return dimensions != null && !(dimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies that
     * all of the dimensions in the group were requested, or are present in the response.
     * </p>
     * <p>
     * Valid values for elements in the <code>Dimensions</code> array are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * db.user.id
     * </p>
     * </li>
     * <li>
     * <p>
     * db.user.name
     * </p>
     * </li>
     * <li>
     * <p>
     * db.host.id
     * </p>
     * </li>
     * <li>
     * <p>
     * db.host.name
     * </p>
     * </li>
     * <li>
     * <p>
     * db.sql.id
     * </p>
     * </li>
     * <li>
     * <p>
     * db.sql.db_id
     * </p>
     * </li>
     * <li>
     * <p>
     * db.sql.statement
     * </p>
     * </li>
     * <li>
     * <p>
     * db.sql.tokenized_id
     * </p>
     * </li>
     * <li>
     * <p>
     * db.sql_tokenized.id
     * </p>
     * </li>
     * <li>
     * <p>
     * db.sql_tokenized.db_id
     * </p>
     * </li>
     * <li>
     * <p>
     * db.sql_tokenized.statement
     * </p>
     * </li>
     * <li>
     * <p>
     * db.wait_event.name
     * </p>
     * </li>
     * <li>
     * <p>
     * db.wait_event.type
     * </p>
     * </li>
     * <li>
     * <p>
     * db.wait_event_type.name
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDimensions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies
     *         that all of the dimensions in the group were requested, or are present in the response.</p>
     *         <p>
     *         Valid values for elements in the <code>Dimensions</code> array are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         db.user.id
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         db.user.name
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         db.host.id
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         db.host.name
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         db.sql.id
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         db.sql.db_id
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         db.sql.statement
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         db.sql.tokenized_id
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         db.sql_tokenized.id
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         db.sql_tokenized.db_id
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         db.sql_tokenized.statement
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         db.wait_event.name
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         db.wait_event.type
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         db.wait_event_type.name
     *         </p>
     *         </li>
     */
    public List<String> dimensions() {
        return dimensions;
    }

    /**
     * <p>
     * The maximum number of items to fetch for this dimension group.
     * </p>
     * 
     * @return The maximum number of items to fetch for this dimension group.
     */
    public Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(group());
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensions() ? dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DimensionGroup)) {
            return false;
        }
        DimensionGroup other = (DimensionGroup) obj;
        return Objects.equals(group(), other.group()) && hasDimensions() == other.hasDimensions()
                && Objects.equals(dimensions(), other.dimensions()) && Objects.equals(limit(), other.limit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DimensionGroup").add("Group", group()).add("Dimensions", hasDimensions() ? dimensions() : null)
                .add("Limit", limit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Group":
            return Optional.ofNullable(clazz.cast(group()));
        case "Dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DimensionGroup, T> g) {
        return obj -> g.apply((DimensionGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DimensionGroup> {
        /**
         * <p>
         * The name of the dimension group. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>db.user</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>db.host</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>db.sql</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>db.sql_tokenized</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>db.wait_event</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>db.wait_event_type</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param group
         *        The name of the dimension group. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>db.user</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>db.host</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>db.sql</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>db.sql_tokenized</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>db.wait_event</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>db.wait_event_type</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(String group);

        /**
         * <p>
         * A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies
         * that all of the dimensions in the group were requested, or are present in the response.
         * </p>
         * <p>
         * Valid values for elements in the <code>Dimensions</code> array are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * db.user.id
         * </p>
         * </li>
         * <li>
         * <p>
         * db.user.name
         * </p>
         * </li>
         * <li>
         * <p>
         * db.host.id
         * </p>
         * </li>
         * <li>
         * <p>
         * db.host.name
         * </p>
         * </li>
         * <li>
         * <p>
         * db.sql.id
         * </p>
         * </li>
         * <li>
         * <p>
         * db.sql.db_id
         * </p>
         * </li>
         * <li>
         * <p>
         * db.sql.statement
         * </p>
         * </li>
         * <li>
         * <p>
         * db.sql.tokenized_id
         * </p>
         * </li>
         * <li>
         * <p>
         * db.sql_tokenized.id
         * </p>
         * </li>
         * <li>
         * <p>
         * db.sql_tokenized.db_id
         * </p>
         * </li>
         * <li>
         * <p>
         * db.sql_tokenized.statement
         * </p>
         * </li>
         * <li>
         * <p>
         * db.wait_event.name
         * </p>
         * </li>
         * <li>
         * <p>
         * db.wait_event.type
         * </p>
         * </li>
         * <li>
         * <p>
         * db.wait_event_type.name
         * </p>
         * </li>
         * </ul>
         * 
         * @param dimensions
         *        A list of specific dimensions from a dimension group. If this parameter is not present, then it
         *        signifies that all of the dimensions in the group were requested, or are present in the response.</p>
         *        <p>
         *        Valid values for elements in the <code>Dimensions</code> array are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        db.user.id
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        db.user.name
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        db.host.id
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        db.host.name
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        db.sql.id
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        db.sql.db_id
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        db.sql.statement
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        db.sql.tokenized_id
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        db.sql_tokenized.id
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        db.sql_tokenized.db_id
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        db.sql_tokenized.statement
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        db.wait_event.name
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        db.wait_event.type
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        db.wait_event_type.name
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Collection<String> dimensions);

        /**
         * <p>
         * A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies
         * that all of the dimensions in the group were requested, or are present in the response.
         * </p>
         * <p>
         * Valid values for elements in the <code>Dimensions</code> array are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * db.user.id
         * </p>
         * </li>
         * <li>
         * <p>
         * db.user.name
         * </p>
         * </li>
         * <li>
         * <p>
         * db.host.id
         * </p>
         * </li>
         * <li>
         * <p>
         * db.host.name
         * </p>
         * </li>
         * <li>
         * <p>
         * db.sql.id
         * </p>
         * </li>
         * <li>
         * <p>
         * db.sql.db_id
         * </p>
         * </li>
         * <li>
         * <p>
         * db.sql.statement
         * </p>
         * </li>
         * <li>
         * <p>
         * db.sql.tokenized_id
         * </p>
         * </li>
         * <li>
         * <p>
         * db.sql_tokenized.id
         * </p>
         * </li>
         * <li>
         * <p>
         * db.sql_tokenized.db_id
         * </p>
         * </li>
         * <li>
         * <p>
         * db.sql_tokenized.statement
         * </p>
         * </li>
         * <li>
         * <p>
         * db.wait_event.name
         * </p>
         * </li>
         * <li>
         * <p>
         * db.wait_event.type
         * </p>
         * </li>
         * <li>
         * <p>
         * db.wait_event_type.name
         * </p>
         * </li>
         * </ul>
         * 
         * @param dimensions
         *        A list of specific dimensions from a dimension group. If this parameter is not present, then it
         *        signifies that all of the dimensions in the group were requested, or are present in the response.</p>
         *        <p>
         *        Valid values for elements in the <code>Dimensions</code> array are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        db.user.id
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        db.user.name
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        db.host.id
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        db.host.name
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        db.sql.id
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        db.sql.db_id
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        db.sql.statement
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        db.sql.tokenized_id
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        db.sql_tokenized.id
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        db.sql_tokenized.db_id
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        db.sql_tokenized.statement
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        db.wait_event.name
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        db.wait_event.type
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        db.wait_event_type.name
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(String... dimensions);

        /**
         * <p>
         * The maximum number of items to fetch for this dimension group.
         * </p>
         * 
         * @param limit
         *        The maximum number of items to fetch for this dimension group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);
    }

    static final class BuilderImpl implements Builder {
        private String group;

        private List<String> dimensions = DefaultSdkAutoConstructList.getInstance();

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DimensionGroup model) {
            group(model.group);
            dimensions(model.dimensions);
            limit(model.limit);
        }

        public final String getGroup() {
            return group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        public final Collection<String> getDimensions() {
            if (dimensions instanceof SdkAutoConstructList) {
                return null;
            }
            return dimensions;
        }

        @Override
        public final Builder dimensions(Collection<String> dimensions) {
            this.dimensions = StringListCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(String... dimensions) {
            dimensions(Arrays.asList(dimensions));
            return this;
        }

        public final void setDimensions(Collection<String> dimensions) {
            this.dimensions = StringListCopier.copy(dimensions);
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public DimensionGroup build() {
            return new DimensionGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
