/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDimensionKeyDetailsRequest extends PiRequest implements
        ToCopyableBuilder<GetDimensionKeyDetailsRequest.Builder, GetDimensionKeyDetailsRequest> {
    private static final SdkField<String> SERVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceType").getter(getter(GetDimensionKeyDetailsRequest::serviceTypeAsString))
            .setter(setter(Builder::serviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceType").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(GetDimensionKeyDetailsRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<String> GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Group")
            .getter(getter(GetDimensionKeyDetailsRequest::group)).setter(setter(Builder::group))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").build()).build();

    private static final SdkField<String> GROUP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupIdentifier").getter(getter(GetDimensionKeyDetailsRequest::groupIdentifier))
            .setter(setter(Builder::groupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupIdentifier").build()).build();

    private static final SdkField<List<String>> REQUESTED_DIMENSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RequestedDimensions")
            .getter(getter(GetDimensionKeyDetailsRequest::requestedDimensions))
            .setter(setter(Builder::requestedDimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedDimensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_TYPE_FIELD,
            IDENTIFIER_FIELD, GROUP_FIELD, GROUP_IDENTIFIER_FIELD, REQUESTED_DIMENSIONS_FIELD));

    private final String serviceType;

    private final String identifier;

    private final String group;

    private final String groupIdentifier;

    private final List<String> requestedDimensions;

    private GetDimensionKeyDetailsRequest(BuilderImpl builder) {
        super(builder);
        this.serviceType = builder.serviceType;
        this.identifier = builder.identifier;
        this.group = builder.group;
        this.groupIdentifier = builder.groupIdentifier;
        this.requestedDimensions = builder.requestedDimensions;
    }

    /**
     * <p>
     * The AWS service for which Performance Insights returns data. The only valid value is <code>RDS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceType} will
     * return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceTypeAsString}.
     * </p>
     * 
     * @return The AWS service for which Performance Insights returns data. The only valid value is <code>RDS</code>.
     * @see ServiceType
     */
    public final ServiceType serviceType() {
        return ServiceType.fromValue(serviceType);
    }

    /**
     * <p>
     * The AWS service for which Performance Insights returns data. The only valid value is <code>RDS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceType} will
     * return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceTypeAsString}.
     * </p>
     * 
     * @return The AWS service for which Performance Insights returns data. The only valid value is <code>RDS</code>.
     * @see ServiceType
     */
    public final String serviceTypeAsString() {
        return serviceType;
    }

    /**
     * <p>
     * The ID for a data source from which to gather dimension data. This ID must be immutable and unique within an AWS
     * Region. When a DB instance is the data source, specify its <code>DbiResourceId</code> value. For example, specify
     * <code>db-ABCDEFGHIJKLMNOPQRSTU1VW2X</code>.
     * </p>
     * 
     * @return The ID for a data source from which to gather dimension data. This ID must be immutable and unique within
     *         an AWS Region. When a DB instance is the data source, specify its <code>DbiResourceId</code> value. For
     *         example, specify <code>db-ABCDEFGHIJKLMNOPQRSTU1VW2X</code>.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The name of the dimension group. The only valid value is <code>db.sql</code>. Performance Insights searches the
     * specified group for the dimension group ID.
     * </p>
     * 
     * @return The name of the dimension group. The only valid value is <code>db.sql</code>. Performance Insights
     *         searches the specified group for the dimension group ID.
     */
    public final String group() {
        return group;
    }

    /**
     * <p>
     * The ID of the dimension group from which to retrieve dimension details. For dimension group <code>db.sql</code>,
     * the group ID is <code>db.sql.id</code>.
     * </p>
     * 
     * @return The ID of the dimension group from which to retrieve dimension details. For dimension group
     *         <code>db.sql</code>, the group ID is <code>db.sql.id</code>.
     */
    public final String groupIdentifier() {
        return groupIdentifier;
    }

    /**
     * Returns true if the RequestedDimensions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasRequestedDimensions() {
        return requestedDimensions != null && !(requestedDimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of dimensions to retrieve the detail data for within the given dimension group. For the dimension group
     * <code>db.sql</code>, specify either the full dimension name <code>db.sql.statement</code> or the short dimension
     * name <code>statement</code>. If you don't specify this parameter, Performance Insights returns all dimension data
     * within the specified dimension group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRequestedDimensions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of dimensions to retrieve the detail data for within the given dimension group. For the dimension
     *         group <code>db.sql</code>, specify either the full dimension name <code>db.sql.statement</code> or the
     *         short dimension name <code>statement</code>. If you don't specify this parameter, Performance Insights
     *         returns all dimension data within the specified dimension group.
     */
    public final List<String> requestedDimensions() {
        return requestedDimensions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(group());
        hashCode = 31 * hashCode + Objects.hashCode(groupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasRequestedDimensions() ? requestedDimensions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDimensionKeyDetailsRequest)) {
            return false;
        }
        GetDimensionKeyDetailsRequest other = (GetDimensionKeyDetailsRequest) obj;
        return Objects.equals(serviceTypeAsString(), other.serviceTypeAsString())
                && Objects.equals(identifier(), other.identifier()) && Objects.equals(group(), other.group())
                && Objects.equals(groupIdentifier(), other.groupIdentifier())
                && hasRequestedDimensions() == other.hasRequestedDimensions()
                && Objects.equals(requestedDimensions(), other.requestedDimensions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDimensionKeyDetailsRequest").add("ServiceType", serviceTypeAsString())
                .add("Identifier", identifier()).add("Group", group()).add("GroupIdentifier", groupIdentifier())
                .add("RequestedDimensions", hasRequestedDimensions() ? requestedDimensions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceType":
            return Optional.ofNullable(clazz.cast(serviceTypeAsString()));
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "Group":
            return Optional.ofNullable(clazz.cast(group()));
        case "GroupIdentifier":
            return Optional.ofNullable(clazz.cast(groupIdentifier()));
        case "RequestedDimensions":
            return Optional.ofNullable(clazz.cast(requestedDimensions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDimensionKeyDetailsRequest, T> g) {
        return obj -> g.apply((GetDimensionKeyDetailsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PiRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetDimensionKeyDetailsRequest> {
        /**
         * <p>
         * The AWS service for which Performance Insights returns data. The only valid value is <code>RDS</code>.
         * </p>
         * 
         * @param serviceType
         *        The AWS service for which Performance Insights returns data. The only valid value is <code>RDS</code>.
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder serviceType(String serviceType);

        /**
         * <p>
         * The AWS service for which Performance Insights returns data. The only valid value is <code>RDS</code>.
         * </p>
         * 
         * @param serviceType
         *        The AWS service for which Performance Insights returns data. The only valid value is <code>RDS</code>.
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder serviceType(ServiceType serviceType);

        /**
         * <p>
         * The ID for a data source from which to gather dimension data. This ID must be immutable and unique within an
         * AWS Region. When a DB instance is the data source, specify its <code>DbiResourceId</code> value. For example,
         * specify <code>db-ABCDEFGHIJKLMNOPQRSTU1VW2X</code>.
         * </p>
         * 
         * @param identifier
         *        The ID for a data source from which to gather dimension data. This ID must be immutable and unique
         *        within an AWS Region. When a DB instance is the data source, specify its <code>DbiResourceId</code>
         *        value. For example, specify <code>db-ABCDEFGHIJKLMNOPQRSTU1VW2X</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The name of the dimension group. The only valid value is <code>db.sql</code>. Performance Insights searches
         * the specified group for the dimension group ID.
         * </p>
         * 
         * @param group
         *        The name of the dimension group. The only valid value is <code>db.sql</code>. Performance Insights
         *        searches the specified group for the dimension group ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(String group);

        /**
         * <p>
         * The ID of the dimension group from which to retrieve dimension details. For dimension group
         * <code>db.sql</code>, the group ID is <code>db.sql.id</code>.
         * </p>
         * 
         * @param groupIdentifier
         *        The ID of the dimension group from which to retrieve dimension details. For dimension group
         *        <code>db.sql</code>, the group ID is <code>db.sql.id</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupIdentifier(String groupIdentifier);

        /**
         * <p>
         * A list of dimensions to retrieve the detail data for within the given dimension group. For the dimension
         * group <code>db.sql</code>, specify either the full dimension name <code>db.sql.statement</code> or the short
         * dimension name <code>statement</code>. If you don't specify this parameter, Performance Insights returns all
         * dimension data within the specified dimension group.
         * </p>
         * 
         * @param requestedDimensions
         *        A list of dimensions to retrieve the detail data for within the given dimension group. For the
         *        dimension group <code>db.sql</code>, specify either the full dimension name
         *        <code>db.sql.statement</code> or the short dimension name <code>statement</code>. If you don't specify
         *        this parameter, Performance Insights returns all dimension data within the specified dimension group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedDimensions(Collection<String> requestedDimensions);

        /**
         * <p>
         * A list of dimensions to retrieve the detail data for within the given dimension group. For the dimension
         * group <code>db.sql</code>, specify either the full dimension name <code>db.sql.statement</code> or the short
         * dimension name <code>statement</code>. If you don't specify this parameter, Performance Insights returns all
         * dimension data within the specified dimension group.
         * </p>
         * 
         * @param requestedDimensions
         *        A list of dimensions to retrieve the detail data for within the given dimension group. For the
         *        dimension group <code>db.sql</code>, specify either the full dimension name
         *        <code>db.sql.statement</code> or the short dimension name <code>statement</code>. If you don't specify
         *        this parameter, Performance Insights returns all dimension data within the specified dimension group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedDimensions(String... requestedDimensions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PiRequest.BuilderImpl implements Builder {
        private String serviceType;

        private String identifier;

        private String group;

        private String groupIdentifier;

        private List<String> requestedDimensions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDimensionKeyDetailsRequest model) {
            super(model);
            serviceType(model.serviceType);
            identifier(model.identifier);
            group(model.group);
            groupIdentifier(model.groupIdentifier);
            requestedDimensions(model.requestedDimensions);
        }

        public final String getServiceType() {
            return serviceType;
        }

        @Override
        public final Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @Override
        public final Builder serviceType(ServiceType serviceType) {
            this.serviceType(serviceType == null ? null : serviceType.toString());
            return this;
        }

        public final void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        public final String getIdentifier() {
            return identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public final String getGroup() {
            return group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        public final String getGroupIdentifier() {
            return groupIdentifier;
        }

        @Override
        public final Builder groupIdentifier(String groupIdentifier) {
            this.groupIdentifier = groupIdentifier;
            return this;
        }

        public final void setGroupIdentifier(String groupIdentifier) {
            this.groupIdentifier = groupIdentifier;
        }

        public final Collection<String> getRequestedDimensions() {
            if (requestedDimensions instanceof SdkAutoConstructList) {
                return null;
            }
            return requestedDimensions;
        }

        @Override
        public final Builder requestedDimensions(Collection<String> requestedDimensions) {
            this.requestedDimensions = RequestedDimensionListCopier.copy(requestedDimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestedDimensions(String... requestedDimensions) {
            requestedDimensions(Arrays.asList(requestedDimensions));
            return this;
        }

        public final void setRequestedDimensions(Collection<String> requestedDimensions) {
            this.requestedDimensions = RequestedDimensionListCopier.copy(requestedDimensions);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDimensionKeyDetailsRequest build() {
            return new GetDimensionKeyDetailsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
