/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pi.model.DimensionGroupDetail;
import software.amazon.awssdk.services.pi.model.DimensionGroupDetailListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricDimensionGroups
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricDimensionGroups> {
    private static final SdkField<String> METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Metric").getter(MetricDimensionGroups.getter(MetricDimensionGroups::metric)).setter(MetricDimensionGroups.setter(Builder::metric)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric").build()}).build();
    private static final SdkField<List<DimensionGroupDetail>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Groups").getter(MetricDimensionGroups.getter(MetricDimensionGroups::groups)).setter(MetricDimensionGroups.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DimensionGroupDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_FIELD, GROUPS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String metric;
    private final List<DimensionGroupDetail> groups;

    private MetricDimensionGroups(BuilderImpl builder) {
        this.metric = builder.metric;
        this.groups = builder.groups;
    }

    public final String metric() {
        return this.metric;
    }

    public final boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    public final List<DimensionGroupDetail> groups() {
        return this.groups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metric());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroups() ? this.groups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDimensionGroups)) {
            return false;
        }
        MetricDimensionGroups other = (MetricDimensionGroups)obj;
        return Objects.equals(this.metric(), other.metric()) && this.hasGroups() == other.hasGroups() && Objects.equals(this.groups(), other.groups());
    }

    public final String toString() {
        return ToString.builder((String)"MetricDimensionGroups").add("Metric", (Object)this.metric()).add("Groups", this.hasGroups() ? this.groups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Metric": {
                return Optional.ofNullable(clazz.cast(this.metric()));
            }
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricDimensionGroups, T> g) {
        return obj -> g.apply((MetricDimensionGroups)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metric;
        private List<DimensionGroupDetail> groups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDimensionGroups model) {
            this.metric(model.metric);
            this.groups(model.groups);
        }

        public final String getMetric() {
            return this.metric;
        }

        public final void setMetric(String metric) {
            this.metric = metric;
        }

        @Override
        @Transient
        public final Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        public final List<DimensionGroupDetail.Builder> getGroups() {
            List<DimensionGroupDetail.Builder> result = DimensionGroupDetailListCopier.copyToBuilder(this.groups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroups(Collection<DimensionGroupDetail.BuilderImpl> groups) {
            this.groups = DimensionGroupDetailListCopier.copyFromBuilder(groups);
        }

        @Override
        @Transient
        public final Builder groups(Collection<DimensionGroupDetail> groups) {
            this.groups = DimensionGroupDetailListCopier.copy(groups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder groups(DimensionGroupDetail ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder groups(Consumer<DimensionGroupDetail.Builder> ... groups) {
            this.groups(Stream.of(groups).map(c -> (DimensionGroupDetail)((DimensionGroupDetail.Builder)DimensionGroupDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public MetricDimensionGroups build() {
            return new MetricDimensionGroups(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricDimensionGroups> {
        public Builder metric(String var1);

        public Builder groups(Collection<DimensionGroupDetail> var1);

        public Builder groups(DimensionGroupDetail ... var1);

        public Builder groups(Consumer<DimensionGroupDetail.Builder> ... var1);
    }
}

