/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The available dimension information for a metric type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricDimensionGroups implements SdkPojo, Serializable,
        ToCopyableBuilder<MetricDimensionGroups.Builder, MetricDimensionGroups> {
    private static final SdkField<String> METRIC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Metric")
            .getter(getter(MetricDimensionGroups::metric)).setter(setter(Builder::metric))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric").build()).build();

    private static final SdkField<List<DimensionGroupDetail>> GROUPS_FIELD = SdkField
            .<List<DimensionGroupDetail>> builder(MarshallingType.LIST)
            .memberName("Groups")
            .getter(getter(MetricDimensionGroups::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionGroupDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionGroupDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_FIELD, GROUPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String metric;

    private final List<DimensionGroupDetail> groups;

    private MetricDimensionGroups(BuilderImpl builder) {
        this.metric = builder.metric;
        this.groups = builder.groups;
    }

    /**
     * <p>
     * The metric type to which the dimension information belongs.
     * </p>
     * 
     * @return The metric type to which the dimension information belongs.
     */
    public final String metric() {
        return metric;
    }

    /**
     * For responses, this returns true if the service returned a value for the Groups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The available dimension groups for a metric type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroups} method.
     * </p>
     * 
     * @return The available dimension groups for a metric type.
     */
    public final List<DimensionGroupDetail> groups() {
        return groups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metric());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDimensionGroups)) {
            return false;
        }
        MetricDimensionGroups other = (MetricDimensionGroups) obj;
        return Objects.equals(metric(), other.metric()) && hasGroups() == other.hasGroups()
                && Objects.equals(groups(), other.groups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricDimensionGroups").add("Metric", metric()).add("Groups", hasGroups() ? groups() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Metric":
            return Optional.ofNullable(clazz.cast(metric()));
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricDimensionGroups, T> g) {
        return obj -> g.apply((MetricDimensionGroups) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricDimensionGroups> {
        /**
         * <p>
         * The metric type to which the dimension information belongs.
         * </p>
         * 
         * @param metric
         *        The metric type to which the dimension information belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metric(String metric);

        /**
         * <p>
         * The available dimension groups for a metric type.
         * </p>
         * 
         * @param groups
         *        The available dimension groups for a metric type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<DimensionGroupDetail> groups);

        /**
         * <p>
         * The available dimension groups for a metric type.
         * </p>
         * 
         * @param groups
         *        The available dimension groups for a metric type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(DimensionGroupDetail... groups);

        /**
         * <p>
         * The available dimension groups for a metric type.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<DimensionGroupDetail>.Builder}
         * avoiding the need to create one manually via {@link List<DimensionGroupDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DimensionGroupDetail>.Builder#build()} is called immediately
         * and its result is passed to {@link #groups(List<DimensionGroupDetail>)}.
         * 
         * @param groups
         *        a consumer that will call methods on {@link List<DimensionGroupDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groups(List<DimensionGroupDetail>)
         */
        Builder groups(Consumer<DimensionGroupDetail.Builder>... groups);
    }

    static final class BuilderImpl implements Builder {
        private String metric;

        private List<DimensionGroupDetail> groups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDimensionGroups model) {
            metric(model.metric);
            groups(model.groups);
        }

        public final String getMetric() {
            return metric;
        }

        public final void setMetric(String metric) {
            this.metric = metric;
        }

        @Override
        public final Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        public final List<DimensionGroupDetail.Builder> getGroups() {
            List<DimensionGroupDetail.Builder> result = DimensionGroupDetailListCopier.copyToBuilder(this.groups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroups(Collection<DimensionGroupDetail.BuilderImpl> groups) {
            this.groups = DimensionGroupDetailListCopier.copyFromBuilder(groups);
        }

        @Override
        public final Builder groups(Collection<DimensionGroupDetail> groups) {
            this.groups = DimensionGroupDetailListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(DimensionGroupDetail... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<DimensionGroupDetail.Builder>... groups) {
            groups(Stream.of(groups).map(c -> DimensionGroupDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public MetricDimensionGroups build() {
            return new MetricDimensionGroups(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
