/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourceMetadataResponse extends PiResponse implements
        ToCopyableBuilder<GetResourceMetadataResponse.Builder, GetResourceMetadataResponse> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(GetResourceMetadataResponse::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<Map<String, FeatureMetadata>> FEATURES_FIELD = SdkField
            .<Map<String, FeatureMetadata>> builder(MarshallingType.MAP)
            .memberName("Features")
            .getter(getter(GetResourceMetadataResponse::features))
            .setter(setter(Builder::features))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Features").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<FeatureMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(FeatureMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            FEATURES_FIELD));

    private final String identifier;

    private final Map<String, FeatureMetadata> features;

    private GetResourceMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.features = builder.features;
    }

    /**
     * <p>
     * An immutable identifier for a data source that is unique for an Amazon Web Services Region. Performance Insights
     * gathers metrics from this data source. To use a DB instance as a data source, specify its
     * <code>DbiResourceId</code> value. For example, specify <code>db-ABCDEFGHIJKLMNOPQRSTU1VW2X</code>.
     * </p>
     * 
     * @return An immutable identifier for a data source that is unique for an Amazon Web Services Region. Performance
     *         Insights gathers metrics from this data source. To use a DB instance as a data source, specify its
     *         <code>DbiResourceId</code> value. For example, specify <code>db-ABCDEFGHIJKLMNOPQRSTU1VW2X</code>.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the Features property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFeatures() {
        return features != null && !(features instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The metadata for different features. For example, the metadata might indicate that a feature is turned on or off
     * on a specific DB instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatures} method.
     * </p>
     * 
     * @return The metadata for different features. For example, the metadata might indicate that a feature is turned on
     *         or off on a specific DB instance.
     */
    public final Map<String, FeatureMetadata> features() {
        return features;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasFeatures() ? features() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceMetadataResponse)) {
            return false;
        }
        GetResourceMetadataResponse other = (GetResourceMetadataResponse) obj;
        return Objects.equals(identifier(), other.identifier()) && hasFeatures() == other.hasFeatures()
                && Objects.equals(features(), other.features());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourceMetadataResponse").add("Identifier", identifier())
                .add("Features", hasFeatures() ? features() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "Features":
            return Optional.ofNullable(clazz.cast(features()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceMetadataResponse, T> g) {
        return obj -> g.apply((GetResourceMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PiResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetResourceMetadataResponse> {
        /**
         * <p>
         * An immutable identifier for a data source that is unique for an Amazon Web Services Region. Performance
         * Insights gathers metrics from this data source. To use a DB instance as a data source, specify its
         * <code>DbiResourceId</code> value. For example, specify <code>db-ABCDEFGHIJKLMNOPQRSTU1VW2X</code>.
         * </p>
         * 
         * @param identifier
         *        An immutable identifier for a data source that is unique for an Amazon Web Services Region.
         *        Performance Insights gathers metrics from this data source. To use a DB instance as a data source,
         *        specify its <code>DbiResourceId</code> value. For example, specify
         *        <code>db-ABCDEFGHIJKLMNOPQRSTU1VW2X</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The metadata for different features. For example, the metadata might indicate that a feature is turned on or
         * off on a specific DB instance.
         * </p>
         * 
         * @param features
         *        The metadata for different features. For example, the metadata might indicate that a feature is turned
         *        on or off on a specific DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(Map<String, FeatureMetadata> features);
    }

    static final class BuilderImpl extends PiResponse.BuilderImpl implements Builder {
        private String identifier;

        private Map<String, FeatureMetadata> features = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceMetadataResponse model) {
            super(model);
            identifier(model.identifier);
            features(model.features);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final Map<String, FeatureMetadata.Builder> getFeatures() {
            Map<String, FeatureMetadata.Builder> result = FeatureMetadataMapCopier.copyToBuilder(this.features);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFeatures(Map<String, FeatureMetadata.BuilderImpl> features) {
            this.features = FeatureMetadataMapCopier.copyFromBuilder(features);
        }

        @Override
        public final Builder features(Map<String, FeatureMetadata> features) {
            this.features = FeatureMetadataMapCopier.copy(features);
            return this;
        }

        @Override
        public GetResourceMetadataResponse build() {
            return new GetResourceMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
