/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A time-ordered series of data points, corresponding to a dimension of a Performance Insights metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricKeyDataPoints implements SdkPojo, Serializable,
        ToCopyableBuilder<MetricKeyDataPoints.Builder, MetricKeyDataPoints> {
    private static final SdkField<ResponseResourceMetricKey> KEY_FIELD = SdkField
            .<ResponseResourceMetricKey> builder(MarshallingType.SDK_POJO).memberName("Key")
            .getter(getter(MetricKeyDataPoints::key)).setter(setter(Builder::key))
            .constructor(ResponseResourceMetricKey::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<List<DataPoint>> DATA_POINTS_FIELD = SdkField
            .<List<DataPoint>> builder(MarshallingType.LIST)
            .memberName("DataPoints")
            .getter(getter(MetricKeyDataPoints::dataPoints))
            .setter(setter(Builder::dataPoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataPoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataPoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, DATA_POINTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final ResponseResourceMetricKey key;

    private final List<DataPoint> dataPoints;

    private MetricKeyDataPoints(BuilderImpl builder) {
        this.key = builder.key;
        this.dataPoints = builder.dataPoints;
    }

    /**
     * <p>
     * The dimensions to which the data points apply.
     * </p>
     * 
     * @return The dimensions to which the data points apply.
     */
    public final ResponseResourceMetricKey key() {
        return key;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataPoints property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDataPoints() {
        return dataPoints != null && !(dataPoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of timestamp-value pairs, representing measurements over a period of time.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataPoints} method.
     * </p>
     * 
     * @return An array of timestamp-value pairs, representing measurements over a period of time.
     */
    public final List<DataPoint> dataPoints() {
        return dataPoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(hasDataPoints() ? dataPoints() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricKeyDataPoints)) {
            return false;
        }
        MetricKeyDataPoints other = (MetricKeyDataPoints) obj;
        return Objects.equals(key(), other.key()) && hasDataPoints() == other.hasDataPoints()
                && Objects.equals(dataPoints(), other.dataPoints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricKeyDataPoints").add("Key", key()).add("DataPoints", hasDataPoints() ? dataPoints() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "DataPoints":
            return Optional.ofNullable(clazz.cast(dataPoints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricKeyDataPoints, T> g) {
        return obj -> g.apply((MetricKeyDataPoints) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricKeyDataPoints> {
        /**
         * <p>
         * The dimensions to which the data points apply.
         * </p>
         * 
         * @param key
         *        The dimensions to which the data points apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(ResponseResourceMetricKey key);

        /**
         * <p>
         * The dimensions to which the data points apply.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResponseResourceMetricKey.Builder}
         * avoiding the need to create one manually via {@link ResponseResourceMetricKey#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResponseResourceMetricKey.Builder#build()} is called immediately
         * and its result is passed to {@link #key(ResponseResourceMetricKey)}.
         * 
         * @param key
         *        a consumer that will call methods on {@link ResponseResourceMetricKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #key(ResponseResourceMetricKey)
         */
        default Builder key(Consumer<ResponseResourceMetricKey.Builder> key) {
            return key(ResponseResourceMetricKey.builder().applyMutation(key).build());
        }

        /**
         * <p>
         * An array of timestamp-value pairs, representing measurements over a period of time.
         * </p>
         * 
         * @param dataPoints
         *        An array of timestamp-value pairs, representing measurements over a period of time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPoints(Collection<DataPoint> dataPoints);

        /**
         * <p>
         * An array of timestamp-value pairs, representing measurements over a period of time.
         * </p>
         * 
         * @param dataPoints
         *        An array of timestamp-value pairs, representing measurements over a period of time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPoints(DataPoint... dataPoints);

        /**
         * <p>
         * An array of timestamp-value pairs, representing measurements over a period of time.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<DataPoint>.Builder} avoiding the
         * need to create one manually via {@link List<DataPoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DataPoint>.Builder#build()} is called immediately and its
         * result is passed to {@link #dataPoints(List<DataPoint>)}.
         * 
         * @param dataPoints
         *        a consumer that will call methods on {@link List<DataPoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataPoints(List<DataPoint>)
         */
        Builder dataPoints(Consumer<DataPoint.Builder>... dataPoints);
    }

    static final class BuilderImpl implements Builder {
        private ResponseResourceMetricKey key;

        private List<DataPoint> dataPoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricKeyDataPoints model) {
            key(model.key);
            dataPoints(model.dataPoints);
        }

        public final ResponseResourceMetricKey.Builder getKey() {
            return key != null ? key.toBuilder() : null;
        }

        public final void setKey(ResponseResourceMetricKey.BuilderImpl key) {
            this.key = key != null ? key.build() : null;
        }

        @Override
        public final Builder key(ResponseResourceMetricKey key) {
            this.key = key;
            return this;
        }

        public final List<DataPoint.Builder> getDataPoints() {
            List<DataPoint.Builder> result = DataPointsListCopier.copyToBuilder(this.dataPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataPoints(Collection<DataPoint.BuilderImpl> dataPoints) {
            this.dataPoints = DataPointsListCopier.copyFromBuilder(dataPoints);
        }

        @Override
        public final Builder dataPoints(Collection<DataPoint> dataPoints) {
            this.dataPoints = DataPointsListCopier.copy(dataPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataPoints(DataPoint... dataPoints) {
            dataPoints(Arrays.asList(dataPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataPoints(Consumer<DataPoint.Builder>... dataPoints) {
            dataPoints(Stream.of(dataPoints).map(c -> DataPoint.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public MetricKeyDataPoints build() {
            return new MetricKeyDataPoints(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
