/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDimensionKeyDetailsResponse extends PiResponse implements
        ToCopyableBuilder<GetDimensionKeyDetailsResponse.Builder, GetDimensionKeyDetailsResponse> {
    private static final SdkField<List<DimensionKeyDetail>> DIMENSIONS_FIELD = SdkField
            .<List<DimensionKeyDetail>> builder(MarshallingType.LIST)
            .memberName("Dimensions")
            .getter(getter(GetDimensionKeyDetailsResponse::dimensions))
            .setter(setter(Builder::dimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionKeyDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionKeyDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD));

    private final List<DimensionKeyDetail> dimensions;

    private GetDimensionKeyDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.dimensions = builder.dimensions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Dimensions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDimensions() {
        return dimensions != null && !(dimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details for the requested dimensions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensions} method.
     * </p>
     * 
     * @return The details for the requested dimensions.
     */
    public final List<DimensionKeyDetail> dimensions() {
        return dimensions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensions() ? dimensions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDimensionKeyDetailsResponse)) {
            return false;
        }
        GetDimensionKeyDetailsResponse other = (GetDimensionKeyDetailsResponse) obj;
        return hasDimensions() == other.hasDimensions() && Objects.equals(dimensions(), other.dimensions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDimensionKeyDetailsResponse").add("Dimensions", hasDimensions() ? dimensions() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDimensionKeyDetailsResponse, T> g) {
        return obj -> g.apply((GetDimensionKeyDetailsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PiResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDimensionKeyDetailsResponse> {
        /**
         * <p>
         * The details for the requested dimensions.
         * </p>
         * 
         * @param dimensions
         *        The details for the requested dimensions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Collection<DimensionKeyDetail> dimensions);

        /**
         * <p>
         * The details for the requested dimensions.
         * </p>
         * 
         * @param dimensions
         *        The details for the requested dimensions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(DimensionKeyDetail... dimensions);

        /**
         * <p>
         * The details for the requested dimensions.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<DimensionKeyDetail>.Builder}
         * avoiding the need to create one manually via {@link List<DimensionKeyDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DimensionKeyDetail>.Builder#build()} is called immediately
         * and its result is passed to {@link #dimensions(List<DimensionKeyDetail>)}.
         * 
         * @param dimensions
         *        a consumer that will call methods on {@link List<DimensionKeyDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensions(List<DimensionKeyDetail>)
         */
        Builder dimensions(Consumer<DimensionKeyDetail.Builder>... dimensions);
    }

    static final class BuilderImpl extends PiResponse.BuilderImpl implements Builder {
        private List<DimensionKeyDetail> dimensions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDimensionKeyDetailsResponse model) {
            super(model);
            dimensions(model.dimensions);
        }

        public final List<DimensionKeyDetail.Builder> getDimensions() {
            List<DimensionKeyDetail.Builder> result = DimensionKeyDetailListCopier.copyToBuilder(this.dimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensions(Collection<DimensionKeyDetail.BuilderImpl> dimensions) {
            this.dimensions = DimensionKeyDetailListCopier.copyFromBuilder(dimensions);
        }

        @Override
        public final Builder dimensions(Collection<DimensionKeyDetail> dimensions) {
            this.dimensions = DimensionKeyDetailListCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(DimensionKeyDetail... dimensions) {
            dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<DimensionKeyDetail.Builder>... dimensions) {
            dimensions(Stream.of(dimensions).map(c -> DimensionKeyDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetDimensionKeyDetailsResponse build() {
            return new GetDimensionKeyDetailsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
