/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pi.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that describes the details for a specified dimension.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DimensionKeyDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<DimensionKeyDetail.Builder, DimensionKeyDetail> {
    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(DimensionKeyDetail::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> DIMENSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Dimension").getter(getter(DimensionKeyDetail::dimension)).setter(setter(Builder::dimension))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimension").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DimensionKeyDetail::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, DIMENSION_FIELD,
            STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String value;

    private final String dimension;

    private final String status;

    private DimensionKeyDetail(BuilderImpl builder) {
        this.value = builder.value;
        this.dimension = builder.dimension;
        this.status = builder.status;
    }

    /**
     * <p>
     * The value of the dimension detail data. For the <code>db.sql.statement</code> dimension, this value is either the
     * full or truncated SQL query, depending on the return status.
     * </p>
     * 
     * @return The value of the dimension detail data. For the <code>db.sql.statement</code> dimension, this value is
     *         either the full or truncated SQL query, depending on the return status.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * The full name of the dimension. The full name includes the group name and key name. The only valid value is
     * <code>db.sql.statement</code>.
     * </p>
     * 
     * @return The full name of the dimension. The full name includes the group name and key name. The only valid value
     *         is <code>db.sql.statement</code>.
     */
    public final String dimension() {
        return dimension;
    }

    /**
     * <p>
     * The status of the dimension detail data. Possible values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AVAILABLE</code> - The dimension detail data is ready to be retrieved.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PROCESSING</code> - The dimension detail data isn't ready to be retrieved because more processing time is
     * required. If the requested detail data for <code>db.sql.statement</code> has the status <code>PROCESSING</code>,
     * Performance Insights returns the truncated query.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNAVAILABLE</code> - The dimension detail data could not be collected successfully.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DetailStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the dimension detail data. Possible values include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AVAILABLE</code> - The dimension detail data is ready to be retrieved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PROCESSING</code> - The dimension detail data isn't ready to be retrieved because more processing
     *         time is required. If the requested detail data for <code>db.sql.statement</code> has the status
     *         <code>PROCESSING</code>, Performance Insights returns the truncated query.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNAVAILABLE</code> - The dimension detail data could not be collected successfully.
     *         </p>
     *         </li>
     * @see DetailStatus
     */
    public final DetailStatus status() {
        return DetailStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the dimension detail data. Possible values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AVAILABLE</code> - The dimension detail data is ready to be retrieved.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PROCESSING</code> - The dimension detail data isn't ready to be retrieved because more processing time is
     * required. If the requested detail data for <code>db.sql.statement</code> has the status <code>PROCESSING</code>,
     * Performance Insights returns the truncated query.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNAVAILABLE</code> - The dimension detail data could not be collected successfully.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DetailStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the dimension detail data. Possible values include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AVAILABLE</code> - The dimension detail data is ready to be retrieved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PROCESSING</code> - The dimension detail data isn't ready to be retrieved because more processing
     *         time is required. If the requested detail data for <code>db.sql.statement</code> has the status
     *         <code>PROCESSING</code>, Performance Insights returns the truncated query.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNAVAILABLE</code> - The dimension detail data could not be collected successfully.
     *         </p>
     *         </li>
     * @see DetailStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(dimension());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DimensionKeyDetail)) {
            return false;
        }
        DimensionKeyDetail other = (DimensionKeyDetail) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(dimension(), other.dimension())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DimensionKeyDetail").add("Value", value()).add("Dimension", dimension())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Dimension":
            return Optional.ofNullable(clazz.cast(dimension()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DimensionKeyDetail, T> g) {
        return obj -> g.apply((DimensionKeyDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DimensionKeyDetail> {
        /**
         * <p>
         * The value of the dimension detail data. For the <code>db.sql.statement</code> dimension, this value is either
         * the full or truncated SQL query, depending on the return status.
         * </p>
         * 
         * @param value
         *        The value of the dimension detail data. For the <code>db.sql.statement</code> dimension, this value is
         *        either the full or truncated SQL query, depending on the return status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The full name of the dimension. The full name includes the group name and key name. The only valid value is
         * <code>db.sql.statement</code>.
         * </p>
         * 
         * @param dimension
         *        The full name of the dimension. The full name includes the group name and key name. The only valid
         *        value is <code>db.sql.statement</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimension(String dimension);

        /**
         * <p>
         * The status of the dimension detail data. Possible values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AVAILABLE</code> - The dimension detail data is ready to be retrieved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PROCESSING</code> - The dimension detail data isn't ready to be retrieved because more processing time
         * is required. If the requested detail data for <code>db.sql.statement</code> has the status
         * <code>PROCESSING</code>, Performance Insights returns the truncated query.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNAVAILABLE</code> - The dimension detail data could not be collected successfully.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the dimension detail data. Possible values include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AVAILABLE</code> - The dimension detail data is ready to be retrieved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PROCESSING</code> - The dimension detail data isn't ready to be retrieved because more
         *        processing time is required. If the requested detail data for <code>db.sql.statement</code> has the
         *        status <code>PROCESSING</code>, Performance Insights returns the truncated query.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNAVAILABLE</code> - The dimension detail data could not be collected successfully.
         *        </p>
         *        </li>
         * @see DetailStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetailStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the dimension detail data. Possible values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AVAILABLE</code> - The dimension detail data is ready to be retrieved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PROCESSING</code> - The dimension detail data isn't ready to be retrieved because more processing time
         * is required. If the requested detail data for <code>db.sql.statement</code> has the status
         * <code>PROCESSING</code>, Performance Insights returns the truncated query.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNAVAILABLE</code> - The dimension detail data could not be collected successfully.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the dimension detail data. Possible values include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AVAILABLE</code> - The dimension detail data is ready to be retrieved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PROCESSING</code> - The dimension detail data isn't ready to be retrieved because more
         *        processing time is required. If the requested detail data for <code>db.sql.statement</code> has the
         *        status <code>PROCESSING</code>, Performance Insights returns the truncated query.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNAVAILABLE</code> - The dimension detail data could not be collected successfully.
         *        </p>
         *        </li>
         * @see DetailStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetailStatus
         */
        Builder status(DetailStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String value;

        private String dimension;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DimensionKeyDetail model) {
            value(model.value);
            dimension(model.dimension);
            status(model.status);
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        @Transient
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getDimension() {
            return dimension;
        }

        public final void setDimension(String dimension) {
            this.dimension = dimension;
        }

        @Override
        @Transient
        public final Builder dimension(String dimension) {
            this.dimension = dimension;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(DetailStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public DimensionKeyDetail build() {
            return new DimensionKeyDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
