/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pi.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDimensionKeysResponse extends PiResponse implements
        ToCopyableBuilder<DescribeDimensionKeysResponse.Builder, DescribeDimensionKeysResponse> {
    private static final SdkField<Instant> ALIGNED_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("AlignedStartTime").getter(getter(DescribeDimensionKeysResponse::alignedStartTime))
            .setter(setter(Builder::alignedStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlignedStartTime").build()).build();

    private static final SdkField<Instant> ALIGNED_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("AlignedEndTime").getter(getter(DescribeDimensionKeysResponse::alignedEndTime))
            .setter(setter(Builder::alignedEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlignedEndTime").build()).build();

    private static final SdkField<List<ResponsePartitionKey>> PARTITION_KEYS_FIELD = SdkField
            .<List<ResponsePartitionKey>> builder(MarshallingType.LIST)
            .memberName("PartitionKeys")
            .getter(getter(DescribeDimensionKeysResponse::partitionKeys))
            .setter(setter(Builder::partitionKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResponsePartitionKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResponsePartitionKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DimensionKeyDescription>> KEYS_FIELD = SdkField
            .<List<DimensionKeyDescription>> builder(MarshallingType.LIST)
            .memberName("Keys")
            .getter(getter(DescribeDimensionKeysResponse::keys))
            .setter(setter(Builder::keys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionKeyDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionKeyDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeDimensionKeysResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIGNED_START_TIME_FIELD,
            ALIGNED_END_TIME_FIELD, PARTITION_KEYS_FIELD, KEYS_FIELD, NEXT_TOKEN_FIELD));

    private final Instant alignedStartTime;

    private final Instant alignedEndTime;

    private final List<ResponsePartitionKey> partitionKeys;

    private final List<DimensionKeyDescription> keys;

    private final String nextToken;

    private DescribeDimensionKeysResponse(BuilderImpl builder) {
        super(builder);
        this.alignedStartTime = builder.alignedStartTime;
        this.alignedEndTime = builder.alignedEndTime;
        this.partitionKeys = builder.partitionKeys;
        this.keys = builder.keys;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The start time for the returned dimension keys, after alignment to a granular boundary (as specified by
     * <code>PeriodInSeconds</code>). <code>AlignedStartTime</code> will be less than or equal to the value of the
     * user-specified <code>StartTime</code>.
     * </p>
     * 
     * @return The start time for the returned dimension keys, after alignment to a granular boundary (as specified by
     *         <code>PeriodInSeconds</code>). <code>AlignedStartTime</code> will be less than or equal to the value of
     *         the user-specified <code>StartTime</code>.
     */
    public final Instant alignedStartTime() {
        return alignedStartTime;
    }

    /**
     * <p>
     * The end time for the returned dimension keys, after alignment to a granular boundary (as specified by
     * <code>PeriodInSeconds</code>). <code>AlignedEndTime</code> will be greater than or equal to the value of the
     * user-specified <code>Endtime</code>.
     * </p>
     * 
     * @return The end time for the returned dimension keys, after alignment to a granular boundary (as specified by
     *         <code>PeriodInSeconds</code>). <code>AlignedEndTime</code> will be greater than or equal to the value of
     *         the user-specified <code>Endtime</code>.
     */
    public final Instant alignedEndTime() {
        return alignedEndTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the PartitionKeys property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPartitionKeys() {
        return partitionKeys != null && !(partitionKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If <code>PartitionBy</code> was present in the request, <code>PartitionKeys</code> contains the breakdown of
     * dimension keys by the specified partitions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPartitionKeys} method.
     * </p>
     * 
     * @return If <code>PartitionBy</code> was present in the request, <code>PartitionKeys</code> contains the breakdown
     *         of dimension keys by the specified partitions.
     */
    public final List<ResponsePartitionKey> partitionKeys() {
        return partitionKeys;
    }

    /**
     * For responses, this returns true if the service returned a value for the Keys property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasKeys() {
        return keys != null && !(keys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The dimension keys that were requested.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeys} method.
     * </p>
     * 
     * @return The dimension keys that were requested.
     */
    public final List<DimensionKeyDescription> keys() {
        return keys;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(alignedStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(alignedEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasPartitionKeys() ? partitionKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasKeys() ? keys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDimensionKeysResponse)) {
            return false;
        }
        DescribeDimensionKeysResponse other = (DescribeDimensionKeysResponse) obj;
        return Objects.equals(alignedStartTime(), other.alignedStartTime())
                && Objects.equals(alignedEndTime(), other.alignedEndTime()) && hasPartitionKeys() == other.hasPartitionKeys()
                && Objects.equals(partitionKeys(), other.partitionKeys()) && hasKeys() == other.hasKeys()
                && Objects.equals(keys(), other.keys()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDimensionKeysResponse").add("AlignedStartTime", alignedStartTime())
                .add("AlignedEndTime", alignedEndTime()).add("PartitionKeys", hasPartitionKeys() ? partitionKeys() : null)
                .add("Keys", hasKeys() ? keys() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlignedStartTime":
            return Optional.ofNullable(clazz.cast(alignedStartTime()));
        case "AlignedEndTime":
            return Optional.ofNullable(clazz.cast(alignedEndTime()));
        case "PartitionKeys":
            return Optional.ofNullable(clazz.cast(partitionKeys()));
        case "Keys":
            return Optional.ofNullable(clazz.cast(keys()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDimensionKeysResponse, T> g) {
        return obj -> g.apply((DescribeDimensionKeysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PiResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDimensionKeysResponse> {
        /**
         * <p>
         * The start time for the returned dimension keys, after alignment to a granular boundary (as specified by
         * <code>PeriodInSeconds</code>). <code>AlignedStartTime</code> will be less than or equal to the value of the
         * user-specified <code>StartTime</code>.
         * </p>
         * 
         * @param alignedStartTime
         *        The start time for the returned dimension keys, after alignment to a granular boundary (as specified
         *        by <code>PeriodInSeconds</code>). <code>AlignedStartTime</code> will be less than or equal to the
         *        value of the user-specified <code>StartTime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alignedStartTime(Instant alignedStartTime);

        /**
         * <p>
         * The end time for the returned dimension keys, after alignment to a granular boundary (as specified by
         * <code>PeriodInSeconds</code>). <code>AlignedEndTime</code> will be greater than or equal to the value of the
         * user-specified <code>Endtime</code>.
         * </p>
         * 
         * @param alignedEndTime
         *        The end time for the returned dimension keys, after alignment to a granular boundary (as specified by
         *        <code>PeriodInSeconds</code>). <code>AlignedEndTime</code> will be greater than or equal to the value
         *        of the user-specified <code>Endtime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alignedEndTime(Instant alignedEndTime);

        /**
         * <p>
         * If <code>PartitionBy</code> was present in the request, <code>PartitionKeys</code> contains the breakdown of
         * dimension keys by the specified partitions.
         * </p>
         * 
         * @param partitionKeys
         *        If <code>PartitionBy</code> was present in the request, <code>PartitionKeys</code> contains the
         *        breakdown of dimension keys by the specified partitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionKeys(Collection<ResponsePartitionKey> partitionKeys);

        /**
         * <p>
         * If <code>PartitionBy</code> was present in the request, <code>PartitionKeys</code> contains the breakdown of
         * dimension keys by the specified partitions.
         * </p>
         * 
         * @param partitionKeys
         *        If <code>PartitionBy</code> was present in the request, <code>PartitionKeys</code> contains the
         *        breakdown of dimension keys by the specified partitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionKeys(ResponsePartitionKey... partitionKeys);

        /**
         * <p>
         * If <code>PartitionBy</code> was present in the request, <code>PartitionKeys</code> contains the breakdown of
         * dimension keys by the specified partitions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResponsePartitionKey>.Builder} avoiding the
         * need to create one manually via {@link List<ResponsePartitionKey>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResponsePartitionKey>.Builder#build()} is called immediately
         * and its result is passed to {@link #partitionKeys(List<ResponsePartitionKey>)}.
         * 
         * @param partitionKeys
         *        a consumer that will call methods on {@link List<ResponsePartitionKey>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partitionKeys(List<ResponsePartitionKey>)
         */
        Builder partitionKeys(Consumer<ResponsePartitionKey.Builder>... partitionKeys);

        /**
         * <p>
         * The dimension keys that were requested.
         * </p>
         * 
         * @param keys
         *        The dimension keys that were requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keys(Collection<DimensionKeyDescription> keys);

        /**
         * <p>
         * The dimension keys that were requested.
         * </p>
         * 
         * @param keys
         *        The dimension keys that were requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keys(DimensionKeyDescription... keys);

        /**
         * <p>
         * The dimension keys that were requested.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DimensionKeyDescription>.Builder} avoiding
         * the need to create one manually via {@link List<DimensionKeyDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DimensionKeyDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link #keys(List<DimensionKeyDescription>)}.
         * 
         * @param keys
         *        a consumer that will call methods on {@link List<DimensionKeyDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keys(List<DimensionKeyDescription>)
         */
        Builder keys(Consumer<DimensionKeyDescription.Builder>... keys);

        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param nextToken
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PiResponse.BuilderImpl implements Builder {
        private Instant alignedStartTime;

        private Instant alignedEndTime;

        private List<ResponsePartitionKey> partitionKeys = DefaultSdkAutoConstructList.getInstance();

        private List<DimensionKeyDescription> keys = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDimensionKeysResponse model) {
            super(model);
            alignedStartTime(model.alignedStartTime);
            alignedEndTime(model.alignedEndTime);
            partitionKeys(model.partitionKeys);
            keys(model.keys);
            nextToken(model.nextToken);
        }

        public final Instant getAlignedStartTime() {
            return alignedStartTime;
        }

        public final void setAlignedStartTime(Instant alignedStartTime) {
            this.alignedStartTime = alignedStartTime;
        }

        @Override
        @Transient
        public final Builder alignedStartTime(Instant alignedStartTime) {
            this.alignedStartTime = alignedStartTime;
            return this;
        }

        public final Instant getAlignedEndTime() {
            return alignedEndTime;
        }

        public final void setAlignedEndTime(Instant alignedEndTime) {
            this.alignedEndTime = alignedEndTime;
        }

        @Override
        @Transient
        public final Builder alignedEndTime(Instant alignedEndTime) {
            this.alignedEndTime = alignedEndTime;
            return this;
        }

        public final List<ResponsePartitionKey.Builder> getPartitionKeys() {
            List<ResponsePartitionKey.Builder> result = ResponsePartitionKeyListCopier.copyToBuilder(this.partitionKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPartitionKeys(Collection<ResponsePartitionKey.BuilderImpl> partitionKeys) {
            this.partitionKeys = ResponsePartitionKeyListCopier.copyFromBuilder(partitionKeys);
        }

        @Override
        @Transient
        public final Builder partitionKeys(Collection<ResponsePartitionKey> partitionKeys) {
            this.partitionKeys = ResponsePartitionKeyListCopier.copy(partitionKeys);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder partitionKeys(ResponsePartitionKey... partitionKeys) {
            partitionKeys(Arrays.asList(partitionKeys));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder partitionKeys(Consumer<ResponsePartitionKey.Builder>... partitionKeys) {
            partitionKeys(Stream.of(partitionKeys).map(c -> ResponsePartitionKey.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<DimensionKeyDescription.Builder> getKeys() {
            List<DimensionKeyDescription.Builder> result = DimensionKeyDescriptionListCopier.copyToBuilder(this.keys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKeys(Collection<DimensionKeyDescription.BuilderImpl> keys) {
            this.keys = DimensionKeyDescriptionListCopier.copyFromBuilder(keys);
        }

        @Override
        @Transient
        public final Builder keys(Collection<DimensionKeyDescription> keys) {
            this.keys = DimensionKeyDescriptionListCopier.copy(keys);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder keys(DimensionKeyDescription... keys) {
            keys(Arrays.asList(keys));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder keys(Consumer<DimensionKeyDescription.Builder>... keys) {
            keys(Stream.of(keys).map(c -> DimensionKeyDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeDimensionKeysResponse build() {
            return new DescribeDimensionKeysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
