/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pi.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDimensionKeysRequest extends PiRequest implements
        ToCopyableBuilder<DescribeDimensionKeysRequest.Builder, DescribeDimensionKeysRequest> {
    private static final SdkField<String> SERVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceType").getter(getter(DescribeDimensionKeysRequest::serviceTypeAsString))
            .setter(setter(Builder::serviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceType").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(DescribeDimensionKeysRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(DescribeDimensionKeysRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(DescribeDimensionKeysRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> METRIC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Metric")
            .getter(getter(DescribeDimensionKeysRequest::metric)).setter(setter(Builder::metric))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric").build()).build();

    private static final SdkField<Integer> PERIOD_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PeriodInSeconds").getter(getter(DescribeDimensionKeysRequest::periodInSeconds))
            .setter(setter(Builder::periodInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodInSeconds").build()).build();

    private static final SdkField<DimensionGroup> GROUP_BY_FIELD = SdkField.<DimensionGroup> builder(MarshallingType.SDK_POJO)
            .memberName("GroupBy").getter(getter(DescribeDimensionKeysRequest::groupBy)).setter(setter(Builder::groupBy))
            .constructor(DimensionGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupBy").build()).build();

    private static final SdkField<List<String>> ADDITIONAL_METRICS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdditionalMetrics")
            .getter(getter(DescribeDimensionKeysRequest::additionalMetrics))
            .setter(setter(Builder::additionalMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DimensionGroup> PARTITION_BY_FIELD = SdkField
            .<DimensionGroup> builder(MarshallingType.SDK_POJO).memberName("PartitionBy")
            .getter(getter(DescribeDimensionKeysRequest::partitionBy)).setter(setter(Builder::partitionBy))
            .constructor(DimensionGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionBy").build()).build();

    private static final SdkField<Map<String, String>> FILTER_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Filter")
            .getter(getter(DescribeDimensionKeysRequest::filter))
            .setter(setter(Builder::filter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeDimensionKeysRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeDimensionKeysRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_TYPE_FIELD,
            IDENTIFIER_FIELD, START_TIME_FIELD, END_TIME_FIELD, METRIC_FIELD, PERIOD_IN_SECONDS_FIELD, GROUP_BY_FIELD,
            ADDITIONAL_METRICS_FIELD, PARTITION_BY_FIELD, FILTER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String serviceType;

    private final String identifier;

    private final Instant startTime;

    private final Instant endTime;

    private final String metric;

    private final Integer periodInSeconds;

    private final DimensionGroup groupBy;

    private final List<String> additionalMetrics;

    private final DimensionGroup partitionBy;

    private final Map<String, String> filter;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeDimensionKeysRequest(BuilderImpl builder) {
        super(builder);
        this.serviceType = builder.serviceType;
        this.identifier = builder.identifier;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.metric = builder.metric;
        this.periodInSeconds = builder.periodInSeconds;
        this.groupBy = builder.groupBy;
        this.additionalMetrics = builder.additionalMetrics;
        this.partitionBy = builder.partitionBy;
        this.filter = builder.filter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The Amazon Web Services service for which Performance Insights will return metrics. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RDS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DOCDB</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceType} will
     * return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceTypeAsString}.
     * </p>
     * 
     * @return The Amazon Web Services service for which Performance Insights will return metrics. Valid values are as
     *         follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RDS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DOCDB</code>
     *         </p>
     *         </li>
     * @see ServiceType
     */
    public final ServiceType serviceType() {
        return ServiceType.fromValue(serviceType);
    }

    /**
     * <p>
     * The Amazon Web Services service for which Performance Insights will return metrics. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RDS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DOCDB</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceType} will
     * return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceTypeAsString}.
     * </p>
     * 
     * @return The Amazon Web Services service for which Performance Insights will return metrics. Valid values are as
     *         follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RDS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DOCDB</code>
     *         </p>
     *         </li>
     * @see ServiceType
     */
    public final String serviceTypeAsString() {
        return serviceType;
    }

    /**
     * <p>
     * An immutable, Amazon Web Services Region-unique identifier for a data source. Performance Insights gathers
     * metrics from this data source.
     * </p>
     * <p>
     * To use an Amazon RDS instance as a data source, you specify its <code>DbiResourceId</code> value. For example,
     * specify <code>db-FAIHNTYBKTGAUSUZQYPDS2GW4A</code>.
     * </p>
     * 
     * @return An immutable, Amazon Web Services Region-unique identifier for a data source. Performance Insights
     *         gathers metrics from this data source.</p>
     *         <p>
     *         To use an Amazon RDS instance as a data source, you specify its <code>DbiResourceId</code> value. For
     *         example, specify <code>db-FAIHNTYBKTGAUSUZQYPDS2GW4A</code>.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The date and time specifying the beginning of the requested time series data. You must specify a
     * <code>StartTime</code> within the past 7 days. The value specified is <i>inclusive</i>, which means that data
     * points equal to or greater than <code>StartTime</code> are returned.
     * </p>
     * <p>
     * The value for <code>StartTime</code> must be earlier than the value for <code>EndTime</code>.
     * </p>
     * 
     * @return The date and time specifying the beginning of the requested time series data. You must specify a
     *         <code>StartTime</code> within the past 7 days. The value specified is <i>inclusive</i>, which means that
     *         data points equal to or greater than <code>StartTime</code> are returned. </p>
     *         <p>
     *         The value for <code>StartTime</code> must be earlier than the value for <code>EndTime</code>.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The date and time specifying the end of the requested time series data. The value specified is <i>exclusive</i>,
     * which means that data points less than (but not equal to) <code>EndTime</code> are returned.
     * </p>
     * <p>
     * The value for <code>EndTime</code> must be later than the value for <code>StartTime</code>.
     * </p>
     * 
     * @return The date and time specifying the end of the requested time series data. The value specified is
     *         <i>exclusive</i>, which means that data points less than (but not equal to) <code>EndTime</code> are
     *         returned.</p>
     *         <p>
     *         The value for <code>EndTime</code> must be later than the value for <code>StartTime</code>.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The name of a Performance Insights metric to be measured.
     * </p>
     * <p>
     * Valid values for <code>Metric</code> are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>db.load.avg</code> - A scaled representation of the number of active sessions for the database engine.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sampledload.avg</code> - The raw number of active sessions for the database engine.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the number of active sessions is less than an internal Performance Insights threshold,
     * <code>db.load.avg</code> and <code>db.sampledload.avg</code> are the same value. If the number of active sessions
     * is greater than the internal threshold, Performance Insights samples the active sessions, with
     * <code>db.load.avg</code> showing the scaled values, <code>db.sampledload.avg</code> showing the raw values, and
     * <code>db.sampledload.avg</code> less than <code>db.load.avg</code>. For most use cases, you can query
     * <code>db.load.avg</code> only.
     * </p>
     * 
     * @return The name of a Performance Insights metric to be measured.</p>
     *         <p>
     *         Valid values for <code>Metric</code> are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>db.load.avg</code> - A scaled representation of the number of active sessions for the database
     *         engine.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.sampledload.avg</code> - The raw number of active sessions for the database engine.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If the number of active sessions is less than an internal Performance Insights threshold,
     *         <code>db.load.avg</code> and <code>db.sampledload.avg</code> are the same value. If the number of active
     *         sessions is greater than the internal threshold, Performance Insights samples the active sessions, with
     *         <code>db.load.avg</code> showing the scaled values, <code>db.sampledload.avg</code> showing the raw
     *         values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>. For most use cases, you
     *         can query <code>db.load.avg</code> only.
     */
    public final String metric() {
        return metric;
    }

    /**
     * <p>
     * The granularity, in seconds, of the data points returned from Performance Insights. A period can be as short as
     * one second, or as long as one day (86400 seconds). Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>1</code> (one second)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>60</code> (one minute)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>300</code> (five minutes)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>3600</code> (one hour)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>86400</code> (twenty-four hours)
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you don't specify <code>PeriodInSeconds</code>, then Performance Insights chooses a value for you, with a goal
     * of returning roughly 100-200 data points in the response.
     * </p>
     * 
     * @return The granularity, in seconds, of the data points returned from Performance Insights. A period can be as
     *         short as one second, or as long as one day (86400 seconds). Valid values are: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>1</code> (one second)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>60</code> (one minute)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>300</code> (five minutes)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>3600</code> (one hour)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>86400</code> (twenty-four hours)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you don't specify <code>PeriodInSeconds</code>, then Performance Insights chooses a value for you,
     *         with a goal of returning roughly 100-200 data points in the response.
     */
    public final Integer periodInSeconds() {
        return periodInSeconds;
    }

    /**
     * <p>
     * A specification for how to aggregate the data points from a query result. You must specify a valid dimension
     * group. Performance Insights returns all dimensions within this group, unless you provide the names of specific
     * dimensions within this group. You can also request that Performance Insights return a limited number of values
     * for a dimension.
     * </p>
     * 
     * @return A specification for how to aggregate the data points from a query result. You must specify a valid
     *         dimension group. Performance Insights returns all dimensions within this group, unless you provide the
     *         names of specific dimensions within this group. You can also request that Performance Insights return a
     *         limited number of values for a dimension.
     */
    public final DimensionGroup groupBy() {
        return groupBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalMetrics property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalMetrics() {
        return additionalMetrics != null && !(additionalMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Additional metrics for the top <code>N</code> dimension keys. If the specified dimension group in the
     * <code>GroupBy</code> parameter is <code>db.sql_tokenized</code>, you can specify per-SQL metrics to get the
     * values for the top <code>N</code> SQL digests. The response syntax is as follows:
     * <code>"AdditionalMetrics" : { "<i>string</i>" : "<i>string</i>" }</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalMetrics} method.
     * </p>
     * 
     * @return Additional metrics for the top <code>N</code> dimension keys. If the specified dimension group in the
     *         <code>GroupBy</code> parameter is <code>db.sql_tokenized</code>, you can specify per-SQL metrics to get
     *         the values for the top <code>N</code> SQL digests. The response syntax is as follows:
     *         <code>"AdditionalMetrics" : { "<i>string</i>" : "<i>string</i>" }</code>.
     */
    public final List<String> additionalMetrics() {
        return additionalMetrics;
    }

    /**
     * <p>
     * For each dimension specified in <code>GroupBy</code>, specify a secondary dimension to further subdivide the
     * partition keys in the response.
     * </p>
     * 
     * @return For each dimension specified in <code>GroupBy</code>, specify a secondary dimension to further subdivide
     *         the partition keys in the response.
     */
    public final DimensionGroup partitionBy() {
        return partitionBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filter property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilter() {
        return filter != null && !(filter instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * One or more filters to apply in the request. Restrictions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Any number of filters by the same dimension, as specified in the <code>GroupBy</code> or <code>Partition</code>
     * parameters.
     * </p>
     * </li>
     * <li>
     * <p>
     * A single filter for any other dimension in this dimension group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilter} method.
     * </p>
     * 
     * @return One or more filters to apply in the request. Restrictions:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Any number of filters by the same dimension, as specified in the <code>GroupBy</code> or
     *         <code>Partition</code> parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A single filter for any other dimension in this dimension group.
     *         </p>
     *         </li>
     */
    public final Map<String, String> filter() {
        return filter;
    }

    /**
     * <p>
     * The maximum number of items to return in the response. If more items exist than the specified
     * <code>MaxRecords</code> value, a pagination token is included in the response so that the remaining results can
     * be retrieved.
     * </p>
     * 
     * @return The maximum number of items to return in the response. If more items exist than the specified
     *         <code>MaxRecords</code> value, a pagination token is included in the response so that the remaining
     *         results can be retrieved.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(metric());
        hashCode = 31 * hashCode + Objects.hashCode(periodInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(groupBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalMetrics() ? additionalMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(partitionBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilter() ? filter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDimensionKeysRequest)) {
            return false;
        }
        DescribeDimensionKeysRequest other = (DescribeDimensionKeysRequest) obj;
        return Objects.equals(serviceTypeAsString(), other.serviceTypeAsString())
                && Objects.equals(identifier(), other.identifier()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(metric(), other.metric())
                && Objects.equals(periodInSeconds(), other.periodInSeconds()) && Objects.equals(groupBy(), other.groupBy())
                && hasAdditionalMetrics() == other.hasAdditionalMetrics()
                && Objects.equals(additionalMetrics(), other.additionalMetrics())
                && Objects.equals(partitionBy(), other.partitionBy()) && hasFilter() == other.hasFilter()
                && Objects.equals(filter(), other.filter()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDimensionKeysRequest").add("ServiceType", serviceTypeAsString())
                .add("Identifier", identifier()).add("StartTime", startTime()).add("EndTime", endTime()).add("Metric", metric())
                .add("PeriodInSeconds", periodInSeconds()).add("GroupBy", groupBy())
                .add("AdditionalMetrics", hasAdditionalMetrics() ? additionalMetrics() : null).add("PartitionBy", partitionBy())
                .add("Filter", hasFilter() ? filter() : null).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceType":
            return Optional.ofNullable(clazz.cast(serviceTypeAsString()));
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Metric":
            return Optional.ofNullable(clazz.cast(metric()));
        case "PeriodInSeconds":
            return Optional.ofNullable(clazz.cast(periodInSeconds()));
        case "GroupBy":
            return Optional.ofNullable(clazz.cast(groupBy()));
        case "AdditionalMetrics":
            return Optional.ofNullable(clazz.cast(additionalMetrics()));
        case "PartitionBy":
            return Optional.ofNullable(clazz.cast(partitionBy()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDimensionKeysRequest, T> g) {
        return obj -> g.apply((DescribeDimensionKeysRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PiRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDimensionKeysRequest> {
        /**
         * <p>
         * The Amazon Web Services service for which Performance Insights will return metrics. Valid values are as
         * follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RDS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DOCDB</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param serviceType
         *        The Amazon Web Services service for which Performance Insights will return metrics. Valid values are
         *        as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RDS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DOCDB</code>
         *        </p>
         *        </li>
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder serviceType(String serviceType);

        /**
         * <p>
         * The Amazon Web Services service for which Performance Insights will return metrics. Valid values are as
         * follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RDS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DOCDB</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param serviceType
         *        The Amazon Web Services service for which Performance Insights will return metrics. Valid values are
         *        as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RDS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DOCDB</code>
         *        </p>
         *        </li>
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder serviceType(ServiceType serviceType);

        /**
         * <p>
         * An immutable, Amazon Web Services Region-unique identifier for a data source. Performance Insights gathers
         * metrics from this data source.
         * </p>
         * <p>
         * To use an Amazon RDS instance as a data source, you specify its <code>DbiResourceId</code> value. For
         * example, specify <code>db-FAIHNTYBKTGAUSUZQYPDS2GW4A</code>.
         * </p>
         * 
         * @param identifier
         *        An immutable, Amazon Web Services Region-unique identifier for a data source. Performance Insights
         *        gathers metrics from this data source.</p>
         *        <p>
         *        To use an Amazon RDS instance as a data source, you specify its <code>DbiResourceId</code> value. For
         *        example, specify <code>db-FAIHNTYBKTGAUSUZQYPDS2GW4A</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The date and time specifying the beginning of the requested time series data. You must specify a
         * <code>StartTime</code> within the past 7 days. The value specified is <i>inclusive</i>, which means that data
         * points equal to or greater than <code>StartTime</code> are returned.
         * </p>
         * <p>
         * The value for <code>StartTime</code> must be earlier than the value for <code>EndTime</code>.
         * </p>
         * 
         * @param startTime
         *        The date and time specifying the beginning of the requested time series data. You must specify a
         *        <code>StartTime</code> within the past 7 days. The value specified is <i>inclusive</i>, which means
         *        that data points equal to or greater than <code>StartTime</code> are returned. </p>
         *        <p>
         *        The value for <code>StartTime</code> must be earlier than the value for <code>EndTime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The date and time specifying the end of the requested time series data. The value specified is
         * <i>exclusive</i>, which means that data points less than (but not equal to) <code>EndTime</code> are
         * returned.
         * </p>
         * <p>
         * The value for <code>EndTime</code> must be later than the value for <code>StartTime</code>.
         * </p>
         * 
         * @param endTime
         *        The date and time specifying the end of the requested time series data. The value specified is
         *        <i>exclusive</i>, which means that data points less than (but not equal to) <code>EndTime</code> are
         *        returned.</p>
         *        <p>
         *        The value for <code>EndTime</code> must be later than the value for <code>StartTime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The name of a Performance Insights metric to be measured.
         * </p>
         * <p>
         * Valid values for <code>Metric</code> are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>db.load.avg</code> - A scaled representation of the number of active sessions for the database engine.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>db.sampledload.avg</code> - The raw number of active sessions for the database engine.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the number of active sessions is less than an internal Performance Insights threshold,
         * <code>db.load.avg</code> and <code>db.sampledload.avg</code> are the same value. If the number of active
         * sessions is greater than the internal threshold, Performance Insights samples the active sessions, with
         * <code>db.load.avg</code> showing the scaled values, <code>db.sampledload.avg</code> showing the raw values,
         * and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>. For most use cases, you can query
         * <code>db.load.avg</code> only.
         * </p>
         * 
         * @param metric
         *        The name of a Performance Insights metric to be measured.</p>
         *        <p>
         *        Valid values for <code>Metric</code> are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>db.load.avg</code> - A scaled representation of the number of active sessions for the database
         *        engine.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>db.sampledload.avg</code> - The raw number of active sessions for the database engine.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the number of active sessions is less than an internal Performance Insights threshold,
         *        <code>db.load.avg</code> and <code>db.sampledload.avg</code> are the same value. If the number of
         *        active sessions is greater than the internal threshold, Performance Insights samples the active
         *        sessions, with <code>db.load.avg</code> showing the scaled values, <code>db.sampledload.avg</code>
         *        showing the raw values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>. For
         *        most use cases, you can query <code>db.load.avg</code> only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metric(String metric);

        /**
         * <p>
         * The granularity, in seconds, of the data points returned from Performance Insights. A period can be as short
         * as one second, or as long as one day (86400 seconds). Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>1</code> (one second)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>60</code> (one minute)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>300</code> (five minutes)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>3600</code> (one hour)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>86400</code> (twenty-four hours)
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you don't specify <code>PeriodInSeconds</code>, then Performance Insights chooses a value for you, with a
         * goal of returning roughly 100-200 data points in the response.
         * </p>
         * 
         * @param periodInSeconds
         *        The granularity, in seconds, of the data points returned from Performance Insights. A period can be as
         *        short as one second, or as long as one day (86400 seconds). Valid values are: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>1</code> (one second)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>60</code> (one minute)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>300</code> (five minutes)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>3600</code> (one hour)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>86400</code> (twenty-four hours)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you don't specify <code>PeriodInSeconds</code>, then Performance Insights chooses a value for you,
         *        with a goal of returning roughly 100-200 data points in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodInSeconds(Integer periodInSeconds);

        /**
         * <p>
         * A specification for how to aggregate the data points from a query result. You must specify a valid dimension
         * group. Performance Insights returns all dimensions within this group, unless you provide the names of
         * specific dimensions within this group. You can also request that Performance Insights return a limited number
         * of values for a dimension.
         * </p>
         * 
         * @param groupBy
         *        A specification for how to aggregate the data points from a query result. You must specify a valid
         *        dimension group. Performance Insights returns all dimensions within this group, unless you provide the
         *        names of specific dimensions within this group. You can also request that Performance Insights return
         *        a limited number of values for a dimension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupBy(DimensionGroup groupBy);

        /**
         * <p>
         * A specification for how to aggregate the data points from a query result. You must specify a valid dimension
         * group. Performance Insights returns all dimensions within this group, unless you provide the names of
         * specific dimensions within this group. You can also request that Performance Insights return a limited number
         * of values for a dimension.
         * </p>
         * This is a convenience method that creates an instance of the {@link DimensionGroup.Builder} avoiding the need
         * to create one manually via {@link DimensionGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DimensionGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #groupBy(DimensionGroup)}.
         * 
         * @param groupBy
         *        a consumer that will call methods on {@link DimensionGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupBy(DimensionGroup)
         */
        default Builder groupBy(Consumer<DimensionGroup.Builder> groupBy) {
            return groupBy(DimensionGroup.builder().applyMutation(groupBy).build());
        }

        /**
         * <p>
         * Additional metrics for the top <code>N</code> dimension keys. If the specified dimension group in the
         * <code>GroupBy</code> parameter is <code>db.sql_tokenized</code>, you can specify per-SQL metrics to get the
         * values for the top <code>N</code> SQL digests. The response syntax is as follows:
         * <code>"AdditionalMetrics" : { "<i>string</i>" : "<i>string</i>" }</code>.
         * </p>
         * 
         * @param additionalMetrics
         *        Additional metrics for the top <code>N</code> dimension keys. If the specified dimension group in the
         *        <code>GroupBy</code> parameter is <code>db.sql_tokenized</code>, you can specify per-SQL metrics to
         *        get the values for the top <code>N</code> SQL digests. The response syntax is as follows:
         *        <code>"AdditionalMetrics" : { "<i>string</i>" : "<i>string</i>" }</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalMetrics(Collection<String> additionalMetrics);

        /**
         * <p>
         * Additional metrics for the top <code>N</code> dimension keys. If the specified dimension group in the
         * <code>GroupBy</code> parameter is <code>db.sql_tokenized</code>, you can specify per-SQL metrics to get the
         * values for the top <code>N</code> SQL digests. The response syntax is as follows:
         * <code>"AdditionalMetrics" : { "<i>string</i>" : "<i>string</i>" }</code>.
         * </p>
         * 
         * @param additionalMetrics
         *        Additional metrics for the top <code>N</code> dimension keys. If the specified dimension group in the
         *        <code>GroupBy</code> parameter is <code>db.sql_tokenized</code>, you can specify per-SQL metrics to
         *        get the values for the top <code>N</code> SQL digests. The response syntax is as follows:
         *        <code>"AdditionalMetrics" : { "<i>string</i>" : "<i>string</i>" }</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalMetrics(String... additionalMetrics);

        /**
         * <p>
         * For each dimension specified in <code>GroupBy</code>, specify a secondary dimension to further subdivide the
         * partition keys in the response.
         * </p>
         * 
         * @param partitionBy
         *        For each dimension specified in <code>GroupBy</code>, specify a secondary dimension to further
         *        subdivide the partition keys in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionBy(DimensionGroup partitionBy);

        /**
         * <p>
         * For each dimension specified in <code>GroupBy</code>, specify a secondary dimension to further subdivide the
         * partition keys in the response.
         * </p>
         * This is a convenience method that creates an instance of the {@link DimensionGroup.Builder} avoiding the need
         * to create one manually via {@link DimensionGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DimensionGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #partitionBy(DimensionGroup)}.
         * 
         * @param partitionBy
         *        a consumer that will call methods on {@link DimensionGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partitionBy(DimensionGroup)
         */
        default Builder partitionBy(Consumer<DimensionGroup.Builder> partitionBy) {
            return partitionBy(DimensionGroup.builder().applyMutation(partitionBy).build());
        }

        /**
         * <p>
         * One or more filters to apply in the request. Restrictions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Any number of filters by the same dimension, as specified in the <code>GroupBy</code> or
         * <code>Partition</code> parameters.
         * </p>
         * </li>
         * <li>
         * <p>
         * A single filter for any other dimension in this dimension group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filter
         *        One or more filters to apply in the request. Restrictions:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Any number of filters by the same dimension, as specified in the <code>GroupBy</code> or
         *        <code>Partition</code> parameters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A single filter for any other dimension in this dimension group.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Map<String, String> filter);

        /**
         * <p>
         * The maximum number of items to return in the response. If more items exist than the specified
         * <code>MaxRecords</code> value, a pagination token is included in the response so that the remaining results
         * can be retrieved.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return in the response. If more items exist than the specified
         *        <code>MaxRecords</code> value, a pagination token is included in the response so that the remaining
         *        results can be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param nextToken
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PiRequest.BuilderImpl implements Builder {
        private String serviceType;

        private String identifier;

        private Instant startTime;

        private Instant endTime;

        private String metric;

        private Integer periodInSeconds;

        private DimensionGroup groupBy;

        private List<String> additionalMetrics = DefaultSdkAutoConstructList.getInstance();

        private DimensionGroup partitionBy;

        private Map<String, String> filter = DefaultSdkAutoConstructMap.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDimensionKeysRequest model) {
            super(model);
            serviceType(model.serviceType);
            identifier(model.identifier);
            startTime(model.startTime);
            endTime(model.endTime);
            metric(model.metric);
            periodInSeconds(model.periodInSeconds);
            groupBy(model.groupBy);
            additionalMetrics(model.additionalMetrics);
            partitionBy(model.partitionBy);
            filter(model.filter);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getServiceType() {
            return serviceType;
        }

        public final void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        @Override
        public final Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @Override
        public final Builder serviceType(ServiceType serviceType) {
            this.serviceType(serviceType == null ? null : serviceType.toString());
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getMetric() {
            return metric;
        }

        public final void setMetric(String metric) {
            this.metric = metric;
        }

        @Override
        public final Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        public final Integer getPeriodInSeconds() {
            return periodInSeconds;
        }

        public final void setPeriodInSeconds(Integer periodInSeconds) {
            this.periodInSeconds = periodInSeconds;
        }

        @Override
        public final Builder periodInSeconds(Integer periodInSeconds) {
            this.periodInSeconds = periodInSeconds;
            return this;
        }

        public final DimensionGroup.Builder getGroupBy() {
            return groupBy != null ? groupBy.toBuilder() : null;
        }

        public final void setGroupBy(DimensionGroup.BuilderImpl groupBy) {
            this.groupBy = groupBy != null ? groupBy.build() : null;
        }

        @Override
        public final Builder groupBy(DimensionGroup groupBy) {
            this.groupBy = groupBy;
            return this;
        }

        public final Collection<String> getAdditionalMetrics() {
            if (additionalMetrics instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalMetrics;
        }

        public final void setAdditionalMetrics(Collection<String> additionalMetrics) {
            this.additionalMetrics = AdditionalMetricsListCopier.copy(additionalMetrics);
        }

        @Override
        public final Builder additionalMetrics(Collection<String> additionalMetrics) {
            this.additionalMetrics = AdditionalMetricsListCopier.copy(additionalMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalMetrics(String... additionalMetrics) {
            additionalMetrics(Arrays.asList(additionalMetrics));
            return this;
        }

        public final DimensionGroup.Builder getPartitionBy() {
            return partitionBy != null ? partitionBy.toBuilder() : null;
        }

        public final void setPartitionBy(DimensionGroup.BuilderImpl partitionBy) {
            this.partitionBy = partitionBy != null ? partitionBy.build() : null;
        }

        @Override
        public final Builder partitionBy(DimensionGroup partitionBy) {
            this.partitionBy = partitionBy;
            return this;
        }

        public final Map<String, String> getFilter() {
            if (filter instanceof SdkAutoConstructMap) {
                return null;
            }
            return filter;
        }

        public final void setFilter(Map<String, String> filter) {
            this.filter = MetricQueryFilterMapCopier.copy(filter);
        }

        @Override
        public final Builder filter(Map<String, String> filter) {
            this.filter = MetricQueryFilterMapCopier.copy(filter);
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDimensionKeysRequest build() {
            return new DescribeDimensionKeysRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
