/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that includes the requested dimension key values and aggregated metric values within a dimension group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DimensionKeyDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<DimensionKeyDescription.Builder, DimensionKeyDescription> {
    private static final SdkField<Map<String, String>> DIMENSIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Dimensions")
            .getter(getter(DimensionKeyDescription::dimensions))
            .setter(setter(Builder::dimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Double> TOTAL_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Total")
            .getter(getter(DimensionKeyDescription::total)).setter(setter(Builder::total))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Total").build()).build();

    private static final SdkField<Map<String, Double>> ADDITIONAL_METRICS_FIELD = SdkField
            .<Map<String, Double>> builder(MarshallingType.MAP)
            .memberName("AdditionalMetrics")
            .getter(getter(DimensionKeyDescription::additionalMetrics))
            .setter(setter(Builder::additionalMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalMetrics").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<Double>> PARTITIONS_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("Partitions")
            .getter(getter(DimensionKeyDescription::partitions))
            .setter(setter(Builder::partitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Partitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD, TOTAL_FIELD,
            ADDITIONAL_METRICS_FIELD, PARTITIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, String> dimensions;

    private final Double total;

    private final Map<String, Double> additionalMetrics;

    private final List<Double> partitions;

    private DimensionKeyDescription(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.total = builder.total;
        this.additionalMetrics = builder.additionalMetrics;
        this.partitions = builder.partitions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Dimensions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDimensions() {
        return dimensions != null && !(dimensions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of name-value pairs for the dimensions in the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensions} method.
     * </p>
     * 
     * @return A map of name-value pairs for the dimensions in the group.
     */
    public final Map<String, String> dimensions() {
        return dimensions;
    }

    /**
     * <p>
     * The aggregated metric value for the dimensions, over the requested time range.
     * </p>
     * 
     * @return The aggregated metric value for the dimensions, over the requested time range.
     */
    public final Double total() {
        return total;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalMetrics property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalMetrics() {
        return additionalMetrics != null && !(additionalMetrics instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that contains the value for each additional metric.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalMetrics} method.
     * </p>
     * 
     * @return A map that contains the value for each additional metric.
     */
    public final Map<String, Double> additionalMetrics() {
        return additionalMetrics;
    }

    /**
     * For responses, this returns true if the service returned a value for the Partitions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPartitions() {
        return partitions != null && !(partitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If <code>PartitionBy</code> was specified, <code>PartitionKeys</code> contains the dimensions that were.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPartitions} method.
     * </p>
     * 
     * @return If <code>PartitionBy</code> was specified, <code>PartitionKeys</code> contains the dimensions that were.
     */
    public final List<Double> partitions() {
        return partitions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensions() ? dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(total());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalMetrics() ? additionalMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPartitions() ? partitions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DimensionKeyDescription)) {
            return false;
        }
        DimensionKeyDescription other = (DimensionKeyDescription) obj;
        return hasDimensions() == other.hasDimensions() && Objects.equals(dimensions(), other.dimensions())
                && Objects.equals(total(), other.total()) && hasAdditionalMetrics() == other.hasAdditionalMetrics()
                && Objects.equals(additionalMetrics(), other.additionalMetrics()) && hasPartitions() == other.hasPartitions()
                && Objects.equals(partitions(), other.partitions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DimensionKeyDescription").add("Dimensions", hasDimensions() ? dimensions() : null)
                .add("Total", total()).add("AdditionalMetrics", hasAdditionalMetrics() ? additionalMetrics() : null)
                .add("Partitions", hasPartitions() ? partitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "Total":
            return Optional.ofNullable(clazz.cast(total()));
        case "AdditionalMetrics":
            return Optional.ofNullable(clazz.cast(additionalMetrics()));
        case "Partitions":
            return Optional.ofNullable(clazz.cast(partitions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DimensionKeyDescription, T> g) {
        return obj -> g.apply((DimensionKeyDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DimensionKeyDescription> {
        /**
         * <p>
         * A map of name-value pairs for the dimensions in the group.
         * </p>
         * 
         * @param dimensions
         *        A map of name-value pairs for the dimensions in the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Map<String, String> dimensions);

        /**
         * <p>
         * The aggregated metric value for the dimensions, over the requested time range.
         * </p>
         * 
         * @param total
         *        The aggregated metric value for the dimensions, over the requested time range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(Double total);

        /**
         * <p>
         * A map that contains the value for each additional metric.
         * </p>
         * 
         * @param additionalMetrics
         *        A map that contains the value for each additional metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalMetrics(Map<String, Double> additionalMetrics);

        /**
         * <p>
         * If <code>PartitionBy</code> was specified, <code>PartitionKeys</code> contains the dimensions that were.
         * </p>
         * 
         * @param partitions
         *        If <code>PartitionBy</code> was specified, <code>PartitionKeys</code> contains the dimensions that
         *        were.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitions(Collection<Double> partitions);

        /**
         * <p>
         * If <code>PartitionBy</code> was specified, <code>PartitionKeys</code> contains the dimensions that were.
         * </p>
         * 
         * @param partitions
         *        If <code>PartitionBy</code> was specified, <code>PartitionKeys</code> contains the dimensions that
         *        were.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitions(Double... partitions);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> dimensions = DefaultSdkAutoConstructMap.getInstance();

        private Double total;

        private Map<String, Double> additionalMetrics = DefaultSdkAutoConstructMap.getInstance();

        private List<Double> partitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DimensionKeyDescription model) {
            dimensions(model.dimensions);
            total(model.total);
            additionalMetrics(model.additionalMetrics);
            partitions(model.partitions);
        }

        public final Map<String, String> getDimensions() {
            if (dimensions instanceof SdkAutoConstructMap) {
                return null;
            }
            return dimensions;
        }

        public final void setDimensions(Map<String, String> dimensions) {
            this.dimensions = DimensionMapCopier.copy(dimensions);
        }

        @Override
        public final Builder dimensions(Map<String, String> dimensions) {
            this.dimensions = DimensionMapCopier.copy(dimensions);
            return this;
        }

        public final Double getTotal() {
            return total;
        }

        public final void setTotal(Double total) {
            this.total = total;
        }

        @Override
        public final Builder total(Double total) {
            this.total = total;
            return this;
        }

        public final Map<String, Double> getAdditionalMetrics() {
            if (additionalMetrics instanceof SdkAutoConstructMap) {
                return null;
            }
            return additionalMetrics;
        }

        public final void setAdditionalMetrics(Map<String, Double> additionalMetrics) {
            this.additionalMetrics = AdditionalMetricsMapCopier.copy(additionalMetrics);
        }

        @Override
        public final Builder additionalMetrics(Map<String, Double> additionalMetrics) {
            this.additionalMetrics = AdditionalMetricsMapCopier.copy(additionalMetrics);
            return this;
        }

        public final Collection<Double> getPartitions() {
            if (partitions instanceof SdkAutoConstructList) {
                return null;
            }
            return partitions;
        }

        public final void setPartitions(Collection<Double> partitions) {
            this.partitions = MetricValuesListCopier.copy(partitions);
        }

        @Override
        public final Builder partitions(Collection<Double> partitions) {
            this.partitions = MetricValuesListCopier.copy(partitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitions(Double... partitions) {
            partitions(Arrays.asList(partitions));
            return this;
        }

        @Override
        public DimensionKeyDescription build() {
            return new DimensionKeyDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
