/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.pi.DefaultPiBaseClientBuilder;
import software.amazon.awssdk.services.pi.DefaultPiClient;
import software.amazon.awssdk.services.pi.PiClient;
import software.amazon.awssdk.services.pi.PiClientBuilder;
import software.amazon.awssdk.services.pi.PiServiceClientConfiguration;
import software.amazon.awssdk.services.pi.endpoints.PiEndpointProvider;

@SdkInternalApi
final class DefaultPiClientBuilder
extends DefaultPiBaseClientBuilder<PiClientBuilder, PiClient>
implements PiClientBuilder {
    DefaultPiClientBuilder() {
    }

    @Override
    public DefaultPiClientBuilder endpointProvider(PiEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final PiClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultPiClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        PiServiceClientConfiguration serviceClientConfiguration = PiServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultPiClient(serviceClientConfiguration, clientConfiguration);
    }
}

