/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TextFormat {
    PLAIN_TEXT("PLAIN_TEXT"),
    MARKDOWN("MARKDOWN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TextFormat> VALUE_MAP;
    private final String value;

    private TextFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TextFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TextFormat> knownValues() {
        EnumSet<TextFormat> knownValues = EnumSet.allOf(TextFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TextFormat.class, TextFormat::toString);
    }
}

