/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.pi.DefaultPiBaseClientBuilder;
import software.amazon.awssdk.services.pi.DefaultPiClient;
import software.amazon.awssdk.services.pi.PiClient;
import software.amazon.awssdk.services.pi.PiClientBuilder;
import software.amazon.awssdk.services.pi.PiServiceClientConfiguration;
import software.amazon.awssdk.services.pi.endpoints.PiEndpointProvider;

@SdkInternalApi
final class DefaultPiClientBuilder
extends DefaultPiBaseClientBuilder<PiClientBuilder, PiClient>
implements PiClientBuilder {
    DefaultPiClientBuilder() {
    }

    @Override
    public DefaultPiClientBuilder endpointProvider(PiEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final PiClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultPiClientBuilder.validateClientOptions(clientConfiguration);
        PiServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultPiClient client = new DefaultPiClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private PiServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return PiServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

