/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pi.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourceMetricsRequest extends PiRequest implements
        ToCopyableBuilder<GetResourceMetricsRequest.Builder, GetResourceMetricsRequest> {
    private static final SdkField<String> SERVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceType").getter(getter(GetResourceMetricsRequest::serviceTypeAsString))
            .setter(setter(Builder::serviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceType").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(GetResourceMetricsRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<List<MetricQuery>> METRIC_QUERIES_FIELD = SdkField
            .<List<MetricQuery>> builder(MarshallingType.LIST)
            .memberName("MetricQueries")
            .getter(getter(GetResourceMetricsRequest::metricQueries))
            .setter(setter(Builder::metricQueries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricQueries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricQuery> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricQuery::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(GetResourceMetricsRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(GetResourceMetricsRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Integer> PERIOD_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PeriodInSeconds").getter(getter(GetResourceMetricsRequest::periodInSeconds))
            .setter(setter(Builder::periodInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodInSeconds").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetResourceMetricsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetResourceMetricsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> PERIOD_ALIGNMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PeriodAlignment").getter(getter(GetResourceMetricsRequest::periodAlignmentAsString))
            .setter(setter(Builder::periodAlignment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodAlignment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_TYPE_FIELD,
            IDENTIFIER_FIELD, METRIC_QUERIES_FIELD, START_TIME_FIELD, END_TIME_FIELD, PERIOD_IN_SECONDS_FIELD, MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, PERIOD_ALIGNMENT_FIELD));

    private final String serviceType;

    private final String identifier;

    private final List<MetricQuery> metricQueries;

    private final Instant startTime;

    private final Instant endTime;

    private final Integer periodInSeconds;

    private final Integer maxResults;

    private final String nextToken;

    private final String periodAlignment;

    private GetResourceMetricsRequest(BuilderImpl builder) {
        super(builder);
        this.serviceType = builder.serviceType;
        this.identifier = builder.identifier;
        this.metricQueries = builder.metricQueries;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.periodInSeconds = builder.periodInSeconds;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.periodAlignment = builder.periodAlignment;
    }

    /**
     * <p>
     * The Amazon Web Services service for which Performance Insights returns metrics. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RDS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DOCDB</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceType} will
     * return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceTypeAsString}.
     * </p>
     * 
     * @return The Amazon Web Services service for which Performance Insights returns metrics. Valid values are as
     *         follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RDS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DOCDB</code>
     *         </p>
     *         </li>
     * @see ServiceType
     */
    public final ServiceType serviceType() {
        return ServiceType.fromValue(serviceType);
    }

    /**
     * <p>
     * The Amazon Web Services service for which Performance Insights returns metrics. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RDS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DOCDB</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceType} will
     * return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceTypeAsString}.
     * </p>
     * 
     * @return The Amazon Web Services service for which Performance Insights returns metrics. Valid values are as
     *         follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RDS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DOCDB</code>
     *         </p>
     *         </li>
     * @see ServiceType
     */
    public final String serviceTypeAsString() {
        return serviceType;
    }

    /**
     * <p>
     * An immutable identifier for a data source that is unique for an Amazon Web Services Region. Performance Insights
     * gathers metrics from this data source. In the console, the identifier is shown as <i>ResourceID</i>. When you
     * call <code>DescribeDBInstances</code>, the identifier is returned as <code>DbiResourceId</code>.
     * </p>
     * <p>
     * To use a DB instance as a data source, specify its <code>DbiResourceId</code> value. For example, specify
     * <code>db-ABCDEFGHIJKLMNOPQRSTU1VW2X</code>.
     * </p>
     * 
     * @return An immutable identifier for a data source that is unique for an Amazon Web Services Region. Performance
     *         Insights gathers metrics from this data source. In the console, the identifier is shown as
     *         <i>ResourceID</i>. When you call <code>DescribeDBInstances</code>, the identifier is returned as
     *         <code>DbiResourceId</code>.</p>
     *         <p>
     *         To use a DB instance as a data source, specify its <code>DbiResourceId</code> value. For example, specify
     *         <code>db-ABCDEFGHIJKLMNOPQRSTU1VW2X</code>.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricQueries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricQueries() {
        return metricQueries != null && !(metricQueries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of one or more queries to perform. Each query must specify a Performance Insights metric and specify an
     * aggregate function, and you can provide filtering criteria. You must append the aggregate function to the metric.
     * For example, to find the average for the metric <code>db.load</code> you must use <code>db.load.avg</code>. Valid
     * values for aggregate functions include <code>.avg</code>, <code>.min</code>, <code>.max</code>, and
     * <code>.sum</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricQueries} method.
     * </p>
     * 
     * @return An array of one or more queries to perform. Each query must specify a Performance Insights metric and
     *         specify an aggregate function, and you can provide filtering criteria. You must append the aggregate
     *         function to the metric. For example, to find the average for the metric <code>db.load</code> you must use
     *         <code>db.load.avg</code>. Valid values for aggregate functions include <code>.avg</code>,
     *         <code>.min</code>, <code>.max</code>, and <code>.sum</code>.
     */
    public final List<MetricQuery> metricQueries() {
        return metricQueries;
    }

    /**
     * <p>
     * The date and time specifying the beginning of the requested time series query range. You can't specify a
     * <code>StartTime</code> that is earlier than 7 days ago. By default, Performance Insights has 7 days of retention,
     * but you can extend this range up to 2 years. The value specified is <i>inclusive</i>. Thus, the command returns
     * data points equal to or greater than <code>StartTime</code>.
     * </p>
     * <p>
     * The value for <code>StartTime</code> must be earlier than the value for <code>EndTime</code>.
     * </p>
     * 
     * @return The date and time specifying the beginning of the requested time series query range. You can't specify a
     *         <code>StartTime</code> that is earlier than 7 days ago. By default, Performance Insights has 7 days of
     *         retention, but you can extend this range up to 2 years. The value specified is <i>inclusive</i>. Thus,
     *         the command returns data points equal to or greater than <code>StartTime</code>.</p>
     *         <p>
     *         The value for <code>StartTime</code> must be earlier than the value for <code>EndTime</code>.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The date and time specifying the end of the requested time series query range. The value specified is
     * <i>exclusive</i>. Thus, the command returns data points less than (but not equal to) <code>EndTime</code>.
     * </p>
     * <p>
     * The value for <code>EndTime</code> must be later than the value for <code>StartTime</code>.
     * </p>
     * 
     * @return The date and time specifying the end of the requested time series query range. The value specified is
     *         <i>exclusive</i>. Thus, the command returns data points less than (but not equal to) <code>EndTime</code>
     *         .</p>
     *         <p>
     *         The value for <code>EndTime</code> must be later than the value for <code>StartTime</code>.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The granularity, in seconds, of the data points returned from Performance Insights. A period can be as short as
     * one second, or as long as one day (86400 seconds). Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>1</code> (one second)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>60</code> (one minute)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>300</code> (five minutes)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>3600</code> (one hour)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>86400</code> (twenty-four hours)
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you don't specify <code>PeriodInSeconds</code>, then Performance Insights will choose a value for you, with a
     * goal of returning roughly 100-200 data points in the response.
     * </p>
     * 
     * @return The granularity, in seconds, of the data points returned from Performance Insights. A period can be as
     *         short as one second, or as long as one day (86400 seconds). Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>1</code> (one second)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>60</code> (one minute)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>300</code> (five minutes)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>3600</code> (one hour)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>86400</code> (twenty-four hours)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you don't specify <code>PeriodInSeconds</code>, then Performance Insights will choose a value for you,
     *         with a goal of returning roughly 100-200 data points in the response.
     */
    public final Integer periodInSeconds() {
        return periodInSeconds;
    }

    /**
     * <p>
     * The maximum number of items to return in the response. If more items exist than the specified
     * <code>MaxRecords</code> value, a pagination token is included in the response so that the remaining results can
     * be retrieved.
     * </p>
     * 
     * @return The maximum number of items to return in the response. If more items exist than the specified
     *         <code>MaxRecords</code> value, a pagination token is included in the response so that the remaining
     *         results can be retrieved.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The returned timestamp which is the start or end time of the time periods. The default value is
     * <code>END_TIME</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #periodAlignment}
     * will return {@link PeriodAlignment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #periodAlignmentAsString}.
     * </p>
     * 
     * @return The returned timestamp which is the start or end time of the time periods. The default value is
     *         <code>END_TIME</code>.
     * @see PeriodAlignment
     */
    public final PeriodAlignment periodAlignment() {
        return PeriodAlignment.fromValue(periodAlignment);
    }

    /**
     * <p>
     * The returned timestamp which is the start or end time of the time periods. The default value is
     * <code>END_TIME</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #periodAlignment}
     * will return {@link PeriodAlignment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #periodAlignmentAsString}.
     * </p>
     * 
     * @return The returned timestamp which is the start or end time of the time periods. The default value is
     *         <code>END_TIME</code>.
     * @see PeriodAlignment
     */
    public final String periodAlignmentAsString() {
        return periodAlignment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricQueries() ? metricQueries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(periodInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(periodAlignmentAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceMetricsRequest)) {
            return false;
        }
        GetResourceMetricsRequest other = (GetResourceMetricsRequest) obj;
        return Objects.equals(serviceTypeAsString(), other.serviceTypeAsString())
                && Objects.equals(identifier(), other.identifier()) && hasMetricQueries() == other.hasMetricQueries()
                && Objects.equals(metricQueries(), other.metricQueries()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(periodInSeconds(), other.periodInSeconds())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(periodAlignmentAsString(), other.periodAlignmentAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourceMetricsRequest").add("ServiceType", serviceTypeAsString())
                .add("Identifier", identifier()).add("MetricQueries", hasMetricQueries() ? metricQueries() : null)
                .add("StartTime", startTime()).add("EndTime", endTime()).add("PeriodInSeconds", periodInSeconds())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("PeriodAlignment", periodAlignmentAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceType":
            return Optional.ofNullable(clazz.cast(serviceTypeAsString()));
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "MetricQueries":
            return Optional.ofNullable(clazz.cast(metricQueries()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "PeriodInSeconds":
            return Optional.ofNullable(clazz.cast(periodInSeconds()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "PeriodAlignment":
            return Optional.ofNullable(clazz.cast(periodAlignmentAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceMetricsRequest, T> g) {
        return obj -> g.apply((GetResourceMetricsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PiRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetResourceMetricsRequest> {
        /**
         * <p>
         * The Amazon Web Services service for which Performance Insights returns metrics. Valid values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RDS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DOCDB</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param serviceType
         *        The Amazon Web Services service for which Performance Insights returns metrics. Valid values are as
         *        follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RDS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DOCDB</code>
         *        </p>
         *        </li>
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder serviceType(String serviceType);

        /**
         * <p>
         * The Amazon Web Services service for which Performance Insights returns metrics. Valid values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RDS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DOCDB</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param serviceType
         *        The Amazon Web Services service for which Performance Insights returns metrics. Valid values are as
         *        follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RDS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DOCDB</code>
         *        </p>
         *        </li>
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder serviceType(ServiceType serviceType);

        /**
         * <p>
         * An immutable identifier for a data source that is unique for an Amazon Web Services Region. Performance
         * Insights gathers metrics from this data source. In the console, the identifier is shown as <i>ResourceID</i>.
         * When you call <code>DescribeDBInstances</code>, the identifier is returned as <code>DbiResourceId</code>.
         * </p>
         * <p>
         * To use a DB instance as a data source, specify its <code>DbiResourceId</code> value. For example, specify
         * <code>db-ABCDEFGHIJKLMNOPQRSTU1VW2X</code>.
         * </p>
         * 
         * @param identifier
         *        An immutable identifier for a data source that is unique for an Amazon Web Services Region.
         *        Performance Insights gathers metrics from this data source. In the console, the identifier is shown as
         *        <i>ResourceID</i>. When you call <code>DescribeDBInstances</code>, the identifier is returned as
         *        <code>DbiResourceId</code>.</p>
         *        <p>
         *        To use a DB instance as a data source, specify its <code>DbiResourceId</code> value. For example,
         *        specify <code>db-ABCDEFGHIJKLMNOPQRSTU1VW2X</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * An array of one or more queries to perform. Each query must specify a Performance Insights metric and specify
         * an aggregate function, and you can provide filtering criteria. You must append the aggregate function to the
         * metric. For example, to find the average for the metric <code>db.load</code> you must use
         * <code>db.load.avg</code>. Valid values for aggregate functions include <code>.avg</code>, <code>.min</code>,
         * <code>.max</code>, and <code>.sum</code>.
         * </p>
         * 
         * @param metricQueries
         *        An array of one or more queries to perform. Each query must specify a Performance Insights metric and
         *        specify an aggregate function, and you can provide filtering criteria. You must append the aggregate
         *        function to the metric. For example, to find the average for the metric <code>db.load</code> you must
         *        use <code>db.load.avg</code>. Valid values for aggregate functions include <code>.avg</code>,
         *        <code>.min</code>, <code>.max</code>, and <code>.sum</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricQueries(Collection<MetricQuery> metricQueries);

        /**
         * <p>
         * An array of one or more queries to perform. Each query must specify a Performance Insights metric and specify
         * an aggregate function, and you can provide filtering criteria. You must append the aggregate function to the
         * metric. For example, to find the average for the metric <code>db.load</code> you must use
         * <code>db.load.avg</code>. Valid values for aggregate functions include <code>.avg</code>, <code>.min</code>,
         * <code>.max</code>, and <code>.sum</code>.
         * </p>
         * 
         * @param metricQueries
         *        An array of one or more queries to perform. Each query must specify a Performance Insights metric and
         *        specify an aggregate function, and you can provide filtering criteria. You must append the aggregate
         *        function to the metric. For example, to find the average for the metric <code>db.load</code> you must
         *        use <code>db.load.avg</code>. Valid values for aggregate functions include <code>.avg</code>,
         *        <code>.min</code>, <code>.max</code>, and <code>.sum</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricQueries(MetricQuery... metricQueries);

        /**
         * <p>
         * An array of one or more queries to perform. Each query must specify a Performance Insights metric and specify
         * an aggregate function, and you can provide filtering criteria. You must append the aggregate function to the
         * metric. For example, to find the average for the metric <code>db.load</code> you must use
         * <code>db.load.avg</code>. Valid values for aggregate functions include <code>.avg</code>, <code>.min</code>,
         * <code>.max</code>, and <code>.sum</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pi.model.MetricQuery.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.pi.model.MetricQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pi.model.MetricQuery.Builder#build()} is called immediately and its
         * result is passed to {@link #metricQueries(List<MetricQuery>)}.
         * 
         * @param metricQueries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pi.model.MetricQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricQueries(java.util.Collection<MetricQuery>)
         */
        Builder metricQueries(Consumer<MetricQuery.Builder>... metricQueries);

        /**
         * <p>
         * The date and time specifying the beginning of the requested time series query range. You can't specify a
         * <code>StartTime</code> that is earlier than 7 days ago. By default, Performance Insights has 7 days of
         * retention, but you can extend this range up to 2 years. The value specified is <i>inclusive</i>. Thus, the
         * command returns data points equal to or greater than <code>StartTime</code>.
         * </p>
         * <p>
         * The value for <code>StartTime</code> must be earlier than the value for <code>EndTime</code>.
         * </p>
         * 
         * @param startTime
         *        The date and time specifying the beginning of the requested time series query range. You can't specify
         *        a <code>StartTime</code> that is earlier than 7 days ago. By default, Performance Insights has 7 days
         *        of retention, but you can extend this range up to 2 years. The value specified is <i>inclusive</i>.
         *        Thus, the command returns data points equal to or greater than <code>StartTime</code>.</p>
         *        <p>
         *        The value for <code>StartTime</code> must be earlier than the value for <code>EndTime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The date and time specifying the end of the requested time series query range. The value specified is
         * <i>exclusive</i>. Thus, the command returns data points less than (but not equal to) <code>EndTime</code>.
         * </p>
         * <p>
         * The value for <code>EndTime</code> must be later than the value for <code>StartTime</code>.
         * </p>
         * 
         * @param endTime
         *        The date and time specifying the end of the requested time series query range. The value specified is
         *        <i>exclusive</i>. Thus, the command returns data points less than (but not equal to)
         *        <code>EndTime</code>.</p>
         *        <p>
         *        The value for <code>EndTime</code> must be later than the value for <code>StartTime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The granularity, in seconds, of the data points returned from Performance Insights. A period can be as short
         * as one second, or as long as one day (86400 seconds). Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>1</code> (one second)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>60</code> (one minute)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>300</code> (five minutes)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>3600</code> (one hour)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>86400</code> (twenty-four hours)
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you don't specify <code>PeriodInSeconds</code>, then Performance Insights will choose a value for you,
         * with a goal of returning roughly 100-200 data points in the response.
         * </p>
         * 
         * @param periodInSeconds
         *        The granularity, in seconds, of the data points returned from Performance Insights. A period can be as
         *        short as one second, or as long as one day (86400 seconds). Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>1</code> (one second)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>60</code> (one minute)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>300</code> (five minutes)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>3600</code> (one hour)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>86400</code> (twenty-four hours)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you don't specify <code>PeriodInSeconds</code>, then Performance Insights will choose a value for
         *        you, with a goal of returning roughly 100-200 data points in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodInSeconds(Integer periodInSeconds);

        /**
         * <p>
         * The maximum number of items to return in the response. If more items exist than the specified
         * <code>MaxRecords</code> value, a pagination token is included in the response so that the remaining results
         * can be retrieved.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return in the response. If more items exist than the specified
         *        <code>MaxRecords</code> value, a pagination token is included in the response so that the remaining
         *        results can be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param nextToken
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The returned timestamp which is the start or end time of the time periods. The default value is
         * <code>END_TIME</code>.
         * </p>
         * 
         * @param periodAlignment
         *        The returned timestamp which is the start or end time of the time periods. The default value is
         *        <code>END_TIME</code>.
         * @see PeriodAlignment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PeriodAlignment
         */
        Builder periodAlignment(String periodAlignment);

        /**
         * <p>
         * The returned timestamp which is the start or end time of the time periods. The default value is
         * <code>END_TIME</code>.
         * </p>
         * 
         * @param periodAlignment
         *        The returned timestamp which is the start or end time of the time periods. The default value is
         *        <code>END_TIME</code>.
         * @see PeriodAlignment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PeriodAlignment
         */
        Builder periodAlignment(PeriodAlignment periodAlignment);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PiRequest.BuilderImpl implements Builder {
        private String serviceType;

        private String identifier;

        private List<MetricQuery> metricQueries = DefaultSdkAutoConstructList.getInstance();

        private Instant startTime;

        private Instant endTime;

        private Integer periodInSeconds;

        private Integer maxResults;

        private String nextToken;

        private String periodAlignment;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceMetricsRequest model) {
            super(model);
            serviceType(model.serviceType);
            identifier(model.identifier);
            metricQueries(model.metricQueries);
            startTime(model.startTime);
            endTime(model.endTime);
            periodInSeconds(model.periodInSeconds);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            periodAlignment(model.periodAlignment);
        }

        public final String getServiceType() {
            return serviceType;
        }

        public final void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        @Override
        public final Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @Override
        public final Builder serviceType(ServiceType serviceType) {
            this.serviceType(serviceType == null ? null : serviceType.toString());
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final List<MetricQuery.Builder> getMetricQueries() {
            List<MetricQuery.Builder> result = MetricQueryListCopier.copyToBuilder(this.metricQueries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricQueries(Collection<MetricQuery.BuilderImpl> metricQueries) {
            this.metricQueries = MetricQueryListCopier.copyFromBuilder(metricQueries);
        }

        @Override
        public final Builder metricQueries(Collection<MetricQuery> metricQueries) {
            this.metricQueries = MetricQueryListCopier.copy(metricQueries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricQueries(MetricQuery... metricQueries) {
            metricQueries(Arrays.asList(metricQueries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricQueries(Consumer<MetricQuery.Builder>... metricQueries) {
            metricQueries(Stream.of(metricQueries).map(c -> MetricQuery.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getPeriodInSeconds() {
            return periodInSeconds;
        }

        public final void setPeriodInSeconds(Integer periodInSeconds) {
            this.periodInSeconds = periodInSeconds;
        }

        @Override
        public final Builder periodInSeconds(Integer periodInSeconds) {
            this.periodInSeconds = periodInSeconds;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getPeriodAlignment() {
            return periodAlignment;
        }

        public final void setPeriodAlignment(String periodAlignment) {
            this.periodAlignment = periodAlignment;
        }

        @Override
        public final Builder periodAlignment(String periodAlignment) {
            this.periodAlignment = periodAlignment;
            return this;
        }

        @Override
        public final Builder periodAlignment(PeriodAlignment periodAlignment) {
            this.periodAlignment(periodAlignment == null ? null : periodAlignment.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourceMetricsRequest build() {
            return new GetResourceMetricsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
