/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pi;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.pi.model.CreatePerformanceAnalysisReportRequest;
import software.amazon.awssdk.services.pi.model.CreatePerformanceAnalysisReportResponse;
import software.amazon.awssdk.services.pi.model.DeletePerformanceAnalysisReportRequest;
import software.amazon.awssdk.services.pi.model.DeletePerformanceAnalysisReportResponse;
import software.amazon.awssdk.services.pi.model.DescribeDimensionKeysRequest;
import software.amazon.awssdk.services.pi.model.DescribeDimensionKeysResponse;
import software.amazon.awssdk.services.pi.model.GetDimensionKeyDetailsRequest;
import software.amazon.awssdk.services.pi.model.GetDimensionKeyDetailsResponse;
import software.amazon.awssdk.services.pi.model.GetPerformanceAnalysisReportRequest;
import software.amazon.awssdk.services.pi.model.GetPerformanceAnalysisReportResponse;
import software.amazon.awssdk.services.pi.model.GetResourceMetadataRequest;
import software.amazon.awssdk.services.pi.model.GetResourceMetadataResponse;
import software.amazon.awssdk.services.pi.model.GetResourceMetricsRequest;
import software.amazon.awssdk.services.pi.model.GetResourceMetricsResponse;
import software.amazon.awssdk.services.pi.model.ListAvailableResourceDimensionsRequest;
import software.amazon.awssdk.services.pi.model.ListAvailableResourceDimensionsResponse;
import software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsRequest;
import software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsResponse;
import software.amazon.awssdk.services.pi.model.ListPerformanceAnalysisReportsRequest;
import software.amazon.awssdk.services.pi.model.ListPerformanceAnalysisReportsResponse;
import software.amazon.awssdk.services.pi.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.pi.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.pi.model.TagResourceRequest;
import software.amazon.awssdk.services.pi.model.TagResourceResponse;
import software.amazon.awssdk.services.pi.model.UntagResourceRequest;
import software.amazon.awssdk.services.pi.model.UntagResourceResponse;
import software.amazon.awssdk.services.pi.paginators.DescribeDimensionKeysPublisher;
import software.amazon.awssdk.services.pi.paginators.GetResourceMetricsPublisher;
import software.amazon.awssdk.services.pi.paginators.ListAvailableResourceDimensionsPublisher;
import software.amazon.awssdk.services.pi.paginators.ListAvailableResourceMetricsPublisher;
import software.amazon.awssdk.services.pi.paginators.ListPerformanceAnalysisReportsPublisher;

/**
 * Service client for accessing AWS PI asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <fullname>Amazon RDS Performance Insights</fullname>
 * <p>
 * Amazon RDS Performance Insights enables you to monitor and explore different dimensions of database load based on
 * data captured from a running DB instance. The guide provides detailed information about Performance Insights data
 * types, parameters and errors.
 * </p>
 * <p>
 * When Performance Insights is enabled, the Amazon RDS Performance Insights API provides visibility into the
 * performance of your DB instance. Amazon CloudWatch provides the authoritative source for Amazon Web Services
 * service-vended monitoring metrics. Performance Insights offers a domain-specific view of DB load.
 * </p>
 * <p>
 * DB load is measured as average active sessions. Performance Insights provides the data to API consumers as a
 * two-dimensional time-series dataset. The time dimension provides DB load data for each time point in the queried time
 * range. Each time point decomposes overall load in relation to the requested dimensions, measured at that time point.
 * Examples include SQL, Wait event, User, and Host.
 * </p>
 * <ul>
 * <li>
 * <p>
 * To learn more about Performance Insights and Amazon Aurora DB instances, go to the <i> <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights.html"> Amazon Aurora User
 * Guide</a> </i>.
 * </p>
 * </li>
 * <li>
 * <p>
 * To learn more about Performance Insights and Amazon RDS DB instances, go to the <i> <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html"> Amazon RDS User Guide</a> </i>.
 * </p>
 * </li>
 * <li>
 * <p>
 * To learn more about Performance Insights and Amazon DocumentDB clusters, go to the <i> <a
 * href="https://docs.aws.amazon.com/documentdb/latest/developerguide/performance-insights.html"> Amazon DocumentDB
 * Developer Guide</a> </i>.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface PiAsyncClient extends AwsClient {
    String SERVICE_NAME = "pi";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "pi";

    /**
     * <p>
     * Creates a new performance analysis report for a specific time period for the DB instance.
     * </p>
     *
     * @param createPerformanceAnalysisReportRequest
     * @return A Java Future containing the result of the CreatePerformanceAnalysisReport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.CreatePerformanceAnalysisReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/CreatePerformanceAnalysisReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePerformanceAnalysisReportResponse> createPerformanceAnalysisReport(
            CreatePerformanceAnalysisReportRequest createPerformanceAnalysisReportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new performance analysis report for a specific time period for the DB instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePerformanceAnalysisReportRequest.Builder}
     * avoiding the need to create one manually via {@link CreatePerformanceAnalysisReportRequest#builder()}
     * </p>
     *
     * @param createPerformanceAnalysisReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pi.model.CreatePerformanceAnalysisReportRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreatePerformanceAnalysisReport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.CreatePerformanceAnalysisReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/CreatePerformanceAnalysisReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePerformanceAnalysisReportResponse> createPerformanceAnalysisReport(
            Consumer<CreatePerformanceAnalysisReportRequest.Builder> createPerformanceAnalysisReportRequest) {
        return createPerformanceAnalysisReport(CreatePerformanceAnalysisReportRequest.builder()
                .applyMutation(createPerformanceAnalysisReportRequest).build());
    }

    /**
     * <p>
     * Deletes a performance analysis report.
     * </p>
     *
     * @param deletePerformanceAnalysisReportRequest
     * @return A Java Future containing the result of the DeletePerformanceAnalysisReport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.DeletePerformanceAnalysisReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/DeletePerformanceAnalysisReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePerformanceAnalysisReportResponse> deletePerformanceAnalysisReport(
            DeletePerformanceAnalysisReportRequest deletePerformanceAnalysisReportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a performance analysis report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePerformanceAnalysisReportRequest.Builder}
     * avoiding the need to create one manually via {@link DeletePerformanceAnalysisReportRequest#builder()}
     * </p>
     *
     * @param deletePerformanceAnalysisReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pi.model.DeletePerformanceAnalysisReportRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeletePerformanceAnalysisReport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.DeletePerformanceAnalysisReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/DeletePerformanceAnalysisReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePerformanceAnalysisReportResponse> deletePerformanceAnalysisReport(
            Consumer<DeletePerformanceAnalysisReportRequest.Builder> deletePerformanceAnalysisReportRequest) {
        return deletePerformanceAnalysisReport(DeletePerformanceAnalysisReportRequest.builder()
                .applyMutation(deletePerformanceAnalysisReportRequest).build());
    }

    /**
     * <p>
     * For a specific time period, retrieve the top <code>N</code> dimension keys for a metric.
     * </p>
     * <note>
     * <p>
     * Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements, only the first
     * 500 bytes are returned.
     * </p>
     * </note>
     *
     * @param describeDimensionKeysRequest
     * @return A Java Future containing the result of the DescribeDimensionKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.DescribeDimensionKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/DescribeDimensionKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDimensionKeysResponse> describeDimensionKeys(
            DescribeDimensionKeysRequest describeDimensionKeysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For a specific time period, retrieve the top <code>N</code> dimension keys for a metric.
     * </p>
     * <note>
     * <p>
     * Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements, only the first
     * 500 bytes are returned.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDimensionKeysRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDimensionKeysRequest#builder()}
     * </p>
     *
     * @param describeDimensionKeysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pi.model.DescribeDimensionKeysRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeDimensionKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.DescribeDimensionKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/DescribeDimensionKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDimensionKeysResponse> describeDimensionKeys(
            Consumer<DescribeDimensionKeysRequest.Builder> describeDimensionKeysRequest) {
        return describeDimensionKeys(DescribeDimensionKeysRequest.builder().applyMutation(describeDimensionKeysRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDimensionKeys(software.amazon.awssdk.services.pi.model.DescribeDimensionKeysRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pi.paginators.DescribeDimensionKeysPublisher publisher = client.describeDimensionKeysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pi.paginators.DescribeDimensionKeysPublisher publisher = client.describeDimensionKeysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pi.model.DescribeDimensionKeysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pi.model.DescribeDimensionKeysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDimensionKeys(software.amazon.awssdk.services.pi.model.DescribeDimensionKeysRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDimensionKeysRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.DescribeDimensionKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/DescribeDimensionKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDimensionKeysPublisher describeDimensionKeysPaginator(
            DescribeDimensionKeysRequest describeDimensionKeysRequest) {
        return new DescribeDimensionKeysPublisher(this, describeDimensionKeysRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDimensionKeys(software.amazon.awssdk.services.pi.model.DescribeDimensionKeysRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pi.paginators.DescribeDimensionKeysPublisher publisher = client.describeDimensionKeysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pi.paginators.DescribeDimensionKeysPublisher publisher = client.describeDimensionKeysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pi.model.DescribeDimensionKeysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pi.model.DescribeDimensionKeysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDimensionKeys(software.amazon.awssdk.services.pi.model.DescribeDimensionKeysRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDimensionKeysRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDimensionKeysRequest#builder()}
     * </p>
     *
     * @param describeDimensionKeysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pi.model.DescribeDimensionKeysRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.DescribeDimensionKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/DescribeDimensionKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDimensionKeysPublisher describeDimensionKeysPaginator(
            Consumer<DescribeDimensionKeysRequest.Builder> describeDimensionKeysRequest) {
        return describeDimensionKeysPaginator(DescribeDimensionKeysRequest.builder().applyMutation(describeDimensionKeysRequest)
                .build());
    }

    /**
     * <p>
     * Get the attributes of the specified dimension group for a DB instance or data source. For example, if you specify
     * a SQL ID, <code>GetDimensionKeyDetails</code> retrieves the full text of the dimension
     * <code>db.sql.statement</code> associated with this ID. This operation is useful because
     * <code>GetResourceMetrics</code> and <code>DescribeDimensionKeys</code> don't support retrieval of large SQL
     * statement text.
     * </p>
     *
     * @param getDimensionKeyDetailsRequest
     * @return A Java Future containing the result of the GetDimensionKeyDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.GetDimensionKeyDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/GetDimensionKeyDetails" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDimensionKeyDetailsResponse> getDimensionKeyDetails(
            GetDimensionKeyDetailsRequest getDimensionKeyDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the attributes of the specified dimension group for a DB instance or data source. For example, if you specify
     * a SQL ID, <code>GetDimensionKeyDetails</code> retrieves the full text of the dimension
     * <code>db.sql.statement</code> associated with this ID. This operation is useful because
     * <code>GetResourceMetrics</code> and <code>DescribeDimensionKeys</code> don't support retrieval of large SQL
     * statement text.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDimensionKeyDetailsRequest.Builder} avoiding the
     * need to create one manually via {@link GetDimensionKeyDetailsRequest#builder()}
     * </p>
     *
     * @param getDimensionKeyDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pi.model.GetDimensionKeyDetailsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDimensionKeyDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.GetDimensionKeyDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/GetDimensionKeyDetails" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDimensionKeyDetailsResponse> getDimensionKeyDetails(
            Consumer<GetDimensionKeyDetailsRequest.Builder> getDimensionKeyDetailsRequest) {
        return getDimensionKeyDetails(GetDimensionKeyDetailsRequest.builder().applyMutation(getDimensionKeyDetailsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the report including the report ID, status, time details, and the insights with recommendations. The
     * report status can be <code>RUNNING</code>, <code>SUCCEEDED</code>, or <code>FAILED</code>. The insights include
     * the <code>description</code> and <code>recommendation</code> fields.
     * </p>
     *
     * @param getPerformanceAnalysisReportRequest
     * @return A Java Future containing the result of the GetPerformanceAnalysisReport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.GetPerformanceAnalysisReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/GetPerformanceAnalysisReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPerformanceAnalysisReportResponse> getPerformanceAnalysisReport(
            GetPerformanceAnalysisReportRequest getPerformanceAnalysisReportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the report including the report ID, status, time details, and the insights with recommendations. The
     * report status can be <code>RUNNING</code>, <code>SUCCEEDED</code>, or <code>FAILED</code>. The insights include
     * the <code>description</code> and <code>recommendation</code> fields.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPerformanceAnalysisReportRequest.Builder}
     * avoiding the need to create one manually via {@link GetPerformanceAnalysisReportRequest#builder()}
     * </p>
     *
     * @param getPerformanceAnalysisReportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pi.model.GetPerformanceAnalysisReportRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetPerformanceAnalysisReport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.GetPerformanceAnalysisReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/GetPerformanceAnalysisReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPerformanceAnalysisReportResponse> getPerformanceAnalysisReport(
            Consumer<GetPerformanceAnalysisReportRequest.Builder> getPerformanceAnalysisReportRequest) {
        return getPerformanceAnalysisReport(GetPerformanceAnalysisReportRequest.builder()
                .applyMutation(getPerformanceAnalysisReportRequest).build());
    }

    /**
     * <p>
     * Retrieve the metadata for different features. For example, the metadata might indicate that a feature is turned
     * on or off on a specific DB instance.
     * </p>
     *
     * @param getResourceMetadataRequest
     * @return A Java Future containing the result of the GetResourceMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.GetResourceMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/GetResourceMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetResourceMetadataResponse> getResourceMetadata(
            GetResourceMetadataRequest getResourceMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve the metadata for different features. For example, the metadata might indicate that a feature is turned
     * on or off on a specific DB instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourceMetadataRequest#builder()}
     * </p>
     *
     * @param getResourceMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pi.model.GetResourceMetadataRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetResourceMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.GetResourceMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/GetResourceMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetResourceMetadataResponse> getResourceMetadata(
            Consumer<GetResourceMetadataRequest.Builder> getResourceMetadataRequest) {
        return getResourceMetadata(GetResourceMetadataRequest.builder().applyMutation(getResourceMetadataRequest).build());
    }

    /**
     * <p>
     * Retrieve Performance Insights metrics for a set of data sources over a time period. You can provide specific
     * dimension groups and dimensions, and provide filtering criteria for each group. You must specify an aggregate
     * function for each metric.
     * </p>
     * <note>
     * <p>
     * Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements, only the first
     * 500 bytes are returned.
     * </p>
     * </note>
     *
     * @param getResourceMetricsRequest
     * @return A Java Future containing the result of the GetResourceMetrics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.GetResourceMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/GetResourceMetrics" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetResourceMetricsResponse> getResourceMetrics(GetResourceMetricsRequest getResourceMetricsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve Performance Insights metrics for a set of data sources over a time period. You can provide specific
     * dimension groups and dimensions, and provide filtering criteria for each group. You must specify an aggregate
     * function for each metric.
     * </p>
     * <note>
     * <p>
     * Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements, only the first
     * 500 bytes are returned.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceMetricsRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourceMetricsRequest#builder()}
     * </p>
     *
     * @param getResourceMetricsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pi.model.GetResourceMetricsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetResourceMetrics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.GetResourceMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/GetResourceMetrics" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetResourceMetricsResponse> getResourceMetrics(
            Consumer<GetResourceMetricsRequest.Builder> getResourceMetricsRequest) {
        return getResourceMetrics(GetResourceMetricsRequest.builder().applyMutation(getResourceMetricsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getResourceMetrics(software.amazon.awssdk.services.pi.model.GetResourceMetricsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pi.paginators.GetResourceMetricsPublisher publisher = client.getResourceMetricsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pi.paginators.GetResourceMetricsPublisher publisher = client.getResourceMetricsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pi.model.GetResourceMetricsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pi.model.GetResourceMetricsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceMetrics(software.amazon.awssdk.services.pi.model.GetResourceMetricsRequest)} operation.</b>
     * </p>
     *
     * @param getResourceMetricsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.GetResourceMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/GetResourceMetrics" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourceMetricsPublisher getResourceMetricsPaginator(GetResourceMetricsRequest getResourceMetricsRequest) {
        return new GetResourceMetricsPublisher(this, getResourceMetricsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getResourceMetrics(software.amazon.awssdk.services.pi.model.GetResourceMetricsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pi.paginators.GetResourceMetricsPublisher publisher = client.getResourceMetricsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pi.paginators.GetResourceMetricsPublisher publisher = client.getResourceMetricsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pi.model.GetResourceMetricsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pi.model.GetResourceMetricsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourceMetrics(software.amazon.awssdk.services.pi.model.GetResourceMetricsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceMetricsRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourceMetricsRequest#builder()}
     * </p>
     *
     * @param getResourceMetricsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pi.model.GetResourceMetricsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.GetResourceMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/GetResourceMetrics" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourceMetricsPublisher getResourceMetricsPaginator(
            Consumer<GetResourceMetricsRequest.Builder> getResourceMetricsRequest) {
        return getResourceMetricsPaginator(GetResourceMetricsRequest.builder().applyMutation(getResourceMetricsRequest).build());
    }

    /**
     * <p>
     * Retrieve the dimensions that can be queried for each specified metric type on a specified DB instance.
     * </p>
     *
     * @param listAvailableResourceDimensionsRequest
     * @return A Java Future containing the result of the ListAvailableResourceDimensions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.ListAvailableResourceDimensions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/ListAvailableResourceDimensions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAvailableResourceDimensionsResponse> listAvailableResourceDimensions(
            ListAvailableResourceDimensionsRequest listAvailableResourceDimensionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve the dimensions that can be queried for each specified metric type on a specified DB instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAvailableResourceDimensionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAvailableResourceDimensionsRequest#builder()}
     * </p>
     *
     * @param listAvailableResourceDimensionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pi.model.ListAvailableResourceDimensionsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListAvailableResourceDimensions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.ListAvailableResourceDimensions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/ListAvailableResourceDimensions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAvailableResourceDimensionsResponse> listAvailableResourceDimensions(
            Consumer<ListAvailableResourceDimensionsRequest.Builder> listAvailableResourceDimensionsRequest) {
        return listAvailableResourceDimensions(ListAvailableResourceDimensionsRequest.builder()
                .applyMutation(listAvailableResourceDimensionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAvailableResourceDimensions(software.amazon.awssdk.services.pi.model.ListAvailableResourceDimensionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pi.paginators.ListAvailableResourceDimensionsPublisher publisher = client.listAvailableResourceDimensionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pi.paginators.ListAvailableResourceDimensionsPublisher publisher = client.listAvailableResourceDimensionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pi.model.ListAvailableResourceDimensionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pi.model.ListAvailableResourceDimensionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAvailableResourceDimensions(software.amazon.awssdk.services.pi.model.ListAvailableResourceDimensionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAvailableResourceDimensionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.ListAvailableResourceDimensions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/ListAvailableResourceDimensions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAvailableResourceDimensionsPublisher listAvailableResourceDimensionsPaginator(
            ListAvailableResourceDimensionsRequest listAvailableResourceDimensionsRequest) {
        return new ListAvailableResourceDimensionsPublisher(this, listAvailableResourceDimensionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAvailableResourceDimensions(software.amazon.awssdk.services.pi.model.ListAvailableResourceDimensionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pi.paginators.ListAvailableResourceDimensionsPublisher publisher = client.listAvailableResourceDimensionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pi.paginators.ListAvailableResourceDimensionsPublisher publisher = client.listAvailableResourceDimensionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pi.model.ListAvailableResourceDimensionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pi.model.ListAvailableResourceDimensionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAvailableResourceDimensions(software.amazon.awssdk.services.pi.model.ListAvailableResourceDimensionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAvailableResourceDimensionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAvailableResourceDimensionsRequest#builder()}
     * </p>
     *
     * @param listAvailableResourceDimensionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pi.model.ListAvailableResourceDimensionsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.ListAvailableResourceDimensions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/ListAvailableResourceDimensions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAvailableResourceDimensionsPublisher listAvailableResourceDimensionsPaginator(
            Consumer<ListAvailableResourceDimensionsRequest.Builder> listAvailableResourceDimensionsRequest) {
        return listAvailableResourceDimensionsPaginator(ListAvailableResourceDimensionsRequest.builder()
                .applyMutation(listAvailableResourceDimensionsRequest).build());
    }

    /**
     * <p>
     * Retrieve metrics of the specified types that can be queried for a specified DB instance.
     * </p>
     *
     * @param listAvailableResourceMetricsRequest
     * @return A Java Future containing the result of the ListAvailableResourceMetrics operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.ListAvailableResourceMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/ListAvailableResourceMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAvailableResourceMetricsResponse> listAvailableResourceMetrics(
            ListAvailableResourceMetricsRequest listAvailableResourceMetricsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve metrics of the specified types that can be queried for a specified DB instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAvailableResourceMetricsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAvailableResourceMetricsRequest#builder()}
     * </p>
     *
     * @param listAvailableResourceMetricsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAvailableResourceMetrics operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.ListAvailableResourceMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/ListAvailableResourceMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAvailableResourceMetricsResponse> listAvailableResourceMetrics(
            Consumer<ListAvailableResourceMetricsRequest.Builder> listAvailableResourceMetricsRequest) {
        return listAvailableResourceMetrics(ListAvailableResourceMetricsRequest.builder()
                .applyMutation(listAvailableResourceMetricsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAvailableResourceMetrics(software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pi.paginators.ListAvailableResourceMetricsPublisher publisher = client.listAvailableResourceMetricsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pi.paginators.ListAvailableResourceMetricsPublisher publisher = client.listAvailableResourceMetricsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAvailableResourceMetrics(software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAvailableResourceMetricsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.ListAvailableResourceMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/ListAvailableResourceMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAvailableResourceMetricsPublisher listAvailableResourceMetricsPaginator(
            ListAvailableResourceMetricsRequest listAvailableResourceMetricsRequest) {
        return new ListAvailableResourceMetricsPublisher(this, listAvailableResourceMetricsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAvailableResourceMetrics(software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pi.paginators.ListAvailableResourceMetricsPublisher publisher = client.listAvailableResourceMetricsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pi.paginators.ListAvailableResourceMetricsPublisher publisher = client.listAvailableResourceMetricsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAvailableResourceMetrics(software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAvailableResourceMetricsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAvailableResourceMetricsRequest#builder()}
     * </p>
     *
     * @param listAvailableResourceMetricsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pi.model.ListAvailableResourceMetricsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.ListAvailableResourceMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/ListAvailableResourceMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAvailableResourceMetricsPublisher listAvailableResourceMetricsPaginator(
            Consumer<ListAvailableResourceMetricsRequest.Builder> listAvailableResourceMetricsRequest) {
        return listAvailableResourceMetricsPaginator(ListAvailableResourceMetricsRequest.builder()
                .applyMutation(listAvailableResourceMetricsRequest).build());
    }

    /**
     * <p>
     * Lists all the analysis reports created for the DB instance. The reports are sorted based on the start time of
     * each report.
     * </p>
     *
     * @param listPerformanceAnalysisReportsRequest
     * @return A Java Future containing the result of the ListPerformanceAnalysisReports operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.ListPerformanceAnalysisReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/ListPerformanceAnalysisReports"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPerformanceAnalysisReportsResponse> listPerformanceAnalysisReports(
            ListPerformanceAnalysisReportsRequest listPerformanceAnalysisReportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the analysis reports created for the DB instance. The reports are sorted based on the start time of
     * each report.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPerformanceAnalysisReportsRequest.Builder}
     * avoiding the need to create one manually via {@link ListPerformanceAnalysisReportsRequest#builder()}
     * </p>
     *
     * @param listPerformanceAnalysisReportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pi.model.ListPerformanceAnalysisReportsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPerformanceAnalysisReports operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.ListPerformanceAnalysisReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/ListPerformanceAnalysisReports"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPerformanceAnalysisReportsResponse> listPerformanceAnalysisReports(
            Consumer<ListPerformanceAnalysisReportsRequest.Builder> listPerformanceAnalysisReportsRequest) {
        return listPerformanceAnalysisReports(ListPerformanceAnalysisReportsRequest.builder()
                .applyMutation(listPerformanceAnalysisReportsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPerformanceAnalysisReports(software.amazon.awssdk.services.pi.model.ListPerformanceAnalysisReportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pi.paginators.ListPerformanceAnalysisReportsPublisher publisher = client.listPerformanceAnalysisReportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pi.paginators.ListPerformanceAnalysisReportsPublisher publisher = client.listPerformanceAnalysisReportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pi.model.ListPerformanceAnalysisReportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pi.model.ListPerformanceAnalysisReportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPerformanceAnalysisReports(software.amazon.awssdk.services.pi.model.ListPerformanceAnalysisReportsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPerformanceAnalysisReportsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.ListPerformanceAnalysisReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/ListPerformanceAnalysisReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPerformanceAnalysisReportsPublisher listPerformanceAnalysisReportsPaginator(
            ListPerformanceAnalysisReportsRequest listPerformanceAnalysisReportsRequest) {
        return new ListPerformanceAnalysisReportsPublisher(this, listPerformanceAnalysisReportsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPerformanceAnalysisReports(software.amazon.awssdk.services.pi.model.ListPerformanceAnalysisReportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pi.paginators.ListPerformanceAnalysisReportsPublisher publisher = client.listPerformanceAnalysisReportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.pi.paginators.ListPerformanceAnalysisReportsPublisher publisher = client.listPerformanceAnalysisReportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.pi.model.ListPerformanceAnalysisReportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.pi.model.ListPerformanceAnalysisReportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPerformanceAnalysisReports(software.amazon.awssdk.services.pi.model.ListPerformanceAnalysisReportsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPerformanceAnalysisReportsRequest.Builder}
     * avoiding the need to create one manually via {@link ListPerformanceAnalysisReportsRequest#builder()}
     * </p>
     *
     * @param listPerformanceAnalysisReportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pi.model.ListPerformanceAnalysisReportsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.ListPerformanceAnalysisReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/ListPerformanceAnalysisReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPerformanceAnalysisReportsPublisher listPerformanceAnalysisReportsPaginator(
            Consumer<ListPerformanceAnalysisReportsRequest.Builder> listPerformanceAnalysisReportsRequest) {
        return listPerformanceAnalysisReportsPaginator(ListPerformanceAnalysisReportsRequest.builder()
                .applyMutation(listPerformanceAnalysisReportsRequest).build());
    }

    /**
     * <p>
     * Retrieves all the metadata tags associated with Amazon RDS Performance Insights resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all the metadata tags associated with Amazon RDS Performance Insights resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pi.model.ListTagsForResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds metadata tags to the Amazon RDS Performance Insights resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds metadata tags to the Amazon RDS Performance Insights resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pi.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Deletes the metadata tags from the Amazon RDS Performance Insights resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the metadata tags from the Amazon RDS Performance Insights resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.pi.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidArgumentException One of the arguments provided is invalid for this request.</li>
     *         <li>InternalServiceErrorException The request failed due to an unknown error.</li>
     *         <li>NotAuthorizedException The user is not authorized to perform this request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PiException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample PiAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pi-2018-02-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    @Override
    default PiServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link PiAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static PiAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link PiAsyncClient}.
     */
    static PiAsyncClientBuilder builder() {
        return new DefaultPiAsyncClientBuilder();
    }
}
