/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This data type helps to determine Performance Insights metric to render for the insight.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PerformanceInsightsMetric implements SdkPojo, Serializable,
        ToCopyableBuilder<PerformanceInsightsMetric.Builder, PerformanceInsightsMetric> {
    private static final SdkField<String> METRIC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Metric")
            .getter(getter(PerformanceInsightsMetric::metric)).setter(setter(Builder::metric))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(PerformanceInsightsMetric::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<Map<String, String>> DIMENSIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Dimensions")
            .getter(getter(PerformanceInsightsMetric::dimensions))
            .setter(setter(Builder::dimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Double> VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Value")
            .getter(getter(PerformanceInsightsMetric::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_FIELD,
            DISPLAY_NAME_FIELD, DIMENSIONS_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String metric;

    private final String displayName;

    private final Map<String, String> dimensions;

    private final Double value;

    private PerformanceInsightsMetric(BuilderImpl builder) {
        this.metric = builder.metric;
        this.displayName = builder.displayName;
        this.dimensions = builder.dimensions;
        this.value = builder.value;
    }

    /**
     * <p>
     * The Performance Insights metric.
     * </p>
     * 
     * @return The Performance Insights metric.
     */
    public final String metric() {
        return metric;
    }

    /**
     * <p>
     * The Performance Insights metric name.
     * </p>
     * 
     * @return The Performance Insights metric name.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Dimensions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDimensions() {
        return dimensions != null && !(dimensions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A dimension map that contains the dimensions for this partition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensions} method.
     * </p>
     * 
     * @return A dimension map that contains the dimensions for this partition.
     */
    public final Map<String, String> dimensions() {
        return dimensions;
    }

    /**
     * <p>
     * The value of the metric. For example, <code>9</code> for <code>db.load.avg</code>.
     * </p>
     * 
     * @return The value of the metric. For example, <code>9</code> for <code>db.load.avg</code>.
     */
    public final Double value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metric());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensions() ? dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PerformanceInsightsMetric)) {
            return false;
        }
        PerformanceInsightsMetric other = (PerformanceInsightsMetric) obj;
        return Objects.equals(metric(), other.metric()) && Objects.equals(displayName(), other.displayName())
                && hasDimensions() == other.hasDimensions() && Objects.equals(dimensions(), other.dimensions())
                && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PerformanceInsightsMetric").add("Metric", metric()).add("DisplayName", displayName())
                .add("Dimensions", hasDimensions() ? dimensions() : null).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Metric":
            return Optional.ofNullable(clazz.cast(metric()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "Dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Metric", METRIC_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("Dimensions", DIMENSIONS_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PerformanceInsightsMetric, T> g) {
        return obj -> g.apply((PerformanceInsightsMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PerformanceInsightsMetric> {
        /**
         * <p>
         * The Performance Insights metric.
         * </p>
         * 
         * @param metric
         *        The Performance Insights metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metric(String metric);

        /**
         * <p>
         * The Performance Insights metric name.
         * </p>
         * 
         * @param displayName
         *        The Performance Insights metric name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * A dimension map that contains the dimensions for this partition.
         * </p>
         * 
         * @param dimensions
         *        A dimension map that contains the dimensions for this partition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Map<String, String> dimensions);

        /**
         * <p>
         * The value of the metric. For example, <code>9</code> for <code>db.load.avg</code>.
         * </p>
         * 
         * @param value
         *        The value of the metric. For example, <code>9</code> for <code>db.load.avg</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Double value);
    }

    static final class BuilderImpl implements Builder {
        private String metric;

        private String displayName;

        private Map<String, String> dimensions = DefaultSdkAutoConstructMap.getInstance();

        private Double value;

        private BuilderImpl() {
        }

        private BuilderImpl(PerformanceInsightsMetric model) {
            metric(model.metric);
            displayName(model.displayName);
            dimensions(model.dimensions);
            value(model.value);
        }

        public final String getMetric() {
            return metric;
        }

        public final void setMetric(String metric) {
            this.metric = metric;
        }

        @Override
        public final Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Map<String, String> getDimensions() {
            if (dimensions instanceof SdkAutoConstructMap) {
                return null;
            }
            return dimensions;
        }

        public final void setDimensions(Map<String, String> dimensions) {
            this.dimensions = DescriptiveMapCopier.copy(dimensions);
        }

        @Override
        public final Builder dimensions(Map<String, String> dimensions) {
            this.dimensions = DescriptiveMapCopier.copy(dimensions);
            return this;
        }

        public final Double getValue() {
            return value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        @Override
        public PerformanceInsightsMetric build() {
            return new PerformanceInsightsMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
