/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * List of data objects which provide details about source metrics. This field can be used to determine the PI metric to
 * render for the insight. This data type also includes static values for the metrics for the Insight that were
 * calculated and included in text and annotations on the DB load chart.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Data implements SdkPojo, Serializable, ToCopyableBuilder<Data.Builder, Data> {
    private static final SdkField<PerformanceInsightsMetric> PERFORMANCE_INSIGHTS_METRIC_FIELD = SdkField
            .<PerformanceInsightsMetric> builder(MarshallingType.SDK_POJO).memberName("PerformanceInsightsMetric")
            .getter(getter(Data::performanceInsightsMetric)).setter(setter(Builder::performanceInsightsMetric))
            .constructor(PerformanceInsightsMetric::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsMetric").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PERFORMANCE_INSIGHTS_METRIC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final PerformanceInsightsMetric performanceInsightsMetric;

    private Data(BuilderImpl builder) {
        this.performanceInsightsMetric = builder.performanceInsightsMetric;
    }

    /**
     * <p>
     * This field determines the Performance Insights metric to render for the insight. The <code>name</code> field
     * refers to a Performance Insights metric.
     * </p>
     * 
     * @return This field determines the Performance Insights metric to render for the insight. The <code>name</code>
     *         field refers to a Performance Insights metric.
     */
    public final PerformanceInsightsMetric performanceInsightsMetric() {
        return performanceInsightsMetric;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(performanceInsightsMetric());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Data)) {
            return false;
        }
        Data other = (Data) obj;
        return Objects.equals(performanceInsightsMetric(), other.performanceInsightsMetric());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Data").add("PerformanceInsightsMetric", performanceInsightsMetric()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PerformanceInsightsMetric":
            return Optional.ofNullable(clazz.cast(performanceInsightsMetric()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PerformanceInsightsMetric", PERFORMANCE_INSIGHTS_METRIC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Data, T> g) {
        return obj -> g.apply((Data) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Data> {
        /**
         * <p>
         * This field determines the Performance Insights metric to render for the insight. The <code>name</code> field
         * refers to a Performance Insights metric.
         * </p>
         * 
         * @param performanceInsightsMetric
         *        This field determines the Performance Insights metric to render for the insight. The <code>name</code>
         *        field refers to a Performance Insights metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceInsightsMetric(PerformanceInsightsMetric performanceInsightsMetric);

        /**
         * <p>
         * This field determines the Performance Insights metric to render for the insight. The <code>name</code> field
         * refers to a Performance Insights metric.
         * </p>
         * This is a convenience method that creates an instance of the {@link PerformanceInsightsMetric.Builder}
         * avoiding the need to create one manually via {@link PerformanceInsightsMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PerformanceInsightsMetric.Builder#build()} is called immediately
         * and its result is passed to {@link #performanceInsightsMetric(PerformanceInsightsMetric)}.
         * 
         * @param performanceInsightsMetric
         *        a consumer that will call methods on {@link PerformanceInsightsMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #performanceInsightsMetric(PerformanceInsightsMetric)
         */
        default Builder performanceInsightsMetric(Consumer<PerformanceInsightsMetric.Builder> performanceInsightsMetric) {
            return performanceInsightsMetric(PerformanceInsightsMetric.builder().applyMutation(performanceInsightsMetric).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PerformanceInsightsMetric performanceInsightsMetric;

        private BuilderImpl() {
        }

        private BuilderImpl(Data model) {
            performanceInsightsMetric(model.performanceInsightsMetric);
        }

        public final PerformanceInsightsMetric.Builder getPerformanceInsightsMetric() {
            return performanceInsightsMetric != null ? performanceInsightsMetric.toBuilder() : null;
        }

        public final void setPerformanceInsightsMetric(PerformanceInsightsMetric.BuilderImpl performanceInsightsMetric) {
            this.performanceInsightsMetric = performanceInsightsMetric != null ? performanceInsightsMetric.build() : null;
        }

        @Override
        public final Builder performanceInsightsMetric(PerformanceInsightsMetric performanceInsightsMetric) {
            this.performanceInsightsMetric = performanceInsightsMetric;
            return this;
        }

        @Override
        public Data build() {
            return new Data(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
