/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about dimensions within a dimension group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DimensionGroupDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<DimensionGroupDetail.Builder, DimensionGroupDetail> {
    private static final SdkField<String> GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Group")
            .getter(getter(DimensionGroupDetail::group)).setter(setter(Builder::group))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").build()).build();

    private static final SdkField<List<DimensionDetail>> DIMENSIONS_FIELD = SdkField
            .<List<DimensionDetail>> builder(MarshallingType.LIST)
            .memberName("Dimensions")
            .getter(getter(DimensionGroupDetail::dimensions))
            .setter(setter(Builder::dimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(GROUP_FIELD, DIMENSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String group;

    private final List<DimensionDetail> dimensions;

    private DimensionGroupDetail(BuilderImpl builder) {
        this.group = builder.group;
        this.dimensions = builder.dimensions;
    }

    /**
     * <p>
     * The name of the dimension group.
     * </p>
     * 
     * @return The name of the dimension group.
     */
    public final String group() {
        return group;
    }

    /**
     * For responses, this returns true if the service returned a value for the Dimensions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDimensions() {
        return dimensions != null && !(dimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The dimensions within a dimension group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensions} method.
     * </p>
     * 
     * @return The dimensions within a dimension group.
     */
    public final List<DimensionDetail> dimensions() {
        return dimensions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(group());
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensions() ? dimensions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DimensionGroupDetail)) {
            return false;
        }
        DimensionGroupDetail other = (DimensionGroupDetail) obj;
        return Objects.equals(group(), other.group()) && hasDimensions() == other.hasDimensions()
                && Objects.equals(dimensions(), other.dimensions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DimensionGroupDetail").add("Group", group())
                .add("Dimensions", hasDimensions() ? dimensions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Group":
            return Optional.ofNullable(clazz.cast(group()));
        case "Dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Group", GROUP_FIELD);
        map.put("Dimensions", DIMENSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DimensionGroupDetail, T> g) {
        return obj -> g.apply((DimensionGroupDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DimensionGroupDetail> {
        /**
         * <p>
         * The name of the dimension group.
         * </p>
         * 
         * @param group
         *        The name of the dimension group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(String group);

        /**
         * <p>
         * The dimensions within a dimension group.
         * </p>
         * 
         * @param dimensions
         *        The dimensions within a dimension group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Collection<DimensionDetail> dimensions);

        /**
         * <p>
         * The dimensions within a dimension group.
         * </p>
         * 
         * @param dimensions
         *        The dimensions within a dimension group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(DimensionDetail... dimensions);

        /**
         * <p>
         * The dimensions within a dimension group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pi.model.DimensionDetail.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.pi.model.DimensionDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pi.model.DimensionDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #dimensions(List<DimensionDetail>)}.
         * 
         * @param dimensions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pi.model.DimensionDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensions(java.util.Collection<DimensionDetail>)
         */
        Builder dimensions(Consumer<DimensionDetail.Builder>... dimensions);
    }

    static final class BuilderImpl implements Builder {
        private String group;

        private List<DimensionDetail> dimensions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DimensionGroupDetail model) {
            group(model.group);
            dimensions(model.dimensions);
        }

        public final String getGroup() {
            return group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final List<DimensionDetail.Builder> getDimensions() {
            List<DimensionDetail.Builder> result = DimensionDetailListCopier.copyToBuilder(this.dimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensions(Collection<DimensionDetail.BuilderImpl> dimensions) {
            this.dimensions = DimensionDetailListCopier.copyFromBuilder(dimensions);
        }

        @Override
        public final Builder dimensions(Collection<DimensionDetail> dimensions) {
            this.dimensions = DimensionDetailListCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(DimensionDetail... dimensions) {
            dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<DimensionDetail.Builder>... dimensions) {
            dimensions(Stream.of(dimensions).map(c -> DimensionDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DimensionGroupDetail build() {
            return new DimensionGroupDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
