/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAvailableResourceDimensionsRequest extends PiRequest implements
        ToCopyableBuilder<ListAvailableResourceDimensionsRequest.Builder, ListAvailableResourceDimensionsRequest> {
    private static final SdkField<String> SERVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceType").getter(getter(ListAvailableResourceDimensionsRequest::serviceTypeAsString))
            .setter(setter(Builder::serviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceType").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(ListAvailableResourceDimensionsRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<List<String>> METRICS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Metrics")
            .getter(getter(ListAvailableResourceDimensionsRequest::metrics))
            .setter(setter(Builder::metrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListAvailableResourceDimensionsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAvailableResourceDimensionsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<String>> AUTHORIZED_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AuthorizedActions")
            .getter(getter(ListAvailableResourceDimensionsRequest::authorizedActionsAsStrings))
            .setter(setter(Builder::authorizedActionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_TYPE_FIELD,
            IDENTIFIER_FIELD, METRICS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, AUTHORIZED_ACTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String serviceType;

    private final String identifier;

    private final List<String> metrics;

    private final Integer maxResults;

    private final String nextToken;

    private final List<String> authorizedActions;

    private ListAvailableResourceDimensionsRequest(BuilderImpl builder) {
        super(builder);
        this.serviceType = builder.serviceType;
        this.identifier = builder.identifier;
        this.metrics = builder.metrics;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.authorizedActions = builder.authorizedActions;
    }

    /**
     * <p>
     * The Amazon Web Services service for which Performance Insights returns metrics.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceType} will
     * return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceTypeAsString}.
     * </p>
     * 
     * @return The Amazon Web Services service for which Performance Insights returns metrics.
     * @see ServiceType
     */
    public final ServiceType serviceType() {
        return ServiceType.fromValue(serviceType);
    }

    /**
     * <p>
     * The Amazon Web Services service for which Performance Insights returns metrics.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceType} will
     * return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceTypeAsString}.
     * </p>
     * 
     * @return The Amazon Web Services service for which Performance Insights returns metrics.
     * @see ServiceType
     */
    public final String serviceTypeAsString() {
        return serviceType;
    }

    /**
     * <p>
     * An immutable identifier for a data source that is unique within an Amazon Web Services Region. Performance
     * Insights gathers metrics from this data source. To use an Amazon RDS DB instance as a data source, specify its
     * <code>DbiResourceId</code> value. For example, specify <code>db-ABCDEFGHIJKLMNOPQRSTU1VWZ</code>.
     * </p>
     * 
     * @return An immutable identifier for a data source that is unique within an Amazon Web Services Region.
     *         Performance Insights gathers metrics from this data source. To use an Amazon RDS DB instance as a data
     *         source, specify its <code>DbiResourceId</code> value. For example, specify
     *         <code>db-ABCDEFGHIJKLMNOPQRSTU1VWZ</code>.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metrics property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetrics() {
        return metrics != null && !(metrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The types of metrics for which to retrieve dimensions. Valid values include <code>db.load</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetrics} method.
     * </p>
     * 
     * @return The types of metrics for which to retrieve dimensions. Valid values include <code>db.load</code>.
     */
    public final List<String> metrics() {
        return metrics;
    }

    /**
     * <p>
     * The maximum number of items to return in the response. If more items exist than the specified
     * <code>MaxRecords</code> value, a pagination token is included in the response so that the remaining results can
     * be retrieved.
     * </p>
     * 
     * @return The maximum number of items to return in the response. If more items exist than the specified
     *         <code>MaxRecords</code> value, a pagination token is included in the response so that the remaining
     *         results can be retrieved.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The actions to discover the dimensions you are authorized to access. If you specify multiple actions, then the
     * response will contain the dimensions common for all the actions.
     * </p>
     * <p>
     * When you don't specify this request parameter or provide an empty list, the response contains all the available
     * dimensions for the target database engine whether or not you are authorized to access them.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthorizedActions} method.
     * </p>
     * 
     * @return The actions to discover the dimensions you are authorized to access. If you specify multiple actions,
     *         then the response will contain the dimensions common for all the actions.</p>
     *         <p>
     *         When you don't specify this request parameter or provide an empty list, the response contains all the
     *         available dimensions for the target database engine whether or not you are authorized to access them.
     */
    public final List<FineGrainedAction> authorizedActions() {
        return AuthorizedActionsListCopier.copyStringToEnum(authorizedActions);
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthorizedActions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAuthorizedActions() {
        return authorizedActions != null && !(authorizedActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions to discover the dimensions you are authorized to access. If you specify multiple actions, then the
     * response will contain the dimensions common for all the actions.
     * </p>
     * <p>
     * When you don't specify this request parameter or provide an empty list, the response contains all the available
     * dimensions for the target database engine whether or not you are authorized to access them.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthorizedActions} method.
     * </p>
     * 
     * @return The actions to discover the dimensions you are authorized to access. If you specify multiple actions,
     *         then the response will contain the dimensions common for all the actions.</p>
     *         <p>
     *         When you don't specify this request parameter or provide an empty list, the response contains all the
     *         available dimensions for the target database engine whether or not you are authorized to access them.
     */
    public final List<String> authorizedActionsAsStrings() {
        return authorizedActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetrics() ? metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthorizedActions() ? authorizedActionsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAvailableResourceDimensionsRequest)) {
            return false;
        }
        ListAvailableResourceDimensionsRequest other = (ListAvailableResourceDimensionsRequest) obj;
        return Objects.equals(serviceTypeAsString(), other.serviceTypeAsString())
                && Objects.equals(identifier(), other.identifier()) && hasMetrics() == other.hasMetrics()
                && Objects.equals(metrics(), other.metrics()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && hasAuthorizedActions() == other.hasAuthorizedActions()
                && Objects.equals(authorizedActionsAsStrings(), other.authorizedActionsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAvailableResourceDimensionsRequest").add("ServiceType", serviceTypeAsString())
                .add("Identifier", identifier()).add("Metrics", hasMetrics() ? metrics() : null).add("MaxResults", maxResults())
                .add("NextToken", nextToken())
                .add("AuthorizedActions", hasAuthorizedActions() ? authorizedActionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceType":
            return Optional.ofNullable(clazz.cast(serviceTypeAsString()));
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "Metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "AuthorizedActions":
            return Optional.ofNullable(clazz.cast(authorizedActionsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServiceType", SERVICE_TYPE_FIELD);
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("Metrics", METRICS_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("AuthorizedActions", AUTHORIZED_ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAvailableResourceDimensionsRequest, T> g) {
        return obj -> g.apply((ListAvailableResourceDimensionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PiRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAvailableResourceDimensionsRequest> {
        /**
         * <p>
         * The Amazon Web Services service for which Performance Insights returns metrics.
         * </p>
         * 
         * @param serviceType
         *        The Amazon Web Services service for which Performance Insights returns metrics.
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder serviceType(String serviceType);

        /**
         * <p>
         * The Amazon Web Services service for which Performance Insights returns metrics.
         * </p>
         * 
         * @param serviceType
         *        The Amazon Web Services service for which Performance Insights returns metrics.
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder serviceType(ServiceType serviceType);

        /**
         * <p>
         * An immutable identifier for a data source that is unique within an Amazon Web Services Region. Performance
         * Insights gathers metrics from this data source. To use an Amazon RDS DB instance as a data source, specify
         * its <code>DbiResourceId</code> value. For example, specify <code>db-ABCDEFGHIJKLMNOPQRSTU1VWZ</code>.
         * </p>
         * 
         * @param identifier
         *        An immutable identifier for a data source that is unique within an Amazon Web Services Region.
         *        Performance Insights gathers metrics from this data source. To use an Amazon RDS DB instance as a data
         *        source, specify its <code>DbiResourceId</code> value. For example, specify
         *        <code>db-ABCDEFGHIJKLMNOPQRSTU1VWZ</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The types of metrics for which to retrieve dimensions. Valid values include <code>db.load</code>.
         * </p>
         * 
         * @param metrics
         *        The types of metrics for which to retrieve dimensions. Valid values include <code>db.load</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Collection<String> metrics);

        /**
         * <p>
         * The types of metrics for which to retrieve dimensions. Valid values include <code>db.load</code>.
         * </p>
         * 
         * @param metrics
         *        The types of metrics for which to retrieve dimensions. Valid values include <code>db.load</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(String... metrics);

        /**
         * <p>
         * The maximum number of items to return in the response. If more items exist than the specified
         * <code>MaxRecords</code> value, a pagination token is included in the response so that the remaining results
         * can be retrieved.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return in the response. If more items exist than the specified
         *        <code>MaxRecords</code> value, a pagination token is included in the response so that the remaining
         *        results can be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param nextToken
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The actions to discover the dimensions you are authorized to access. If you specify multiple actions, then
         * the response will contain the dimensions common for all the actions.
         * </p>
         * <p>
         * When you don't specify this request parameter or provide an empty list, the response contains all the
         * available dimensions for the target database engine whether or not you are authorized to access them.
         * </p>
         * 
         * @param authorizedActions
         *        The actions to discover the dimensions you are authorized to access. If you specify multiple actions,
         *        then the response will contain the dimensions common for all the actions.</p>
         *        <p>
         *        When you don't specify this request parameter or provide an empty list, the response contains all the
         *        available dimensions for the target database engine whether or not you are authorized to access them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedActionsWithStrings(Collection<String> authorizedActions);

        /**
         * <p>
         * The actions to discover the dimensions you are authorized to access. If you specify multiple actions, then
         * the response will contain the dimensions common for all the actions.
         * </p>
         * <p>
         * When you don't specify this request parameter or provide an empty list, the response contains all the
         * available dimensions for the target database engine whether or not you are authorized to access them.
         * </p>
         * 
         * @param authorizedActions
         *        The actions to discover the dimensions you are authorized to access. If you specify multiple actions,
         *        then the response will contain the dimensions common for all the actions.</p>
         *        <p>
         *        When you don't specify this request parameter or provide an empty list, the response contains all the
         *        available dimensions for the target database engine whether or not you are authorized to access them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedActionsWithStrings(String... authorizedActions);

        /**
         * <p>
         * The actions to discover the dimensions you are authorized to access. If you specify multiple actions, then
         * the response will contain the dimensions common for all the actions.
         * </p>
         * <p>
         * When you don't specify this request parameter or provide an empty list, the response contains all the
         * available dimensions for the target database engine whether or not you are authorized to access them.
         * </p>
         * 
         * @param authorizedActions
         *        The actions to discover the dimensions you are authorized to access. If you specify multiple actions,
         *        then the response will contain the dimensions common for all the actions.</p>
         *        <p>
         *        When you don't specify this request parameter or provide an empty list, the response contains all the
         *        available dimensions for the target database engine whether or not you are authorized to access them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedActions(Collection<FineGrainedAction> authorizedActions);

        /**
         * <p>
         * The actions to discover the dimensions you are authorized to access. If you specify multiple actions, then
         * the response will contain the dimensions common for all the actions.
         * </p>
         * <p>
         * When you don't specify this request parameter or provide an empty list, the response contains all the
         * available dimensions for the target database engine whether or not you are authorized to access them.
         * </p>
         * 
         * @param authorizedActions
         *        The actions to discover the dimensions you are authorized to access. If you specify multiple actions,
         *        then the response will contain the dimensions common for all the actions.</p>
         *        <p>
         *        When you don't specify this request parameter or provide an empty list, the response contains all the
         *        available dimensions for the target database engine whether or not you are authorized to access them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedActions(FineGrainedAction... authorizedActions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PiRequest.BuilderImpl implements Builder {
        private String serviceType;

        private String identifier;

        private List<String> metrics = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private List<String> authorizedActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAvailableResourceDimensionsRequest model) {
            super(model);
            serviceType(model.serviceType);
            identifier(model.identifier);
            metrics(model.metrics);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            authorizedActionsWithStrings(model.authorizedActions);
        }

        public final String getServiceType() {
            return serviceType;
        }

        public final void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        @Override
        public final Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @Override
        public final Builder serviceType(ServiceType serviceType) {
            this.serviceType(serviceType == null ? null : serviceType.toString());
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final Collection<String> getMetrics() {
            if (metrics instanceof SdkAutoConstructList) {
                return null;
            }
            return metrics;
        }

        public final void setMetrics(Collection<String> metrics) {
            this.metrics = DimensionsMetricListCopier.copy(metrics);
        }

        @Override
        public final Builder metrics(Collection<String> metrics) {
            this.metrics = DimensionsMetricListCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(String... metrics) {
            metrics(Arrays.asList(metrics));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getAuthorizedActions() {
            if (authorizedActions instanceof SdkAutoConstructList) {
                return null;
            }
            return authorizedActions;
        }

        public final void setAuthorizedActions(Collection<String> authorizedActions) {
            this.authorizedActions = AuthorizedActionsListCopier.copy(authorizedActions);
        }

        @Override
        public final Builder authorizedActionsWithStrings(Collection<String> authorizedActions) {
            this.authorizedActions = AuthorizedActionsListCopier.copy(authorizedActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedActionsWithStrings(String... authorizedActions) {
            authorizedActionsWithStrings(Arrays.asList(authorizedActions));
            return this;
        }

        @Override
        public final Builder authorizedActions(Collection<FineGrainedAction> authorizedActions) {
            this.authorizedActions = AuthorizedActionsListCopier.copyEnumToString(authorizedActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedActions(FineGrainedAction... authorizedActions) {
            authorizedActions(Arrays.asList(authorizedActions));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAvailableResourceDimensionsRequest build() {
            return new ListAvailableResourceDimensionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
