/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAvailableResourceMetricsRequest extends PiRequest implements
        ToCopyableBuilder<ListAvailableResourceMetricsRequest.Builder, ListAvailableResourceMetricsRequest> {
    private static final SdkField<String> SERVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceType").getter(getter(ListAvailableResourceMetricsRequest::serviceTypeAsString))
            .setter(setter(Builder::serviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceType").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(ListAvailableResourceMetricsRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<List<String>> METRIC_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MetricTypes")
            .getter(getter(ListAvailableResourceMetricsRequest::metricTypes))
            .setter(setter(Builder::metricTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAvailableResourceMetricsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListAvailableResourceMetricsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_TYPE_FIELD,
            IDENTIFIER_FIELD, METRIC_TYPES_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String serviceType;

    private final String identifier;

    private final List<String> metricTypes;

    private final String nextToken;

    private final Integer maxResults;

    private ListAvailableResourceMetricsRequest(BuilderImpl builder) {
        super(builder);
        this.serviceType = builder.serviceType;
        this.identifier = builder.identifier;
        this.metricTypes = builder.metricTypes;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The Amazon Web Services service for which Performance Insights returns metrics.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceType} will
     * return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceTypeAsString}.
     * </p>
     * 
     * @return The Amazon Web Services service for which Performance Insights returns metrics.
     * @see ServiceType
     */
    public final ServiceType serviceType() {
        return ServiceType.fromValue(serviceType);
    }

    /**
     * <p>
     * The Amazon Web Services service for which Performance Insights returns metrics.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceType} will
     * return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceTypeAsString}.
     * </p>
     * 
     * @return The Amazon Web Services service for which Performance Insights returns metrics.
     * @see ServiceType
     */
    public final String serviceTypeAsString() {
        return serviceType;
    }

    /**
     * <p>
     * An immutable identifier for a data source that is unique within an Amazon Web Services Region. Performance
     * Insights gathers metrics from this data source. To use an Amazon RDS DB instance as a data source, specify its
     * <code>DbiResourceId</code> value. For example, specify <code>db-ABCDEFGHIJKLMNOPQRSTU1VWZ</code>.
     * </p>
     * 
     * @return An immutable identifier for a data source that is unique within an Amazon Web Services Region.
     *         Performance Insights gathers metrics from this data source. To use an Amazon RDS DB instance as a data
     *         source, specify its <code>DbiResourceId</code> value. For example, specify
     *         <code>db-ABCDEFGHIJKLMNOPQRSTU1VWZ</code>.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricTypes() {
        return metricTypes != null && !(metricTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The types of metrics to return in the response. Valid values in the array include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>os</code> (OS counter metrics) - All engines
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db</code> (DB load metrics) - All engines except for Amazon DocumentDB
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.stats</code> (per-SQL metrics) - All engines except for Amazon DocumentDB
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized.stats</code> (per-SQL digest metrics) - All engines except for Amazon DocumentDB
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricTypes} method.
     * </p>
     * 
     * @return The types of metrics to return in the response. Valid values in the array include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>os</code> (OS counter metrics) - All engines
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db</code> (DB load metrics) - All engines except for Amazon DocumentDB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.sql.stats</code> (per-SQL metrics) - All engines except for Amazon DocumentDB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.sql_tokenized.stats</code> (per-SQL digest metrics) - All engines except for Amazon DocumentDB
     *         </p>
     *         </li>
     */
    public final List<String> metricTypes() {
        return metricTypes;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return. If the <code>MaxRecords</code> value is less than the number of existing
     * items, the response includes a pagination token.
     * </p>
     * 
     * @return The maximum number of items to return. If the <code>MaxRecords</code> value is less than the number of
     *         existing items, the response includes a pagination token.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricTypes() ? metricTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAvailableResourceMetricsRequest)) {
            return false;
        }
        ListAvailableResourceMetricsRequest other = (ListAvailableResourceMetricsRequest) obj;
        return Objects.equals(serviceTypeAsString(), other.serviceTypeAsString())
                && Objects.equals(identifier(), other.identifier()) && hasMetricTypes() == other.hasMetricTypes()
                && Objects.equals(metricTypes(), other.metricTypes()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAvailableResourceMetricsRequest").add("ServiceType", serviceTypeAsString())
                .add("Identifier", identifier()).add("MetricTypes", hasMetricTypes() ? metricTypes() : null)
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceType":
            return Optional.ofNullable(clazz.cast(serviceTypeAsString()));
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "MetricTypes":
            return Optional.ofNullable(clazz.cast(metricTypes()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServiceType", SERVICE_TYPE_FIELD);
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("MetricTypes", METRIC_TYPES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAvailableResourceMetricsRequest, T> g) {
        return obj -> g.apply((ListAvailableResourceMetricsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PiRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAvailableResourceMetricsRequest> {
        /**
         * <p>
         * The Amazon Web Services service for which Performance Insights returns metrics.
         * </p>
         * 
         * @param serviceType
         *        The Amazon Web Services service for which Performance Insights returns metrics.
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder serviceType(String serviceType);

        /**
         * <p>
         * The Amazon Web Services service for which Performance Insights returns metrics.
         * </p>
         * 
         * @param serviceType
         *        The Amazon Web Services service for which Performance Insights returns metrics.
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder serviceType(ServiceType serviceType);

        /**
         * <p>
         * An immutable identifier for a data source that is unique within an Amazon Web Services Region. Performance
         * Insights gathers metrics from this data source. To use an Amazon RDS DB instance as a data source, specify
         * its <code>DbiResourceId</code> value. For example, specify <code>db-ABCDEFGHIJKLMNOPQRSTU1VWZ</code>.
         * </p>
         * 
         * @param identifier
         *        An immutable identifier for a data source that is unique within an Amazon Web Services Region.
         *        Performance Insights gathers metrics from this data source. To use an Amazon RDS DB instance as a data
         *        source, specify its <code>DbiResourceId</code> value. For example, specify
         *        <code>db-ABCDEFGHIJKLMNOPQRSTU1VWZ</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The types of metrics to return in the response. Valid values in the array include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>os</code> (OS counter metrics) - All engines
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>db</code> (DB load metrics) - All engines except for Amazon DocumentDB
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>db.sql.stats</code> (per-SQL metrics) - All engines except for Amazon DocumentDB
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>db.sql_tokenized.stats</code> (per-SQL digest metrics) - All engines except for Amazon DocumentDB
         * </p>
         * </li>
         * </ul>
         * 
         * @param metricTypes
         *        The types of metrics to return in the response. Valid values in the array include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>os</code> (OS counter metrics) - All engines
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>db</code> (DB load metrics) - All engines except for Amazon DocumentDB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>db.sql.stats</code> (per-SQL metrics) - All engines except for Amazon DocumentDB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>db.sql_tokenized.stats</code> (per-SQL digest metrics) - All engines except for Amazon
         *        DocumentDB
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricTypes(Collection<String> metricTypes);

        /**
         * <p>
         * The types of metrics to return in the response. Valid values in the array include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>os</code> (OS counter metrics) - All engines
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>db</code> (DB load metrics) - All engines except for Amazon DocumentDB
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>db.sql.stats</code> (per-SQL metrics) - All engines except for Amazon DocumentDB
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>db.sql_tokenized.stats</code> (per-SQL digest metrics) - All engines except for Amazon DocumentDB
         * </p>
         * </li>
         * </ul>
         * 
         * @param metricTypes
         *        The types of metrics to return in the response. Valid values in the array include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>os</code> (OS counter metrics) - All engines
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>db</code> (DB load metrics) - All engines except for Amazon DocumentDB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>db.sql.stats</code> (per-SQL metrics) - All engines except for Amazon DocumentDB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>db.sql_tokenized.stats</code> (per-SQL digest metrics) - All engines except for Amazon
         *        DocumentDB
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricTypes(String... metricTypes);

        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param nextToken
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return. If the <code>MaxRecords</code> value is less than the number of
         * existing items, the response includes a pagination token.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return. If the <code>MaxRecords</code> value is less than the number of
         *        existing items, the response includes a pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PiRequest.BuilderImpl implements Builder {
        private String serviceType;

        private String identifier;

        private List<String> metricTypes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAvailableResourceMetricsRequest model) {
            super(model);
            serviceType(model.serviceType);
            identifier(model.identifier);
            metricTypes(model.metricTypes);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getServiceType() {
            return serviceType;
        }

        public final void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        @Override
        public final Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @Override
        public final Builder serviceType(ServiceType serviceType) {
            this.serviceType(serviceType == null ? null : serviceType.toString());
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final Collection<String> getMetricTypes() {
            if (metricTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return metricTypes;
        }

        public final void setMetricTypes(Collection<String> metricTypes) {
            this.metricTypes = MetricTypeListCopier.copy(metricTypes);
        }

        @Override
        public final Builder metricTypes(Collection<String> metricTypes) {
            this.metricTypes = MetricTypeListCopier.copy(metricTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricTypes(String... metricTypes) {
            metricTypes(Arrays.asList(metricTypes));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAvailableResourceMetricsRequest build() {
            return new ListAvailableResourceMetricsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
