/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPerformanceAnalysisReportsRequest extends PiRequest implements
        ToCopyableBuilder<ListPerformanceAnalysisReportsRequest.Builder, ListPerformanceAnalysisReportsRequest> {
    private static final SdkField<String> SERVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceType").getter(getter(ListPerformanceAnalysisReportsRequest::serviceTypeAsString))
            .setter(setter(Builder::serviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceType").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(ListPerformanceAnalysisReportsRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPerformanceAnalysisReportsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListPerformanceAnalysisReportsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<Boolean> LIST_TAGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ListTags").getter(getter(ListPerformanceAnalysisReportsRequest::listTags))
            .setter(setter(Builder::listTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListTags").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_TYPE_FIELD,
            IDENTIFIER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, LIST_TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String serviceType;

    private final String identifier;

    private final String nextToken;

    private final Integer maxResults;

    private final Boolean listTags;

    private ListPerformanceAnalysisReportsRequest(BuilderImpl builder) {
        super(builder);
        this.serviceType = builder.serviceType;
        this.identifier = builder.identifier;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.listTags = builder.listTags;
    }

    /**
     * <p>
     * The Amazon Web Services service for which Performance Insights returns metrics. Valid value is <code>RDS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceType} will
     * return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceTypeAsString}.
     * </p>
     * 
     * @return The Amazon Web Services service for which Performance Insights returns metrics. Valid value is
     *         <code>RDS</code>.
     * @see ServiceType
     */
    public final ServiceType serviceType() {
        return ServiceType.fromValue(serviceType);
    }

    /**
     * <p>
     * The Amazon Web Services service for which Performance Insights returns metrics. Valid value is <code>RDS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceType} will
     * return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceTypeAsString}.
     * </p>
     * 
     * @return The Amazon Web Services service for which Performance Insights returns metrics. Valid value is
     *         <code>RDS</code>.
     * @see ServiceType
     */
    public final String serviceTypeAsString() {
        return serviceType;
    }

    /**
     * <p>
     * An immutable identifier for a data source that is unique for an Amazon Web Services Region. Performance Insights
     * gathers metrics from this data source. In the console, the identifier is shown as <i>ResourceID</i>. When you
     * call <code>DescribeDBInstances</code>, the identifier is returned as <code>DbiResourceId</code>.
     * </p>
     * <p>
     * To use a DB instance as a data source, specify its <code>DbiResourceId</code> value. For example, specify
     * <code>db-ABCDEFGHIJKLMNOPQRSTU1VW2X</code>.
     * </p>
     * 
     * @return An immutable identifier for a data source that is unique for an Amazon Web Services Region. Performance
     *         Insights gathers metrics from this data source. In the console, the identifier is shown as
     *         <i>ResourceID</i>. When you call <code>DescribeDBInstances</code>, the identifier is returned as
     *         <code>DbiResourceId</code>.</p>
     *         <p>
     *         To use a DB instance as a data source, specify its <code>DbiResourceId</code> value. For example, specify
     *         <code>db-ABCDEFGHIJKLMNOPQRSTU1VW2X</code>.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the token, up to the value specified by <code>MaxResults</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the token, up to the value specified by <code>MaxResults</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return in the response. If more items exist than the specified
     * <code>MaxResults</code> value, a pagination token is included in the response so that the remaining results can
     * be retrieved.
     * </p>
     * 
     * @return The maximum number of items to return in the response. If more items exist than the specified
     *         <code>MaxResults</code> value, a pagination token is included in the response so that the remaining
     *         results can be retrieved.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Specifies whether or not to include the list of tags in the response.
     * </p>
     * 
     * @return Specifies whether or not to include the list of tags in the response.
     */
    public final Boolean listTags() {
        return listTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(listTags());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPerformanceAnalysisReportsRequest)) {
            return false;
        }
        ListPerformanceAnalysisReportsRequest other = (ListPerformanceAnalysisReportsRequest) obj;
        return Objects.equals(serviceTypeAsString(), other.serviceTypeAsString())
                && Objects.equals(identifier(), other.identifier()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(listTags(), other.listTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPerformanceAnalysisReportsRequest").add("ServiceType", serviceTypeAsString())
                .add("Identifier", identifier()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("ListTags", listTags()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceType":
            return Optional.ofNullable(clazz.cast(serviceTypeAsString()));
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "ListTags":
            return Optional.ofNullable(clazz.cast(listTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServiceType", SERVICE_TYPE_FIELD);
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("ListTags", LIST_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPerformanceAnalysisReportsRequest, T> g) {
        return obj -> g.apply((ListPerformanceAnalysisReportsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PiRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListPerformanceAnalysisReportsRequest> {
        /**
         * <p>
         * The Amazon Web Services service for which Performance Insights returns metrics. Valid value is
         * <code>RDS</code>.
         * </p>
         * 
         * @param serviceType
         *        The Amazon Web Services service for which Performance Insights returns metrics. Valid value is
         *        <code>RDS</code>.
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder serviceType(String serviceType);

        /**
         * <p>
         * The Amazon Web Services service for which Performance Insights returns metrics. Valid value is
         * <code>RDS</code>.
         * </p>
         * 
         * @param serviceType
         *        The Amazon Web Services service for which Performance Insights returns metrics. Valid value is
         *        <code>RDS</code>.
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder serviceType(ServiceType serviceType);

        /**
         * <p>
         * An immutable identifier for a data source that is unique for an Amazon Web Services Region. Performance
         * Insights gathers metrics from this data source. In the console, the identifier is shown as <i>ResourceID</i>.
         * When you call <code>DescribeDBInstances</code>, the identifier is returned as <code>DbiResourceId</code>.
         * </p>
         * <p>
         * To use a DB instance as a data source, specify its <code>DbiResourceId</code> value. For example, specify
         * <code>db-ABCDEFGHIJKLMNOPQRSTU1VW2X</code>.
         * </p>
         * 
         * @param identifier
         *        An immutable identifier for a data source that is unique for an Amazon Web Services Region.
         *        Performance Insights gathers metrics from this data source. In the console, the identifier is shown as
         *        <i>ResourceID</i>. When you call <code>DescribeDBInstances</code>, the identifier is returned as
         *        <code>DbiResourceId</code>.</p>
         *        <p>
         *        To use a DB instance as a data source, specify its <code>DbiResourceId</code> value. For example,
         *        specify <code>db-ABCDEFGHIJKLMNOPQRSTU1VW2X</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the token, up to the value specified by <code>MaxResults</code>.
         * </p>
         * 
         * @param nextToken
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the token, up to the value specified by <code>MaxResults</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return in the response. If more items exist than the specified
         * <code>MaxResults</code> value, a pagination token is included in the response so that the remaining results
         * can be retrieved.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return in the response. If more items exist than the specified
         *        <code>MaxResults</code> value, a pagination token is included in the response so that the remaining
         *        results can be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Specifies whether or not to include the list of tags in the response.
         * </p>
         * 
         * @param listTags
         *        Specifies whether or not to include the list of tags in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listTags(Boolean listTags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PiRequest.BuilderImpl implements Builder {
        private String serviceType;

        private String identifier;

        private String nextToken;

        private Integer maxResults;

        private Boolean listTags;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPerformanceAnalysisReportsRequest model) {
            super(model);
            serviceType(model.serviceType);
            identifier(model.identifier);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            listTags(model.listTags);
        }

        public final String getServiceType() {
            return serviceType;
        }

        public final void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        @Override
        public final Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @Override
        public final Builder serviceType(ServiceType serviceType) {
            this.serviceType(serviceType == null ? null : serviceType.toString());
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Boolean getListTags() {
            return listTags;
        }

        public final void setListTags(Boolean listTags) {
            this.listTags = listTags;
        }

        @Override
        public final Builder listTags(Boolean listTags) {
            this.listTags = listTags;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPerformanceAnalysisReportsRequest build() {
            return new ListPerformanceAnalysisReportsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
