/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.pi.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DimensionGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DimensionGroup> {
    private static final SdkField<String> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DimensionGroup.getter(DimensionGroup::group)).setter(DimensionGroup.setter(Builder::group)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").build()}).build();
    private static final SdkField<List<String>> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DimensionGroup.getter(DimensionGroup::dimensions)).setter(DimensionGroup.setter(Builder::dimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DimensionGroup.getter(DimensionGroup::limit)).setter(DimensionGroup.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_FIELD, DIMENSIONS_FIELD, LIMIT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String group;
    private final List<String> dimensions;
    private final Integer limit;

    private DimensionGroup(BuilderImpl builder) {
        this.group = builder.group;
        this.dimensions = builder.dimensions;
        this.limit = builder.limit;
    }

    public String group() {
        return this.group;
    }

    public List<String> dimensions() {
        return this.dimensions;
    }

    public Integer limit() {
        return this.limit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DimensionGroup)) {
            return false;
        }
        DimensionGroup other = (DimensionGroup)obj;
        return Objects.equals(this.group(), other.group()) && Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.limit(), other.limit());
    }

    public String toString() {
        return ToString.builder((String)"DimensionGroup").add("Group", (Object)this.group()).add("Dimensions", this.dimensions()).add("Limit", (Object)this.limit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DimensionGroup, T> g) {
        return obj -> g.apply((DimensionGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String group;
        private List<String> dimensions = DefaultSdkAutoConstructList.getInstance();
        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DimensionGroup model) {
            this.group(model.group);
            this.dimensions(model.dimensions);
            this.limit(model.limit);
        }

        public final String getGroup() {
            return this.group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        public final Collection<String> getDimensions() {
            return this.dimensions;
        }

        @Override
        public final Builder dimensions(Collection<String> dimensions) {
            this.dimensions = StringListCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(String ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        public final void setDimensions(Collection<String> dimensions) {
            this.dimensions = StringListCopier.copy(dimensions);
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public DimensionGroup build() {
            return new DimensionGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DimensionGroup> {
        public Builder group(String var1);

        public Builder dimensions(Collection<String> var1);

        public Builder dimensions(String ... var1);

        public Builder limit(Integer var1);
    }
}

