/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Apple Development Push Notification Service channel definition.
 */
@Generated("software.amazon.awssdk:codegen")
public final class APNSSandboxChannelRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<APNSSandboxChannelRequest.Builder, APNSSandboxChannelRequest> {
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(APNSSandboxChannelRequest::bundleId)).setter(setter(Builder::bundleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleId").build()).build();

    private static final SdkField<String> CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(APNSSandboxChannelRequest::certificate)).setter(setter(Builder::certificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()).build();

    private static final SdkField<String> DEFAULT_AUTHENTICATION_METHOD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(APNSSandboxChannelRequest::defaultAuthenticationMethod))
            .setter(setter(Builder::defaultAuthenticationMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAuthenticationMethod")
                    .build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(APNSSandboxChannelRequest::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<String> PRIVATE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(APNSSandboxChannelRequest::privateKey)).setter(setter(Builder::privateKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateKey").build()).build();

    private static final SdkField<String> TEAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(APNSSandboxChannelRequest::teamId)).setter(setter(Builder::teamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TeamId").build()).build();

    private static final SdkField<String> TOKEN_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(APNSSandboxChannelRequest::tokenKey)).setter(setter(Builder::tokenKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenKey").build()).build();

    private static final SdkField<String> TOKEN_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(APNSSandboxChannelRequest::tokenKeyId)).setter(setter(Builder::tokenKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLE_ID_FIELD,
            CERTIFICATE_FIELD, DEFAULT_AUTHENTICATION_METHOD_FIELD, ENABLED_FIELD, PRIVATE_KEY_FIELD, TEAM_ID_FIELD,
            TOKEN_KEY_FIELD, TOKEN_KEY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bundleId;

    private final String certificate;

    private final String defaultAuthenticationMethod;

    private final Boolean enabled;

    private final String privateKey;

    private final String teamId;

    private final String tokenKey;

    private final String tokenKeyId;

    private APNSSandboxChannelRequest(BuilderImpl builder) {
        this.bundleId = builder.bundleId;
        this.certificate = builder.certificate;
        this.defaultAuthenticationMethod = builder.defaultAuthenticationMethod;
        this.enabled = builder.enabled;
        this.privateKey = builder.privateKey;
        this.teamId = builder.teamId;
        this.tokenKey = builder.tokenKey;
        this.tokenKeyId = builder.tokenKeyId;
    }

    /**
     * The bundle id used for APNs Tokens.
     * 
     * @return The bundle id used for APNs Tokens.
     */
    public String bundleId() {
        return bundleId;
    }

    /**
     * The distribution certificate from Apple.
     * 
     * @return The distribution certificate from Apple.
     */
    public String certificate() {
        return certificate;
    }

    /**
     * The default authentication method used for APNs.
     * 
     * @return The default authentication method used for APNs.
     */
    public String defaultAuthenticationMethod() {
        return defaultAuthenticationMethod;
    }

    /**
     * If the channel is enabled for sending messages.
     * 
     * @return If the channel is enabled for sending messages.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * The certificate private key.
     * 
     * @return The certificate private key.
     */
    public String privateKey() {
        return privateKey;
    }

    /**
     * The team id used for APNs Tokens.
     * 
     * @return The team id used for APNs Tokens.
     */
    public String teamId() {
        return teamId;
    }

    /**
     * The token key used for APNs Tokens.
     * 
     * @return The token key used for APNs Tokens.
     */
    public String tokenKey() {
        return tokenKey;
    }

    /**
     * The token key used for APNs Tokens.
     * 
     * @return The token key used for APNs Tokens.
     */
    public String tokenKeyId() {
        return tokenKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(certificate());
        hashCode = 31 * hashCode + Objects.hashCode(defaultAuthenticationMethod());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(privateKey());
        hashCode = 31 * hashCode + Objects.hashCode(teamId());
        hashCode = 31 * hashCode + Objects.hashCode(tokenKey());
        hashCode = 31 * hashCode + Objects.hashCode(tokenKeyId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof APNSSandboxChannelRequest)) {
            return false;
        }
        APNSSandboxChannelRequest other = (APNSSandboxChannelRequest) obj;
        return Objects.equals(bundleId(), other.bundleId()) && Objects.equals(certificate(), other.certificate())
                && Objects.equals(defaultAuthenticationMethod(), other.defaultAuthenticationMethod())
                && Objects.equals(enabled(), other.enabled()) && Objects.equals(privateKey(), other.privateKey())
                && Objects.equals(teamId(), other.teamId()) && Objects.equals(tokenKey(), other.tokenKey())
                && Objects.equals(tokenKeyId(), other.tokenKeyId());
    }

    @Override
    public String toString() {
        return ToString.builder("APNSSandboxChannelRequest").add("BundleId", bundleId()).add("Certificate", certificate())
                .add("DefaultAuthenticationMethod", defaultAuthenticationMethod()).add("Enabled", enabled())
                .add("PrivateKey", privateKey()).add("TeamId", teamId()).add("TokenKey", tokenKey())
                .add("TokenKeyId", tokenKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BundleId":
            return Optional.ofNullable(clazz.cast(bundleId()));
        case "Certificate":
            return Optional.ofNullable(clazz.cast(certificate()));
        case "DefaultAuthenticationMethod":
            return Optional.ofNullable(clazz.cast(defaultAuthenticationMethod()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "PrivateKey":
            return Optional.ofNullable(clazz.cast(privateKey()));
        case "TeamId":
            return Optional.ofNullable(clazz.cast(teamId()));
        case "TokenKey":
            return Optional.ofNullable(clazz.cast(tokenKey()));
        case "TokenKeyId":
            return Optional.ofNullable(clazz.cast(tokenKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<APNSSandboxChannelRequest, T> g) {
        return obj -> g.apply((APNSSandboxChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, APNSSandboxChannelRequest> {
        /**
         * The bundle id used for APNs Tokens.
         * 
         * @param bundleId
         *        The bundle id used for APNs Tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleId(String bundleId);

        /**
         * The distribution certificate from Apple.
         * 
         * @param certificate
         *        The distribution certificate from Apple.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificate(String certificate);

        /**
         * The default authentication method used for APNs.
         * 
         * @param defaultAuthenticationMethod
         *        The default authentication method used for APNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultAuthenticationMethod(String defaultAuthenticationMethod);

        /**
         * If the channel is enabled for sending messages.
         * 
         * @param enabled
         *        If the channel is enabled for sending messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * The certificate private key.
         * 
         * @param privateKey
         *        The certificate private key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateKey(String privateKey);

        /**
         * The team id used for APNs Tokens.
         * 
         * @param teamId
         *        The team id used for APNs Tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teamId(String teamId);

        /**
         * The token key used for APNs Tokens.
         * 
         * @param tokenKey
         *        The token key used for APNs Tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenKey(String tokenKey);

        /**
         * The token key used for APNs Tokens.
         * 
         * @param tokenKeyId
         *        The token key used for APNs Tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenKeyId(String tokenKeyId);
    }

    static final class BuilderImpl implements Builder {
        private String bundleId;

        private String certificate;

        private String defaultAuthenticationMethod;

        private Boolean enabled;

        private String privateKey;

        private String teamId;

        private String tokenKey;

        private String tokenKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(APNSSandboxChannelRequest model) {
            bundleId(model.bundleId);
            certificate(model.certificate);
            defaultAuthenticationMethod(model.defaultAuthenticationMethod);
            enabled(model.enabled);
            privateKey(model.privateKey);
            teamId(model.teamId);
            tokenKey(model.tokenKey);
            tokenKeyId(model.tokenKeyId);
        }

        public final String getBundleId() {
            return bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final String getCertificate() {
            return certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        public final String getDefaultAuthenticationMethod() {
            return defaultAuthenticationMethod;
        }

        @Override
        public final Builder defaultAuthenticationMethod(String defaultAuthenticationMethod) {
            this.defaultAuthenticationMethod = defaultAuthenticationMethod;
            return this;
        }

        public final void setDefaultAuthenticationMethod(String defaultAuthenticationMethod) {
            this.defaultAuthenticationMethod = defaultAuthenticationMethod;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getPrivateKey() {
            return privateKey;
        }

        @Override
        public final Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public final void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public final String getTeamId() {
            return teamId;
        }

        @Override
        public final Builder teamId(String teamId) {
            this.teamId = teamId;
            return this;
        }

        public final void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        public final String getTokenKey() {
            return tokenKey;
        }

        @Override
        public final Builder tokenKey(String tokenKey) {
            this.tokenKey = tokenKey;
            return this;
        }

        public final void setTokenKey(String tokenKey) {
            this.tokenKey = tokenKey;
        }

        public final String getTokenKeyId() {
            return tokenKeyId;
        }

        @Override
        public final Builder tokenKeyId(String tokenKeyId) {
            this.tokenKeyId = tokenKeyId;
            return this;
        }

        public final void setTokenKeyId(String tokenKeyId) {
            this.tokenKeyId = tokenKeyId;
        }

        @Override
        public APNSSandboxChannelRequest build() {
            return new APNSSandboxChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
