/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Default Push Notification Message.
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultPushNotificationMessage implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultPushNotificationMessage.Builder, DefaultPushNotificationMessage> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DefaultPushNotificationMessage::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DefaultPushNotificationMessage::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()).build();

    private static final SdkField<Map<String, String>> DATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(DefaultPushNotificationMessage::data))
            .setter(setter(Builder::data))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> SILENT_PUSH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DefaultPushNotificationMessage::silentPush)).setter(setter(Builder::silentPush))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SilentPush").build()).build();

    private static final SdkField<Map<String, List<String>>> SUBSTITUTIONS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .getter(getter(DefaultPushNotificationMessage::substitutions))
            .setter(setter(Builder::substitutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Substitutions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DefaultPushNotificationMessage::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DefaultPushNotificationMessage::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, BODY_FIELD,
            DATA_FIELD, SILENT_PUSH_FIELD, SUBSTITUTIONS_FIELD, TITLE_FIELD, URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String action;

    private final String body;

    private final Map<String, String> data;

    private final Boolean silentPush;

    private final Map<String, List<String>> substitutions;

    private final String title;

    private final String url;

    private DefaultPushNotificationMessage(BuilderImpl builder) {
        this.action = builder.action;
        this.body = builder.body;
        this.data = builder.data;
        this.silentPush = builder.silentPush;
        this.substitutions = builder.substitutions;
        this.title = builder.title;
        this.url = builder.url;
    }

    /**
     * The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your app
     * launches, or it becomes the foreground app if it has been sent to the background. This is the default action.
     * DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display a designated user
     * interface within the app. URL - The default mobile browser on the user's device launches and opens a web page at
     * the URL you specify. Possible values include: OPEN_APP | DEEP_LINK | URL
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link Action#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your
     *         app launches, or it becomes the foreground app if it has been sent to the background. This is the default
     *         action. DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display a
     *         designated user interface within the app. URL - The default mobile browser on the user's device launches
     *         and opens a web page at the URL you specify. Possible values include: OPEN_APP | DEEP_LINK | URL
     * @see Action
     */
    public Action action() {
        return Action.fromValue(action);
    }

    /**
     * The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your app
     * launches, or it becomes the foreground app if it has been sent to the background. This is the default action.
     * DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display a designated user
     * interface within the app. URL - The default mobile browser on the user's device launches and opens a web page at
     * the URL you specify. Possible values include: OPEN_APP | DEEP_LINK | URL
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link Action#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your
     *         app launches, or it becomes the foreground app if it has been sent to the background. This is the default
     *         action. DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display a
     *         designated user interface within the app. URL - The default mobile browser on the user's device launches
     *         and opens a web page at the URL you specify. Possible values include: OPEN_APP | DEEP_LINK | URL
     * @see Action
     */
    public String actionAsString() {
        return action;
    }

    /**
     * The message body of the notification.
     * 
     * @return The message body of the notification.
     */
    public String body() {
        return body;
    }

    /**
     * The data payload used for a silent push. This payload is added to the notifications' data.pinpoint.jsonBody'
     * object
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The data payload used for a silent push. This payload is added to the notifications'
     *         data.pinpoint.jsonBody' object
     */
    public Map<String, String> data() {
        return data;
    }

    /**
     * Indicates if the message should display on the recipient's device. You can use silent pushes for remote
     * configuration or to deliver messages to in-app notification centers.
     * 
     * @return Indicates if the message should display on the recipient's device. You can use silent pushes for remote
     *         configuration or to deliver messages to in-app notification centers.
     */
    public Boolean silentPush() {
        return silentPush;
    }

    /**
     * Default message substitutions. Can be overridden by individual address substitutions.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Default message substitutions. Can be overridden by individual address substitutions.
     */
    public Map<String, List<String>> substitutions() {
        return substitutions;
    }

    /**
     * The message title that displays above the message on the user's device.
     * 
     * @return The message title that displays above the message on the user's device.
     */
    public String title() {
        return title;
    }

    /**
     * The URL to open in the user's mobile browser. Used if the value for Action is URL.
     * 
     * @return The URL to open in the user's mobile browser. Used if the value for Action is URL.
     */
    public String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(data());
        hashCode = 31 * hashCode + Objects.hashCode(silentPush());
        hashCode = 31 * hashCode + Objects.hashCode(substitutions());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultPushNotificationMessage)) {
            return false;
        }
        DefaultPushNotificationMessage other = (DefaultPushNotificationMessage) obj;
        return Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(body(), other.body())
                && Objects.equals(data(), other.data()) && Objects.equals(silentPush(), other.silentPush())
                && Objects.equals(substitutions(), other.substitutions()) && Objects.equals(title(), other.title())
                && Objects.equals(url(), other.url());
    }

    @Override
    public String toString() {
        return ToString.builder("DefaultPushNotificationMessage").add("Action", actionAsString()).add("Body", body())
                .add("Data", data()).add("SilentPush", silentPush()).add("Substitutions", substitutions()).add("Title", title())
                .add("Url", url()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "Body":
            return Optional.ofNullable(clazz.cast(body()));
        case "Data":
            return Optional.ofNullable(clazz.cast(data()));
        case "SilentPush":
            return Optional.ofNullable(clazz.cast(silentPush()));
        case "Substitutions":
            return Optional.ofNullable(clazz.cast(substitutions()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DefaultPushNotificationMessage, T> g) {
        return obj -> g.apply((DefaultPushNotificationMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultPushNotificationMessage> {
        /**
         * The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your app
         * launches, or it becomes the foreground app if it has been sent to the background. This is the default action.
         * DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display a designated user
         * interface within the app. URL - The default mobile browser on the user's device launches and opens a web page
         * at the URL you specify. Possible values include: OPEN_APP | DEEP_LINK | URL
         * 
         * @param action
         *        The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your
         *        app launches, or it becomes the foreground app if it has been sent to the background. This is the
         *        default action. DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display
         *        a designated user interface within the app. URL - The default mobile browser on the user's device
         *        launches and opens a web page at the URL you specify. Possible values include: OPEN_APP | DEEP_LINK |
         *        URL
         * @see Action
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Action
         */
        Builder action(String action);

        /**
         * The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your app
         * launches, or it becomes the foreground app if it has been sent to the background. This is the default action.
         * DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display a designated user
         * interface within the app. URL - The default mobile browser on the user's device launches and opens a web page
         * at the URL you specify. Possible values include: OPEN_APP | DEEP_LINK | URL
         * 
         * @param action
         *        The action that occurs if the user taps a push notification delivered by the campaign: OPEN_APP - Your
         *        app launches, or it becomes the foreground app if it has been sent to the background. This is the
         *        default action. DEEP_LINK - Uses deep linking features in iOS and Android to open your app and display
         *        a designated user interface within the app. URL - The default mobile browser on the user's device
         *        launches and opens a web page at the URL you specify. Possible values include: OPEN_APP | DEEP_LINK |
         *        URL
         * @see Action
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Action
         */
        Builder action(Action action);

        /**
         * The message body of the notification.
         * 
         * @param body
         *        The message body of the notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * The data payload used for a silent push. This payload is added to the notifications' data.pinpoint.jsonBody'
         * object
         * 
         * @param data
         *        The data payload used for a silent push. This payload is added to the notifications'
         *        data.pinpoint.jsonBody' object
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(Map<String, String> data);

        /**
         * Indicates if the message should display on the recipient's device. You can use silent pushes for remote
         * configuration or to deliver messages to in-app notification centers.
         * 
         * @param silentPush
         *        Indicates if the message should display on the recipient's device. You can use silent pushes for
         *        remote configuration or to deliver messages to in-app notification centers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder silentPush(Boolean silentPush);

        /**
         * Default message substitutions. Can be overridden by individual address substitutions.
         * 
         * @param substitutions
         *        Default message substitutions. Can be overridden by individual address substitutions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder substitutions(Map<String, ? extends Collection<String>> substitutions);

        /**
         * The message title that displays above the message on the user's device.
         * 
         * @param title
         *        The message title that displays above the message on the user's device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * The URL to open in the user's mobile browser. Used if the value for Action is URL.
         * 
         * @param url
         *        The URL to open in the user's mobile browser. Used if the value for Action is URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private String body;

        private Map<String, String> data = DefaultSdkAutoConstructMap.getInstance();

        private Boolean silentPush;

        private Map<String, List<String>> substitutions = DefaultSdkAutoConstructMap.getInstance();

        private String title;

        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultPushNotificationMessage model) {
            action(model.action);
            body(model.body);
            data(model.data);
            silentPush(model.silentPush);
            substitutions(model.substitutions);
            title(model.title);
            url(model.url);
        }

        public final String getAction() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(Action action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getBody() {
            return body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final Map<String, String> getData() {
            return data;
        }

        @Override
        public final Builder data(Map<String, String> data) {
            this.data = MapOf__stringCopier.copy(data);
            return this;
        }

        public final void setData(Map<String, String> data) {
            this.data = MapOf__stringCopier.copy(data);
        }

        public final Boolean getSilentPush() {
            return silentPush;
        }

        @Override
        public final Builder silentPush(Boolean silentPush) {
            this.silentPush = silentPush;
            return this;
        }

        public final void setSilentPush(Boolean silentPush) {
            this.silentPush = silentPush;
        }

        public final Map<String, ? extends Collection<String>> getSubstitutions() {
            return substitutions;
        }

        @Override
        public final Builder substitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
            return this;
        }

        public final void setSubstitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
        }

        public final String getTitle() {
            return title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public DefaultPushNotificationMessage build() {
            return new DefaultPushNotificationMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
