/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteApnsVoipSandboxChannelResponse extends PinpointResponse implements
        ToCopyableBuilder<DeleteApnsVoipSandboxChannelResponse.Builder, DeleteApnsVoipSandboxChannelResponse> {
    private static final SdkField<APNSVoipSandboxChannelResponse> APNS_VOIP_SANDBOX_CHANNEL_RESPONSE_FIELD = SdkField
            .<APNSVoipSandboxChannelResponse> builder(MarshallingType.SDK_POJO)
            .getter(getter(DeleteApnsVoipSandboxChannelResponse::apnsVoipSandboxChannelResponse))
            .setter(setter(Builder::apnsVoipSandboxChannelResponse))
            .constructor(APNSVoipSandboxChannelResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("APNSVoipSandboxChannelResponse")
                    .build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(APNS_VOIP_SANDBOX_CHANNEL_RESPONSE_FIELD));

    private final APNSVoipSandboxChannelResponse apnsVoipSandboxChannelResponse;

    private DeleteApnsVoipSandboxChannelResponse(BuilderImpl builder) {
        super(builder);
        this.apnsVoipSandboxChannelResponse = builder.apnsVoipSandboxChannelResponse;
    }

    /**
     * Returns the value of the APNSVoipSandboxChannelResponse property for this object.
     * 
     * @return The value of the APNSVoipSandboxChannelResponse property for this object.
     */
    public APNSVoipSandboxChannelResponse apnsVoipSandboxChannelResponse() {
        return apnsVoipSandboxChannelResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apnsVoipSandboxChannelResponse());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteApnsVoipSandboxChannelResponse)) {
            return false;
        }
        DeleteApnsVoipSandboxChannelResponse other = (DeleteApnsVoipSandboxChannelResponse) obj;
        return Objects.equals(apnsVoipSandboxChannelResponse(), other.apnsVoipSandboxChannelResponse());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteApnsVoipSandboxChannelResponse")
                .add("APNSVoipSandboxChannelResponse", apnsVoipSandboxChannelResponse()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "APNSVoipSandboxChannelResponse":
            return Optional.ofNullable(clazz.cast(apnsVoipSandboxChannelResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteApnsVoipSandboxChannelResponse, T> g) {
        return obj -> g.apply((DeleteApnsVoipSandboxChannelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteApnsVoipSandboxChannelResponse> {
        /**
         * Sets the value of the APNSVoipSandboxChannelResponse property for this object.
         *
         * @param apnsVoipSandboxChannelResponse
         *        The new value for the APNSVoipSandboxChannelResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apnsVoipSandboxChannelResponse(APNSVoipSandboxChannelResponse apnsVoipSandboxChannelResponse);

        /**
         * Sets the value of the APNSVoipSandboxChannelResponse property for this object.
         *
         * This is a convenience that creates an instance of the {@link APNSVoipSandboxChannelResponse.Builder} avoiding
         * the need to create one manually via {@link APNSVoipSandboxChannelResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link APNSVoipSandboxChannelResponse.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #apnsVoipSandboxChannelResponse(APNSVoipSandboxChannelResponse)}.
         * 
         * @param apnsVoipSandboxChannelResponse
         *        a consumer that will call methods on {@link APNSVoipSandboxChannelResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apnsVoipSandboxChannelResponse(APNSVoipSandboxChannelResponse)
         */
        default Builder apnsVoipSandboxChannelResponse(
                Consumer<APNSVoipSandboxChannelResponse.Builder> apnsVoipSandboxChannelResponse) {
            return apnsVoipSandboxChannelResponse(APNSVoipSandboxChannelResponse.builder()
                    .applyMutation(apnsVoipSandboxChannelResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private APNSVoipSandboxChannelResponse apnsVoipSandboxChannelResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteApnsVoipSandboxChannelResponse model) {
            super(model);
            apnsVoipSandboxChannelResponse(model.apnsVoipSandboxChannelResponse);
        }

        public final APNSVoipSandboxChannelResponse.Builder getAPNSVoipSandboxChannelResponse() {
            return apnsVoipSandboxChannelResponse != null ? apnsVoipSandboxChannelResponse.toBuilder() : null;
        }

        @Override
        public final Builder apnsVoipSandboxChannelResponse(APNSVoipSandboxChannelResponse apnsVoipSandboxChannelResponse) {
            this.apnsVoipSandboxChannelResponse = apnsVoipSandboxChannelResponse;
            return this;
        }

        public final void setAPNSVoipSandboxChannelResponse(
                APNSVoipSandboxChannelResponse.BuilderImpl apnsVoipSandboxChannelResponse) {
            this.apnsVoipSandboxChannelResponse = apnsVoipSandboxChannelResponse != null ? apnsVoipSandboxChannelResponse.build()
                    : null;
        }

        @Override
        public DeleteApnsVoipSandboxChannelResponse build() {
            return new DeleteApnsVoipSandboxChannelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
